/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authz;

import com.vmware.cis.authz.PrivilegeDefinitions;
import com.vmware.cis.authz.PrivilegeSyncProvider;
import com.vmware.cis.authz.PrivilegeTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class PrivilegeSyncApiInterface
extends ApiInterfaceSkeleton {
    private PrivilegeSyncProvider impl;

    public PrivilegeSyncApiInterface() {
        this((Class<? extends PrivilegeSyncProvider>)null);
    }

    public PrivilegeSyncApiInterface(Class<? extends PrivilegeSyncProvider> clazz) {
        this((PrivilegeSyncProvider)PrivilegeSyncApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.authz.impl.PrivilegeImpl", PrivilegeSyncProvider.class));
    }

    public PrivilegeSyncApiInterface(PrivilegeSyncProvider privilegeSyncProvider) {
        super("com.vmware.cis.authz.privilege");
        Validate.notNull((Object)privilegeSyncProvider);
        this.impl = privilegeSyncProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new QueryApiMethod());
        this.registerMethod((ApiMethod)new BatchQueryApiMethod());
        this.registerMethod((ApiMethod)new HasPrivilegesApiMethod());
        this.registerMethod((ApiMethod)new BatchHasPrivilegesApiMethod());
    }

    private class BatchHasPrivilegesApiMethod
    extends ApiMethodSkeleton {
        public BatchHasPrivilegesApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "batch_has_privileges", PrivilegeDefinitions.__batchHasPrivilegesInput, PrivilegeDefinitions.__batchHasPrivilegesOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__batchHasPrivilegesInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            PrivilegeTypes.BatchQuerySpec batchQuerySpec = (PrivilegeTypes.BatchQuerySpec)structValueExtractor.valueForField("query_spec");
            List list = (List)structValueExtractor.valueForField("privilege_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PrivilegeSyncApiInterface.this.getTypeConverter().convertToVapi(PrivilegeSyncApiInterface.this.impl.batchHasPrivileges(batchQuerySpec, list, invocationContext), PrivilegeDefinitions.__batchHasPrivilegesOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class HasPrivilegesApiMethod
    extends ApiMethodSkeleton {
        public HasPrivilegesApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "has_privileges", PrivilegeDefinitions.__hasPrivilegesInput, PrivilegeDefinitions.__hasPrivilegesOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__hasPrivilegesInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            PrivilegeTypes.QuerySpec querySpec = (PrivilegeTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            List list = (List)structValueExtractor.valueForField("privilege_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PrivilegeSyncApiInterface.this.getTypeConverter().convertToVapi((Object)PrivilegeSyncApiInterface.this.impl.hasPrivileges(querySpec, list, invocationContext), PrivilegeDefinitions.__hasPrivilegesOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class BatchQueryApiMethod
    extends ApiMethodSkeleton {
        public BatchQueryApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "batch_query", PrivilegeDefinitions.__batchQueryInput, PrivilegeDefinitions.__batchQueryOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__batchQueryInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            PrivilegeTypes.BatchQuerySpec batchQuerySpec = (PrivilegeTypes.BatchQuerySpec)structValueExtractor.valueForField("query_specs");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PrivilegeSyncApiInterface.this.getTypeConverter().convertToVapi(PrivilegeSyncApiInterface.this.impl.batchQuery(batchQuerySpec, invocationContext), PrivilegeDefinitions.__batchQueryOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class QueryApiMethod
    extends ApiMethodSkeleton {
        public QueryApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "query", PrivilegeDefinitions.__queryInput, PrivilegeDefinitions.__queryOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__queryInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            PrivilegeTypes.QuerySpec querySpec = (PrivilegeTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PrivilegeSyncApiInterface.this.getTypeConverter().convertToVapi(PrivilegeSyncApiInterface.this.impl.query(querySpec, invocationContext), PrivilegeDefinitions.__queryOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "list", PrivilegeDefinitions.__listInput, PrivilegeDefinitions.__listOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PrivilegeSyncApiInterface.this.getTypeConverter().convertToVapi(PrivilegeSyncApiInterface.this.impl.list(invocationContext), PrivilegeDefinitions.__listOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "delete", PrivilegeDefinitions.__deleteInput, PrivilegeDefinitions.__deleteOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__deleteInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            try {
                PrivilegeSyncApiInterface.this.impl.delete(string, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "update", PrivilegeDefinitions.__updateInput, PrivilegeDefinitions.__updateOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__updateInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PrivilegeTypes.UpdateSpec updateSpec = (PrivilegeTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            try {
                PrivilegeSyncApiInterface.this.impl.update(string, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "get", PrivilegeDefinitions.__getInput, PrivilegeDefinitions.__getOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__getInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)PrivilegeSyncApiInterface.this.getTypeConverter().convertToVapi((Object)PrivilegeSyncApiInterface.this.impl.get(string, invocationContext), PrivilegeDefinitions.__getOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(PrivilegeSyncApiInterface.this.getIdentifier(), "create", PrivilegeDefinitions.__createInput, PrivilegeDefinitions.__createOutput, PrivilegeSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__createInput, PrivilegeSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PrivilegeTypes.CreateSpec createSpec = (PrivilegeTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            try {
                PrivilegeSyncApiInterface.this.impl.create(string, createSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }
}

