<?xml version="1.0" encoding="utf-8"?>
<!-- Copyright 2010 VMware, Inc. All rights reserved. VMware Confidential  -->
<!--
   Style sheet for transforming OVF XML to HTML.

   Elements are indented and colored using span elements:
   Element names are blue (#0000ff), attribute values are brown (#990000).
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output indent="no" method="xml" omit-xml-declaration="yes"/>

   <!-- Template for a node with child elements -->
   <xsl:template match="*[*]" priority="20">
      <xsl:param name="textIndent">0</xsl:param>
      <div>
         <!-- Start element tag -->
         <span color="#0000ff">
            <xsl:call-template name="indent">
               <xsl:with-param name="count" select="$textIndent"/>
            </xsl:call-template>
            <xsl:text>&lt;</xsl:text>
            <xsl:value-of select="name(.)"/>
         </span>
         <!-- Namespace declarations -->
         <xsl:variable name="nodeName" select="name(.)"/>
         <xsl:for-each select="namespace::*">
            <xsl:call-template name="namespaceDeclaration">
               <xsl:with-param name="nodeName" select="$nodeName"/>
            </xsl:call-template>
         </xsl:for-each>
         <!-- Attributes -->
         <xsl:apply-templates select="@*"/>
         <span color="#0000ff">
            <xsl:text>></xsl:text>
         </span>
      </div>
      <!-- Child elements -->
      <xsl:apply-templates>
         <xsl:with-param name="textIndent" select="$textIndent + 3"/>
      </xsl:apply-templates>
      <!-- End element tag -->
      <div>
         <span color="#0000ff">
            <xsl:call-template name="indent">
               <xsl:with-param name="count" select="$textIndent"/>
            </xsl:call-template>
            <xsl:text>&lt;/</xsl:text>
            <xsl:value-of select="name(.)"/>
            <xsl:text>></xsl:text>
         </span>
      </div>
   </xsl:template>

   <!-- Template for a node without child elements (but text content) -->
   <xsl:template
      match="*[text() and not (comment() or processing-instruction())]">
      <xsl:param name="textIndent">0</xsl:param>
      <div>
         <!-- Start element tag -->
         <span color="#0000ff">
            <xsl:call-template name="indent">
               <xsl:with-param name="count" select="$textIndent"/>
            </xsl:call-template>
            <xsl:text>&lt;</xsl:text>
            <xsl:value-of select="name(.)"/>
         </span>
         <!-- Namespace declarations -->
         <xsl:variable name="nodeName" select="name(.)"/>
         <xsl:for-each select="namespace::*">
            <xsl:call-template name="namespaceDeclaration">
               <xsl:with-param name="nodeName" select="$nodeName"/>
            </xsl:call-template>
         </xsl:for-each>
         <!-- Attributes -->
         <xsl:apply-templates select="@*"/>
         <span color="#0000ff">
            <xsl:text>></xsl:text>
         </span>
         <!-- Text content -->
         <xsl:value-of select="."/>
         <!-- End element tag -->
         <span color="#0000ff">
            <xsl:text>&lt;/</xsl:text>
            <xsl:value-of select="name(.)"/>
            <xsl:text>></xsl:text>
         </span>
      </div>
   </xsl:template>

   <!--
      Template for empty nodes (nodes with child elements are handled by
      other templates).
   -->
   <xsl:template match="*">
      <xsl:param name="textIndent">0</xsl:param>
      <div>
         <!-- Start element tag -->
         <span color="#0000ff">
            <xsl:call-template name="indent">
               <xsl:with-param name="count" select="$textIndent"/>
            </xsl:call-template>
            <xsl:text>&lt;</xsl:text>
            <xsl:value-of select="name(.)"/>
         </span>
         <!-- Namespace declarations -->
         <xsl:variable name="nodeName" select="name(.)"/>
         <xsl:for-each select="namespace::*">
            <xsl:call-template name="namespaceDeclaration">
               <xsl:with-param name="nodeName" select="$nodeName"/>
            </xsl:call-template>
         </xsl:for-each>
         <!-- Attributes -->
         <xsl:apply-templates select="@*"/>
         <!-- End element tag -->
         <span color="#0000ff">
            <xsl:text>/></xsl:text>
         </span>
      </div>
   </xsl:template>

   <!-- Template for attribute nodes -->
   <xsl:template match="@*">
      <xsl:text> </xsl:text>
      <xsl:value-of select="name(.)"/>
      <xsl:text>="</xsl:text>
      <span color="#990000">
         <xsl:value-of select="."/>
      </span>
      <xsl:text>"</xsl:text>
   </xsl:template>

   <!--
      Template for namespace nodes (like xmlns:xsi). The if-test decides
      if the namespace is defined on the current node (if it is not
      defined by an ancestor).
   -->
   <xsl:template name="namespaceDeclaration">
      <xsl:param name="nodeName"/>
      <xsl:if test="$nodeName = name(..) and not(name() = 'xml')">
         <xsl:text> xmlns</xsl:text>
         <!-- The default namespace has no name -->
         <xsl:if test="name()">
            <xsl:text>:</xsl:text>
            <xsl:value-of select="name()"/>
         </xsl:if>
         <xsl:text>="</xsl:text>
         <span color="#990000">
            <xsl:value-of select="."/>
         </span>
         <xsl:text>"</xsl:text>
      </xsl:if>
   </xsl:template>

   <!-- Template to insert a number of spaces. Used to indent span elements. -->
   <xsl:template name="indent">
      <xsl:param name="count">0</xsl:param>
      <xsl:if test="$count > 0">
         <xsl:text> </xsl:text>
         <xsl:call-template name="indent">
            <xsl:with-param name="count" select="$count - 1"/>
         </xsl:call-template>
      </xsl:if>
   </xsl:template>

</xsl:stylesheet>
