/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.regex.Pattern;

public final class ExternalDomainAttributeMapping {
    private String _attributeId;
    private String _attributeName;
    private static Pattern keystringPattern = Pattern.compile("[a-zA-Z]([a-zA-Z0-9\\x2D])*");
    private static Pattern numericoidPattern = Pattern.compile("([0-9]|([1-9]([0-9])+))(\\x2E([0-9]|([1-9]([0-9])+)))+");

    public ExternalDomainAttributeMapping(String attributeId, String attributeName) {
        ExternalDomainAttributeMapping.validateId(attributeId, "attributeId");
        ExternalDomainAttributeMapping.validateName(attributeName, "attributeName");
        this._attributeId = attributeId;
        this._attributeName = attributeName;
    }

    public String getAttributeId() {
        return this._attributeId;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public String toString() {
        StringBuilder objString = new StringBuilder(100);
        objString.append(super.toString());
        objString.append(" [AttributeId=");
        objString.append(this._attributeId);
        objString.append(", AttributeName=");
        objString.append(this._attributeName);
        objString.append("]");
        return objString.toString();
    }

    static void validateId(String name, String fieldName) {
        ValidateUtil.validateNotEmpty(name, fieldName);
        if (!keystringPattern.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("[%s] value of [%s] is in unexpected format.", name, fieldName));
        }
    }

    static void validateName(String name, String fieldName) {
        ValidateUtil.validateNotEmpty(name, fieldName);
        if (!keystringPattern.matcher(name).matches() && !numericoidPattern.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("[%s] value of [%s] is in unexpected format.", name, fieldName));
        }
    }

    public static final class AttributeIds {
        public static final String UserAttributeAccountName = "UserAttributeAccountName";
        public static final String UserAttributeLastName = "UserAttributeLastName";
        public static final String UserAttributeFirstName = "UserAttributeFirstName";
        public static final String UserAttributeDescription = "UserAttributeDescription";
        public static final String UserAttributeDisplayName = "UserAttributeDisplayName";
        public static final String UserAttributeEmail = "UserAttributeEmail";
        public static final String UserAttributeObjectId = "UserAttributeObjectId";
        public static final String UserAttributePrincipalName = "UserAttributePrincipalName";
        public static final String UserAttributeAcountControl = "UserAttributeAcountControl";
        public static final String UserAttributeMemberOf = "UserAttributeMemberOf";
        public static final String UserAttributePrimaryGroupId = "UserAttributePrimaryGroupId";
        public static final String UserAttributeLockoutTime = "UserAttributeLockoutTime";
        public static final String UserAttributePasswordSettingsObject = "UserAttributePasswordSettingsObject";
        public static final String UserAttributePwdLastSet = "UserAttributePwdLastSet";
        public static final String GroupAttributeAccountName = "GroupAttributeAccountName";
        public static final String GroupAttributeDescription = "GroupAttributeDescription";
        public static final String GroupAttributeObjectId = "GroupAttributeObjectId";
        public static final String GroupAttributeMemberOf = "GroupAttributeMemberOf";
        public static final String GroupAttributeMembersList = "GroupAttributeMembersList";
        public static final String PasswordSettingsAttributeMaximumPwdAge = "PasswordSettingsAttributeMaximumPwdAge";
        public static final String DomainAttributeMaxPwdAge = "DomainAttributeMaxPwdAge";

        private AttributeIds() {
        }
    }
}

