/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.Group;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.SolutionUser;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Set;

public interface PrincipalDiscovery {
    public static final int PD_BULK_QUERY_MAX_SIZE = 5000;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public PrincipalId lookup(PrincipalId var1, boolean var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public SearchResult findUser(String var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Group findGroup(String var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public PersonUser findPersonUser(PrincipalId var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public SolutionUser findSolutionUser(String var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public SolutionUser findSolutionUserByCertDN(String var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Group findGroup(PrincipalId var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<PersonUser> findPersonUsers(SearchCriteria var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<PersonUser> findPersonUsersByName(SearchCriteria var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<SolutionUser> findSolutionUsers(String var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<Group> findGroups(SearchCriteria var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<Group> findGroupsByName(SearchCriteria var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public SearchResult find(SearchCriteria var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public SearchResult findByName(SearchCriteria var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<PersonUser> findPersonUsersInGroup(PrincipalId var1, String var2, int var3) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<PersonUser> findPersonUsersByNameInGroup(PrincipalId var1, String var2, int var3) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<SolutionUser> findSolutionUsersInGroup(String var1, String var2, int var3) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<Group> findGroupsInGroup(PrincipalId var1, String var2, int var3) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<Group> findGroupsByNameInGroup(PrincipalId var1, String var2, int var3) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<Group> findDirectParentGroups(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<Group> findNestedParentGroups(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<PersonUser> findLockedUsers(String var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<PersonUser> findDisabledPersonUsers(String var1, int var2) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Set<SolutionUser> findDisabledSolutionUsers(String var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public PersonUser findRegisteredExternalIDPUser(PrincipalId var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.NoPrivilege
    public Set<String> getImplicitGroupNames();

    public static final class SearchCriteria {
        private final String _searchString;
        private final String _domain;

        public SearchCriteria(String searchString, String domain) {
            ValidateUtil.validateNotNull(searchString, "searchString");
            ValidateUtil.validateNotEmpty(domain, "domain");
            this._searchString = searchString;
            this._domain = domain;
        }

        public String getSearchString() {
            return this._searchString;
        }

        public String getDomain() {
            return this._domain;
        }

        public String toString() {
            return String.format("searchString=%s, domain=%s", this.getSearchString(), this.getDomain());
        }
    }

    public static interface SearchResult {
        public Set<SolutionUser> getSolutionUsers();

        public Set<PersonUser> getPersonUsers();

        public Set<Group> getGroups();
    }
}

