/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import java.lang.annotation.Documented;

public interface RoleManagement {
    @Privilege(value=Role.Administrator)
    public boolean setRole(PrincipalId var1, Role var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @Privilege(value=Role.Administrator)
    public boolean hasAdministratorRole(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @Privilege(value=Role.RegularUser)
    public boolean hasRegularUserRole(PrincipalId var1) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @Privilege(value=Role.Administrator)
    public boolean grantWSTrustRole(PrincipalId var1, WSTrustRole var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @Privilege(value=Role.Administrator)
    public boolean revokeWSTrustRole(PrincipalId var1, WSTrustRole var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @Privilege(value=Role.Administrator)
    public boolean grantIDPProvisioningRole(PrincipalId var1, IDPProvisioningRole var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    @Privilege(value=Role.Administrator)
    public boolean revokeIDPProvisioningRole(PrincipalId var1, IDPProvisioningRole var2) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException;

    public static enum IDPProvisioningRole {
        IDPAdministrator;

    }

    public static enum WSTrustRole {
        ActAsUser;

    }

    @Documented
    public static @interface NoPrivilege {
    }

    @Documented
    public static @interface Privilege {
        public Role value();
    }

    public static enum Role {
        GuestUser,
        RegularUser,
        ConfigurationUser,
        Administrator;


        public boolean isHigherOrEqualTo(Role other) {
            return this.compareTo(other) >= 0;
        }
    }
}

