/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.io.Serializable;

public class ServiceEndpoint
implements Serializable {
    private static final long serialVersionUID = -6445916692718863817L;
    private final String name;
    private final String endpoint;
    private final String binding;

    public ServiceEndpoint(String endpoint, String binding) {
        this(endpoint, endpoint, binding);
    }

    public ServiceEndpoint(String name, String endpoint, String binding) {
        ValidateUtil.validateNotEmpty(endpoint, "endpoint");
        ValidateUtil.validateNotEmpty(binding, "binding");
        if (name == null || name.isEmpty()) {
            name = endpoint;
        }
        this.name = name;
        this.endpoint = endpoint;
        this.binding = binding;
    }

    public String getName() {
        return this.name;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getBinding() {
        return this.binding;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.binding.hashCode();
        result = 31 * result + this.endpoint.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceEndpoint other = (ServiceEndpoint)obj;
        if (!this.binding.equals(other.binding)) {
            return false;
        }
        if (!this.endpoint.equals(other.endpoint)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public String toString() {
        return "ServiceEndpoint [name=" + this.name + ", endpoint=" + this.endpoint + ", binding=" + this.binding + "]";
    }
}

