/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.exception;

import com.vmware.vim.sso.admin.exception.ADIDPRegistrationServiceException;

public class HostNotJoinedRequiredDomainException
extends ADIDPRegistrationServiceException {
    private static final long serialVersionUID = 7774656340218069416L;
    private final String requiredDomainName;
    private final String joinedDomainName;

    public HostNotJoinedRequiredDomainException(String requiredDomainName, String joinedDomainName) {
        super(HostNotJoinedRequiredDomainException.getDefaultMessage(requiredDomainName, joinedDomainName));
        assert (null != requiredDomainName && !requiredDomainName.trim().isEmpty());
        this.requiredDomainName = requiredDomainName;
        this.joinedDomainName = joinedDomainName;
    }

    public HostNotJoinedRequiredDomainException(String requiredDomainName, String joinedDomainName, Throwable t) {
        super(HostNotJoinedRequiredDomainException.getDefaultMessage(requiredDomainName, joinedDomainName), t);
        assert (null != requiredDomainName && !requiredDomainName.trim().isEmpty());
        this.requiredDomainName = requiredDomainName;
        this.joinedDomainName = joinedDomainName;
    }

    private static String getDefaultMessage(String requiredDomanName, String joinedDomainName) {
        if (joinedDomainName == null || joinedDomainName.isEmpty()) {
            return "To support native AD, the host is required to join properly.";
        }
        return String.format("The host is required to join to domain [%s] but joined to [%s]", requiredDomanName, joinedDomainName);
    }

    public String getRequiredDomainName() {
        return this.requiredDomainName;
    }

    public String getJoinedDomainName() {
        return this.joinedDomainName;
    }
}

