/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.domain;

import com.vmware.cis.license.common.misc.Util;
import com.vmware.cis.license.common.vmodl.VmodlUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.vmodl.KeyAnyValue;

public class SubscriptionUtil {
    public static final String LICENSE_PROP_SUBSCRIPTION = "subscription";

    public static boolean isSubscriptionLicenseAssignedToAsset(Asset asset) {
        if (asset == null) {
            return false;
        }
        License assetLicense = asset.getInfo().getLicense();
        boolean isSubscriptionLicense = SubscriptionUtil.isSubscriptionLicense(assetLicense);
        return isSubscriptionLicense;
    }

    public static boolean isSubscriptionLicense(License license) {
        boolean isSubscriptionLicense = SubscriptionUtil.isSubscriptionLicense(license.getInfo());
        return isSubscriptionLicense;
    }

    public static boolean isSubscriptionLicense(LicenseInfo licenseInfo) {
        String subscription = SubscriptionUtil.getLicenseSubscription(licenseInfo);
        boolean isSubscriptionLicense = !Util.isNullOrEmpty(subscription);
        return isSubscriptionLicense;
    }

    private static String getLicenseSubscription(LicenseInfo licenseInfo) {
        if (licenseInfo == null) {
            return null;
        }
        KeyAnyValue[] properties = licenseInfo.getProperties();
        if (Util.isNullOrEmpty(properties)) {
            return null;
        }
        String subscription = (String)VmodlUtil.findFirstValue(LICENSE_PROP_SUBSCRIPTION, properties);
        return subscription;
    }
}

