/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.misc;

import com.vmware.cis.license.common.misc.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    public static File getFile(File parent, String[] children) {
        assert (parent != null);
        assert (!Util.isNullOrEmpty(children));
        File file = parent;
        for (String child : children) {
            file = new File(file, child);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFileCreateDirs(File file, String data, String encoding) throws IOException {
        assert (file != null);
        if (data == null) {
            data = "";
        }
        FileOutputStream out = null;
        try {
            FileUtil.createParentDirs(file);
            out = new FileOutputStream(file);
            ((OutputStream)out).write(data.getBytes(encoding));
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void createParentDirs(File file) throws IOException {
        assert (file != null);
        File parent = file.getParentFile();
        if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
            throw new IOException("Directory '" + parent + "' could not be created");
        }
    }
}

