/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings;

import com.vmware.vapi.bindings.DynamicStructure;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.BinaryType;
import com.vmware.vapi.bindings.type.BooleanType;
import com.vmware.vapi.bindings.type.DoubleType;
import com.vmware.vapi.bindings.type.IntegerType;
import com.vmware.vapi.bindings.type.SecretType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.lang.Validate;

public final class DynamicStructureImpl
implements DynamicStructure,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient TypeConverter converter;
    private final StructValue strValue;

    public DynamicStructureImpl(StructValue strValue) {
        this(strValue, new TypeConverterImpl());
    }

    public DynamicStructureImpl(StructValue strValue, TypeConverter converter) {
        Validate.notNull((Object)strValue);
        Validate.notNull((Object)strValue);
        this.strValue = strValue;
        this.converter = converter;
    }

    @Override
    public StructValue _getDataValue() {
        return this.strValue;
    }

    @Override
    public <T> T getField(String fieldName, Class<T> targetClass) {
        DataValue fieldValue = this.strValue.getField(fieldName);
        Type targetType = this.findTargetType(targetClass);
        switch (fieldValue.getType()) {
            case BLOB: {
                this.validateTargetClass(byte[].class, targetClass);
                break;
            }
            case BOOLEAN: {
                this.validateTargetClass(Boolean.class, targetClass);
                break;
            }
            case DOUBLE: {
                this.validateTargetClass(Double.class, targetClass);
                break;
            }
            case INTEGER: {
                this.validateTargetClass(Long.class, targetClass);
                break;
            }
            case SECRET: {
                this.validateTargetClass(char[].class, targetClass);
                break;
            }
            case STRING: {
                this.validateTargetClass(String.class, targetClass);
                break;
            }
            case STRUCTURE: {
                if (Structure.class.isAssignableFrom(targetClass)) break;
                throw new RuntimeException("Inappropriate target class");
            }
        }
        return this.converter.convertToJava(fieldValue, targetType);
    }

    private void validateTargetClass(Class<?> expected, Class<?> actual) {
        if (expected != actual) {
            throw new RuntimeException("Inappropriate target class");
        }
    }

    @Override
    public <T> void setField(String fieldName, T newValue, Class<T> valueClass) {
        Type targetType = this.findTargetType(valueClass);
        DataValue newDataValue = this.converter.convertToVapi(newValue, targetType);
        this.strValue.setField(fieldName, newDataValue);
    }

    private Type findTargetType(Class<?> valueClass) {
        if (valueClass == byte[].class) {
            return new BinaryType();
        }
        if (valueClass == Boolean.class) {
            return new BooleanType();
        }
        if (valueClass == Double.class) {
            return new DoubleType();
        }
        if (valueClass == Long.class) {
            return new IntegerType();
        }
        if (valueClass == char[].class) {
            return new SecretType();
        }
        if (StaticStructure.class.isAssignableFrom(valueClass)) {
            return BindingsUtil.extractBindingType(valueClass);
        }
        if (valueClass == String.class) {
            return new StringType();
        }
        throw new RuntimeException("Unsupported static type class: " + valueClass);
    }

    @Override
    public boolean _hasTypeNameOf(Class<? extends Structure> clazz) {
        return BindingsUtil.hasTypeNameOf(this.strValue, clazz);
    }

    @Override
    public <T extends Structure> T _convertTo(Class<T> clazz) {
        return BindingsUtil.convertTo(this, clazz, this.converter.reusableThis());
    }

    @Override
    public String _getCanonicalName() {
        return this.strValue.getName();
    }

    public boolean equals(Object other) {
        if (!DynamicStructure.class.isInstance(other)) {
            return false;
        }
        return this.strValue.equals(((DynamicStructure)other)._getDataValue());
    }

    public int hashCode() {
        return this.strValue.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.converter = new TypeConverterImpl();
    }

    public String toString() {
        return this.strValue.toString();
    }
}

