/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;

public class MethodResult {
    private DataValue output;
    private ErrorValue error;

    public MethodResult(DataValue output, ErrorValue error) {
        if (output != null && error == null) {
            this.setOutput(output);
        } else if (output == null && error != null) {
            this.setError(error);
        } else {
            throw new IllegalArgumentException("Exactly one of 'output' and 'error' must be null");
        }
    }

    public DataValue getOutput() {
        return this.output;
    }

    public ErrorValue getError() {
        return this.error;
    }

    public boolean success() {
        return this.getError() == null;
    }

    private void setOutput(DataValue output) {
        this.output = output;
    }

    private void setError(ErrorValue error) {
        this.error = error;
    }

    public String toString() {
        return "Output: " + this.output + "\nError: " + this.error;
    }

    public static MethodResult newResult(DataValue output) {
        return new MethodResult(output, null);
    }

    public static MethodResult newErrorResult(ErrorValue error) {
        return new MethodResult(null, error);
    }
}

