/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionUtil.class);
    private static final String RUNTIME_VERSION_RESOURCE_NAME = "vapi_runtime_version.properties";
    private static final String SDK_VERSION_RESOURCE_NAME = "vapi_sdk_version.properties";
    private static final String USER_AGENT = VersionUtil.buildUserAgent();

    public static String getUserAgent() {
        return USER_AGENT;
    }

    static String buildUserAgent() {
        StringBuilder builder = new StringBuilder();
        VersionUtil.buildUserAgentComponent(VersionUtil.loadSdkVersion(), builder);
        VersionUtil.buildUserAgentComponent(VersionUtil.loadRuntimeVersion(), builder);
        VersionUtil.buildJavaComponent(builder);
        VersionUtil.buildOsComment(builder);
        return builder.toString();
    }

    static void buildUserAgentComponent(Properties verProperties, StringBuilder builder) {
        if (verProperties == null) {
            return;
        }
        builder.append(verProperties.getProperty("component.name")).append('/').append(verProperties.getProperty("component.version")).append(' ');
    }

    static void buildJavaComponent(StringBuilder builder) {
        builder.append("Java/").append(System.getProperty("java.version"));
    }

    static void buildOsComment(StringBuilder builder) {
        builder.append(" (").append(System.getProperty("os.name")).append("; ").append(System.getProperty("os.version")).append("; ").append(System.getProperty("os.arch")).append(")");
    }

    static Properties loadRuntimeVersion() {
        return VersionUtil.loadVersionResource(RUNTIME_VERSION_RESOURCE_NAME);
    }

    static Properties loadSdkVersion() {
        return VersionUtil.loadVersionResource(SDK_VERSION_RESOURCE_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties loadVersionResource(String resourceName) {
        ClassLoader runtimeLoader = VersionUtil.class.getClassLoader();
        try (InputStream inStream = runtimeLoader.getResourceAsStream(resourceName);){
            if (inStream == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties versionProps = new Properties();
            versionProps.load(inStream);
            Properties properties = versionProps;
            return properties;
        }
        catch (IOException | IllegalArgumentException ex) {
            LOGGER.debug("Failed to load content of version info resource ", (Throwable)ex);
            return null;
        }
    }
}

