/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class OperationDef {
    private final String operationId;
    private final String urlTemplate;
    private final String httpMethod;
    private final String acceptHeader;
    private final String contentTypeHeader;
    private String requestBodyField;
    private Map<String, String> pathVar2FieldName;
    private Map<String, String> requestParam2FieldName;
    private Map<String, String> header2FieldName;

    public OperationDef(String operationId, String urlTemplate, String httpMethod, String acceptHeader, String contentTypeHeader) {
        Validate.notNull((Object)operationId);
        Validate.notNull((Object)urlTemplate);
        Validate.notNull((Object)httpMethod);
        this.operationId = operationId;
        this.urlTemplate = urlTemplate;
        this.httpMethod = httpMethod;
        this.acceptHeader = acceptHeader;
        this.contentTypeHeader = contentTypeHeader;
    }

    public void registerRequestBody(String name) {
        Validate.notNull((Object)name);
        this.requestBodyField = name;
    }

    public void registerPathVariable(String pathVarName, String name) {
        Validate.notNull((Object)pathVarName);
        Validate.notNull((Object)name);
        if (this.pathVar2FieldName == null) {
            this.pathVar2FieldName = this.newSmallHashMap();
        }
        this.pathVar2FieldName.put(pathVarName, name);
    }

    public void registerRequestParam(String reqParamName, String name) {
        Validate.notNull((Object)reqParamName);
        Validate.notNull((Object)name);
        if (this.requestParam2FieldName == null) {
            this.requestParam2FieldName = this.newSmallHashMap();
        }
        this.requestParam2FieldName.put(reqParamName, name);
    }

    public void registerRequestHeader(String headerName, String name) {
        Validate.notNull((Object)headerName);
        Validate.notNull((Object)name);
        if (this.header2FieldName == null) {
            this.header2FieldName = this.newSmallHashMap();
        }
        this.header2FieldName.put(headerName, name);
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getAcceptHeaderValue() {
        return this.acceptHeader;
    }

    public String getContentTypeHeaderValue() {
        return this.contentTypeHeader;
    }

    public String getRequestBodyFieldName() {
        return this.requestBodyField;
    }

    public Map<String, String> getPathVariableInfo() {
        return this.pathVar2FieldName;
    }

    public Map<String, String> getRequestParamInfo() {
        return this.requestParam2FieldName;
    }

    public Map<String, String> getHeadersInfo() {
        return this.header2FieldName;
    }

    private Map<String, String> newSmallHashMap() {
        return new HashMap<String, String>(8, 1.0f);
    }
}

