/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.AsyncCallbackSyncAdapter;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.diagnostics.LogDiagnosticUtil;
import com.vmware.vapi.diagnostics.Slf4jMDCLogConfigurator;
import com.vmware.vapi.internal.bindings.BindingsExceptionTranslator;
import com.vmware.vapi.internal.bindings.ProgressConverter;
import com.vmware.vapi.internal.bindings.RetryingCallback;
import com.vmware.vapi.internal.bindings.StructValueBuilder;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.ValidatorUtil;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vapi.internal.bindings.convert.impl.JavaClassStructConverter;
import com.vmware.vapi.internal.bindings.convert.impl.MapBasedNameToTypeResolver;
import com.vmware.vapi.std.Progress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stub {
    private static final Logger logger = LoggerFactory.getLogger(Stub.class);
    protected final InterfaceIdentifier ifaceId;
    protected final ApiProvider apiProvider;
    protected final TypeConverter converter;
    protected final ExecutionContext.SecurityContext securityContext;
    private final RetryPolicy retryPolicy;

    protected Stub(ApiProvider apiProvider, InterfaceIdentifier ifaceId, StubConfigurationBase config) {
        this(apiProvider, null, ifaceId, config);
    }

    protected Stub(ApiProvider apiProvider, TypeConverter typeConverter, InterfaceIdentifier ifaceId, StubConfigurationBase config) {
        Validate.notNull((Object)apiProvider);
        Validate.notNull((Object)config);
        Validate.notNull((Object)ifaceId);
        this.ifaceId = ifaceId;
        this.apiProvider = apiProvider;
        this.converter = typeConverter != null ? typeConverter : Stub.createTypeConverter(config.getErrorTypes());
        this.securityContext = config.getSecurityContext();
        this.retryPolicy = config.getRetryPolicy();
    }

    protected <T> T invokeMethod(MethodIdentifier methodId, StructValueBuilder structBuilder, StructType inputType, Type outputType, Collection<Type> errorTypes, InvocationConfig invocationConfig) {
        AsyncCallbackSyncAdapter future = new AsyncCallbackSyncAdapter();
        this.invokeMethodAsync(methodId, structBuilder, inputType, outputType, errorTypes, invocationConfig, future);
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    protected <T> void invokeMethodAsync(MethodIdentifier methodId, StructValueBuilder structBuilder, StructType inputType, Type outputType, Collection<Type> errorTypes, InvocationConfig invocationConfig, AsyncCallback<T> asyncCallback) {
        StructValue inputValue;
        try {
            inputValue = structBuilder.getStructValue();
            this.validateInput(inputType, inputValue, methodId);
        }
        catch (RuntimeException e) {
            asyncCallback.onError(BindingsExceptionTranslator.translate(e));
            return;
        }
        ExecutionContext execCtx = this.getExecutionContext(invocationConfig);
        this.invoke(methodId, inputValue, outputType, errorTypes, execCtx, asyncCallback, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void invoke(final MethodIdentifier methodId, final StructValue inputValue, final Type outputType, final Collection<Type> errorTypes, final ExecutionContext execCtx, final AsyncCallback<T> asyncCallback, final int invocationAttempt) {
        AsyncCallback<T> cb;
        String serviceId = methodId.getInterfaceIdentifier().getName();
        String operationId = methodId.getName();
        if (this.retryPolicy != null) {
            RetryingCallback.Retryable retryable = new RetryingCallback.Retryable(){

                @Override
                public void retry(RetryPolicy.RetrySpec retrySpec) {
                    Stub.this.invoke(methodId, inputValue, outputType, errorTypes, Stub.getExecutionContextForRetry(execCtx, retrySpec), asyncCallback, invocationAttempt + 1);
                }
            };
            cb = new RetryingCallback<T>(asyncCallback, this.retryPolicy, new RetryPolicy.RetryContext(serviceId, operationId, execCtx, inputValue), invocationAttempt, retryable);
        } else {
            cb = asyncCallback;
        }
        Slf4jMDCLogConfigurator logConfig = new Slf4jMDCLogConfigurator();
        try {
            logConfig.configureContext(LogDiagnosticUtil.getDiagnosticContext(execCtx));
            this.invoke(serviceId, operationId, inputValue, outputType, errorTypes, execCtx, cb);
        }
        finally {
            logConfig.cleanUpContext(LogDiagnosticUtil.getDiagnosticKeys());
        }
    }

    private <T> void invoke(String serviceId, String operationId, StructValue inputValue, final Type outputType, final Collection<Type> errorTypes, ExecutionContext execCtx, final AsyncCallback<T> asyncCallback) {
        this.apiProvider.invoke(serviceId, operationId, inputValue, execCtx, new AsyncHandle<MethodResult>(){

            @Override
            public void updateProgress(DataValue progress) {
                asyncCallback.onProgress(Stub.this.convertProgress(progress));
            }

            @Override
            public void setResult(MethodResult value) {
                if (!value.success()) {
                    asyncCallback.onError(Stub.this.convertError(value.getError(), errorTypes));
                } else {
                    asyncCallback.onResult(Stub.this.convert(value.getOutput(), outputType));
                }
            }

            @Override
            public void setError(RuntimeException error) {
                asyncCallback.onError(BindingsExceptionTranslator.translate(error));
            }
        });
    }

    private void validateInput(StructType inputType, StructValue inputValue, MethodIdentifier methodId) {
        ValidatorUtil.validate(inputType, inputValue, methodId);
    }

    ErrorType resolveErrorType(ErrorValue errValue, Collection<Type> errorTypes) {
        if (errValue == null) {
            return null;
        }
        String errorValueName = errValue.getName();
        if (errorTypes != null) {
            for (Type t : errorTypes) {
                ErrorType errType = (ErrorType)((TypeReference)t).resolve();
                if (!errorValueName.equals(errType.getName())) continue;
                return errType;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "<" + this.ifaceId.getName() + ">";
    }

    private static ExecutionContext getExecutionContextForRetry(ExecutionContext oldContext, RetryPolicy.RetrySpec retrySpec) {
        if (retrySpec.getInvocationConfig() == null) {
            return oldContext;
        }
        InvocationConfig invocationConfig = retrySpec.getInvocationConfig();
        ExecutionContext newContext = invocationConfig.getExecutionContext();
        if (newContext == null) {
            return oldContext;
        }
        ExecutionContext.ApplicationData newData = newContext.retrieveApplicationData();
        ExecutionContext.ApplicationData oldData = oldContext.retrieveApplicationData();
        if (newData == null) {
            newData = oldData;
        } else if (Stub.getOpId(newData) == null && Stub.getOpId(oldData) != null) {
            newData = Stub.add(newData, "opId", Stub.getOpId(oldData));
        }
        ExecutionContext.SecurityContext newSecurity = newContext.retrieveSecurityContext();
        if (newSecurity == null) {
            newSecurity = oldContext.retrieveSecurityContext();
        }
        return new ExecutionContext(newData, newSecurity);
    }

    private ExecutionContext getExecutionContext(InvocationConfig invocationConfig) {
        return new ExecutionContext(Stub.getApplicationData(invocationConfig), this.getSecurityContext(invocationConfig));
    }

    private ExecutionContext.SecurityContext getSecurityContext(InvocationConfig invocationConfig) {
        if (invocationConfig != null && invocationConfig.getExecutionContext() != null && invocationConfig.getExecutionContext().retrieveSecurityContext() != null) {
            return invocationConfig.getExecutionContext().retrieveSecurityContext();
        }
        return this.securityContext;
    }

    private static ExecutionContext.ApplicationData getApplicationData(InvocationConfig invocationConfig) {
        ExecutionContext.ApplicationData defaultData = Stub.buildDefaultAppData();
        if (invocationConfig != null && invocationConfig.getExecutionContext() != null && invocationConfig.getExecutionContext().retrieveApplicationData() != null) {
            return Stub.merge(defaultData, invocationConfig.getExecutionContext().retrieveApplicationData());
        }
        return defaultData;
    }

    private static ExecutionContext.ApplicationData merge(ExecutionContext.ApplicationData original, ExecutionContext.ApplicationData extra) {
        HashMap<String, String> fields = new HashMap<String, String>(original.getAllProperties());
        fields.putAll(extra.getAllProperties());
        return new ExecutionContext.ApplicationData(fields);
    }

    private static ExecutionContext.ApplicationData add(ExecutionContext.ApplicationData original, String extraKey, String extraValue) {
        HashMap<String, String> fields = new HashMap<String, String>(original.getAllProperties());
        fields.put(extraKey, extraValue);
        return new ExecutionContext.ApplicationData(fields);
    }

    private static ExecutionContext.ApplicationData buildDefaultAppData() {
        return new ExecutionContext.ApplicationData(Collections.singletonMap("opId", UUID.randomUUID().toString()));
    }

    private static String getOpId(ExecutionContext.ApplicationData data) {
        if (data == null) {
            return null;
        }
        return data.getProperty("opId");
    }

    private <T> T convert(DataValue value, Type type) {
        try {
            return this.converter.convertToJava(value, type);
        }
        catch (RuntimeException e) {
            throw BindingsExceptionTranslator.translate(e);
        }
    }

    private Progress convertProgress(DataValue progressValue) {
        return ProgressConverter.fromValue(progressValue);
    }

    private RuntimeException convertError(ErrorValue error, Collection<Type> errorTypes) {
        Type type = this.resolveErrorType(error, errorTypes);
        if (type == null) {
            type = new AnyErrorType();
        }
        return (RuntimeException)this.convert(error, type);
    }

    private static TypeConverter createTypeConverter(Set<ErrorType> typeSet) {
        Map<String, StructType> errorTypes = MapBasedNameToTypeResolver.augmentWithStandardErrors(typeSet);
        MapBasedNameToTypeResolver errorsResolver = new MapBasedNameToTypeResolver(errorTypes);
        return new TypeConverterImpl(new StubConverterFactory(errorsResolver));
    }

    protected InvocationConfig enableTaskInConfig(InvocationConfig invocationConfig) {
        ExecutionContext newExecCtx;
        if (invocationConfig == null || invocationConfig.getExecutionContext() == null) {
            ExecutionContext.ApplicationData data = this.createAppDataEnablingTask();
            newExecCtx = new ExecutionContext(data, null);
        } else {
            ExecutionContext.ApplicationData newData;
            if (invocationConfig.getExecutionContext().retrieveApplicationData() == null) {
                newData = this.createAppDataEnablingTask();
            } else {
                Map<String, String> props = invocationConfig.getExecutionContext().retrieveApplicationData().getAllProperties();
                if (props.get("$task") != null) {
                    logger.warn("Unexpected key {} found in ApplicationData", (Object)"$task");
                }
                HashMap<String, String> newProps = new HashMap<String, String>(props);
                newProps.put("$task", "true");
                newData = new ExecutionContext.ApplicationData(newProps);
            }
            newExecCtx = new ExecutionContext(newData, invocationConfig.getExecutionContext().retrieveSecurityContext());
        }
        return new InvocationConfig(newExecCtx);
    }

    protected ExecutionContext.ApplicationData createAppDataEnablingTask() {
        return new ExecutionContext.ApplicationData(Collections.singletonMap("$task", "true"));
    }

    protected InvocationConfig disableTaskInConfig(InvocationConfig invocationConfig) {
        if (invocationConfig == null || invocationConfig.getExecutionContext() == null || invocationConfig.getExecutionContext().retrieveApplicationData() == null) {
            return invocationConfig;
        }
        Map<String, String> props = invocationConfig.getExecutionContext().retrieveApplicationData().getAllProperties();
        HashMap<String, String> newProps = new HashMap<String, String>(props);
        if (newProps.remove("$task") != null) {
            logger.warn("Unexpected key {} found in ApplicationData", (Object)"$task");
        }
        ExecutionContext.ApplicationData newData = new ExecutionContext.ApplicationData(newProps);
        ExecutionContext newExecCtx = new ExecutionContext(newData, invocationConfig.getExecutionContext().retrieveSecurityContext());
        return new InvocationConfig(newExecCtx);
    }

    static final class StubConverterFactory
    extends DefaultConverterFactory {
        private final UniTypeConverter<StructValue, StructType> skipUnsetStructConverter = new JavaClassStructConverter<StructValue, StructType>(StructValue.class, Structure.class, true);

        StubConverterFactory(NameToTypeResolver nameToTypeResolver) {
            super(nameToTypeResolver);
        }

        @Override
        public UniTypeConverter<StructValue, StructType> getStructConverter() {
            return this.skipUnsetStructConverter;
        }
    }
}

