/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.protocol.ProtocolHandler;
import com.vmware.vapi.protocol.ProtocolHandlerFactory;
import com.vmware.vapi.protocol.server.msg.json.JsonServerConnection;
import com.vmware.vapi.protocol.server.rpc.http.Endpoint;
import com.vmware.vapi.protocol.server.rpc.http.Server;
import com.vmware.vapi.protocol.server.rpc.http.Service;
import com.vmware.vapi.protocol.server.rpc.http.impl.HttpEndpoint;
import com.vmware.vapi.protocol.server.rpc.http.impl.HttpServer;
import com.vmware.vapi.protocol.server.rpc.http.impl.HttpStreamingServlet;
import com.vmware.vapi.protocol.server.rpc.http.impl.HttpsEndpoint;
import com.vmware.vapi.protocol.server.rpc.http.impl.MediaTypeResolverImpl;
import com.vmware.vapi.protocol.server.rpc.http.impl.ServiceImpl;
import com.vmware.vapi.protocol.server.rpc.http.impl.TcServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.Servlet;
import org.apache.catalina.Executor;
import org.apache.catalina.core.StandardThreadExecutor;
import org.apache.commons.lang.Validate;

public class ProtocolHandlerFactoryImpl
implements ProtocolHandlerFactory {
    @Override
    public ProtocolHandler getProtocolHandler(String type, String args, String secureArgs, String keystore, String keystorePassword, String keyPassword, ApiProvider provider) {
        if (type.equals(Protocol.http.toString())) {
            return ProtocolHandlerFactoryImpl.createHttpHandler(args, secureArgs, ClientAuthentication.nothing.value, new ProtocolHandlerFactory.KeyStoreConfig(keystore, keystorePassword, keyPassword), null, provider);
        }
        return null;
    }

    @Override
    public ProtocolHandler getProtocolHandler(String type, String args, String secureArgs, String clientAuth, ProtocolHandlerFactory.KeyStoreConfig keystoreConfig, ProtocolHandlerFactory.TrustStoreConfig truststoreConfig, ApiProvider provider) {
        if (type.equals(Protocol.http.toString())) {
            return ProtocolHandlerFactoryImpl.createHttpHandler(args, secureArgs, clientAuth, keystoreConfig, truststoreConfig, provider);
        }
        return null;
    }

    private static ProtocolHandler createHttpHandler(String httpUri, String httpsUri, String clientAuth, ProtocolHandlerFactory.KeyStoreConfig keystoreConfig, ProtocolHandlerFactory.TrustStoreConfig truststoreConfig, ApiProvider provider) {
        Server server = ProtocolHandlerFactoryImpl.createHttpServer();
        Servlet servlet = ProtocolHandlerFactoryImpl.createServlet(provider);
        ArrayList<HttpEndpoint> endpoints = new ArrayList<HttpEndpoint>();
        ArrayList<Service> services = new ArrayList<Service>();
        if (httpUri != null) {
            URL httpUrl = ProtocolHandlerFactoryImpl.parseUrl(httpUri);
            endpoints.add(ProtocolHandlerFactoryImpl.createHttpEndpoint(httpUrl));
            services.add(ProtocolHandlerFactoryImpl.createService(httpUrl, servlet));
        }
        if (httpsUri != null) {
            Validate.notNull((Object)keystoreConfig);
            Validate.notNull((Object)keystoreConfig.getPath());
            URL httpsUrl = ProtocolHandlerFactoryImpl.parseUrl(httpsUri);
            endpoints.add(ProtocolHandlerFactoryImpl.createHttpsEndpoint(httpsUrl, keystoreConfig, truststoreConfig, clientAuth));
            services.add(ProtocolHandlerFactoryImpl.createService(httpsUrl, servlet));
        }
        server.setEndpoints(endpoints.toArray(new Endpoint[endpoints.size()]));
        server.setServices(services.toArray(new Service[services.size()]));
        return new HttpServer(server);
    }

    private static Servlet createServlet(ApiProvider provider) {
        return new HttpStreamingServlet(MediaTypeResolverImpl.newJsonResolver(new JsonServerConnection(provider, Collections.emptyList())));
    }

    private static Server createHttpServer() {
        TcServer server = new TcServer();
        server.setThreadPool(ProtocolHandlerFactoryImpl.createThreadPool());
        return server;
    }

    private static Executor createThreadPool() {
        StandardThreadExecutor threadPool = new StandardThreadExecutor();
        threadPool.setName("HttpThreadPool");
        threadPool.setNamePrefix("Test-vAPI-tcserver-");
        threadPool.setMinSpareThreads(10);
        threadPool.setMaxThreads(300);
        threadPool.setMaxIdleTime(60000);
        threadPool.setMaxQueueSize(50);
        threadPool.setPrestartminSpareThreads(true);
        threadPool.setDaemon(false);
        return threadPool;
    }

    private static Service createService(URL url, Servlet servlet) {
        ServiceImpl service = new ServiceImpl();
        service.setPath(url.getPath());
        service.setServlet(servlet);
        return service;
    }

    private static HttpEndpoint createHttpEndpoint(URL url) {
        HttpEndpoint endpoint = new HttpEndpoint(url.getPort());
        endpoint.setMaxIdleTime(200000);
        return endpoint;
    }

    private static HttpsEndpoint createHttpsEndpoint(URL url, ProtocolHandlerFactory.KeyStoreConfig keystoreConfig) {
        HttpsEndpoint endpoint = new HttpsEndpoint(url.getPort());
        if (keystoreConfig != null) {
            endpoint.setKeyStorePath(keystoreConfig.getPath());
            endpoint.setKeyStorePassword(keystoreConfig.getPassword());
            endpoint.setKeyPassword(keystoreConfig.getKeyPassword());
        }
        endpoint.setKeyStoreType("jks");
        endpoint.setMaxIdleTime(200000);
        return endpoint;
    }

    private static HttpsEndpoint createHttpsEndpoint(URL url, ProtocolHandlerFactory.KeyStoreConfig keystoreConfig, ProtocolHandlerFactory.TrustStoreConfig truststoreConfig, String clientAuth) {
        HttpsEndpoint endpoint = ProtocolHandlerFactoryImpl.createHttpsEndpoint(url, keystoreConfig);
        if (truststoreConfig != null) {
            endpoint.setTrustStorePath(truststoreConfig.getPath());
            endpoint.setTrustStorePassword(truststoreConfig.getPassword());
        }
        if (ClientAuthentication.need.value.equals(clientAuth)) {
            Validate.notNull((Object)truststoreConfig);
            Validate.notNull((Object)truststoreConfig.getPath());
            endpoint.setNeedClientAuth(true);
        } else if (ClientAuthentication.want.value.equals(clientAuth)) {
            endpoint.setWantClientAuth(true);
        }
        return endpoint;
    }

    private static URL parseUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL '" + url + "'", ex);
        }
    }

    @Override
    public ProtocolHandler getInsecureProtocolHandler(String type, String args, ApiProvider provider) {
        if (type.equals(Protocol.http.toString())) {
            return ProtocolHandlerFactoryImpl.createHttpHandler(args, null, null, null, null, provider);
        }
        return null;
    }

    public static enum ClientAuthentication {
        need("true"),
        want("want"),
        nothing("false");

        String value;

        private ClientAuthentication(String value) {
            this.value = value;
        }
    }

    public static enum Protocol {
        http;

    }
}

