/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.protocol.client.rest.OperationRestMetadata;
import com.vmware.vapi.internal.protocol.client.rpc.http.Utils;
import com.vmware.vapi.internal.protocol.common.http.UrlUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class RestMetadataBasedHttpRequestBuilder {
    private final OperationRestMetadata restMetadata;
    private final UrlUtil urlUtils;

    public RestMetadataBasedHttpRequestBuilder(OperationRestMetadata restMetadata, UrlUtil urlUtil) {
        Validate.notNull((Object)urlUtil);
        Validate.notNull((Object)restMetadata);
        this.urlUtils = urlUtil;
        this.restMetadata = restMetadata;
    }

    public String buildUrlPath(StructValue input) {
        Validate.notNull((Object)input);
        Map<String, String> pathVariablesToFieldNames = this.restMetadata.getPathVariablesToFieldNames();
        Map<String, String> pathParams = this.extractParams(input, pathVariablesToFieldNames, false, true);
        String path = this.urlUtils.replacePathVariables(this.restMetadata.getUrlTemplate(), pathParams);
        Map<String, String> requestParams = this.extractParams(input, this.restMetadata.getRequestParamsToFieldNames(), true, false);
        String queryString = this.urlUtils.encodeQuery(requestParams);
        return Utils.appendQueryToPath(path, queryString);
    }

    public String buildAbsoluteTargetUrl(StructValue input, String baseUrl) {
        Validate.notNull((Object)baseUrl);
        return this.urlUtils.joinUrls(baseUrl, this.buildUrlPath(input));
    }

    public DataValue getRequestBodyValue(StructValue input) {
        Validate.notNull((Object)input);
        if (this.restMetadata.getRequestBodyFieldName() != null) {
            return input.getField(this.restMetadata.getRequestBodyFieldName());
        }
        return null;
    }

    public Map<String, List<String>> buildHeaders(StructValue input) {
        String contentType;
        Validate.notNull((Object)input);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(this.restMetadata.getFixedHeaders());
        Map<String, String> requestHeaders = this.extractParams(input, this.restMetadata.getRequestHeadersToFieldNames(), true, false);
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            Utils.addListEntryToMapOfLists(header.getKey(), header.getValue(), headers);
        }
        String accept = this.restMetadata.getAccept();
        if (accept != null) {
            Utils.addListEntryToMapOfLists("Accept", accept, headers);
        }
        if ((contentType = this.restMetadata.getContentType()) != null) {
            Utils.addListEntryToMapOfLists("Content-Type", contentType, headers);
        }
        return headers;
    }

    private Map<String, String> extractParams(StructValue input, Map<String, String> paramsToFieldNames, boolean allowOptional, boolean urlEncodeValues) {
        HashMap<String, String> result = new HashMap<String, String>();
        block3: for (Map.Entry<String, String> paramToFieldName : paramsToFieldNames.entrySet()) {
            DataValue fieldValue = input.getField(paramToFieldName.getValue());
            fieldValue = RestMetadataBasedHttpRequestBuilder.unwrapOptionalValue(fieldValue);
            String name = paramToFieldName.getKey();
            if (fieldValue == null) {
                if (allowOptional) continue;
                throw new IllegalArgumentException(MessageFormat.format("Field {0} cannot be null", name));
            }
            switch (fieldValue.getType()) {
                case STRING: 
                case BOOLEAN: 
                case INTEGER: {
                    String value = fieldValue.toString();
                    result.put(name, urlEncodeValues ? this.urlUtils.encodeUrlPath(value) : value);
                    continue block3;
                }
            }
            String msg = String.format("Unsupported type of value of path, query or header variable: %s . Only String, Boolean and Integer are supported.", fieldValue.getType().toString());
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    private static DataValue unwrapOptionalValue(DataValue value) {
        if (value != null && value.getType() == DataType.OPTIONAL) {
            return RestMetadataBasedHttpRequestBuilder.unwrapOptionalValue(((OptionalValue)value).getValue());
        }
        return value;
    }
}

