/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheBioHttpClientBuilder;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpResponse;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheClientRestTransport
implements RestTransport {
    private static final Logger logger = LoggerFactory.getLogger(ApacheClientRestTransport.class);
    private final CloseableHttpClient httpClient;

    ApacheClientRestTransport(HttpConfiguration httpConfig) {
        this.httpClient = new ApacheBioHttpClientBuilder().buildAndConfigure(httpConfig);
    }

    public ApacheClientRestTransport(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void execute(HttpRequest request, HttpRequest.HttpResponseHandler responseHandler) {
        Validate.notNull((Object)request.getUrl(), (String)"Url of request is null. Cannot execute it.");
        Validate.notNull((Object)((Object)request.getMethod()), (String)"Method of request is null. Cannot execute it.");
        HttpUriRequest apacheRequest = this.createRequest(request);
        for (Map.Entry<String, List<String>> headersForName : request.getHeaders().entrySet()) {
            for (String value : headersForName.getValue()) {
                BasicHeader header = new BasicHeader(headersForName.getKey(), value);
                apacheRequest.addHeader((Header)header);
            }
        }
        if (apacheRequest instanceof HttpEntityEnclosingRequest && request.getBody() != null) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)apacheRequest;
            ByteArrayEntity requestEntity = new ByteArrayEntity(request.getBody());
            entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute(apacheRequest);
            responseHandler.onResult(new ApacheHttpResponse((HttpResponse)response));
        }
        catch (IOException e) {
            responseHandler.onError(new RuntimeException(e));
        }
        catch (RuntimeException e) {
            responseHandler.onError(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private HttpUriRequest createRequest(HttpRequest request) {
        switch (request.getMethod()) {
            case GET: {
                return new HttpGet(request.getUrl());
            }
            case HEAD: {
                return new HttpHead(request.getUrl());
            }
            case POST: {
                return new HttpPost(request.getUrl());
            }
            case PUT: {
                return new HttpPut(request.getUrl());
            }
            case DELETE: {
                return new HttpDelete(request.getUrl());
            }
            case OPTIONS: {
                return new HttpOptions(request.getUrl());
            }
            case PATCH: {
                return new HttpPatch(request.getUrl());
            }
        }
        IllegalArgumentException e = new IllegalArgumentException("Unsupported HTTP method requested: " + (Object)((Object)request.getMethod()));
        logger.error(e.getMessage(), (Throwable)e);
        throw e;
    }
}

