/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.ExecutorResponseCallback;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientHeadersProvider;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.SslClientUtil;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import com.vmware.vapi.internal.protocol.common.http.FrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.ByteBufferBinaryInput;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameDeserializer;
import com.vmware.vapi.internal.util.DefaultThreadFactory;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpAsyncClientTransport
implements CorrelatingClient {
    private static Logger logger = LoggerFactory.getLogger(ApacheHttpAsyncClientTransport.class);
    private final String uri;
    private final CloseableHttpAsyncClient httpClient;
    private final Executor executor;

    public ApacheHttpAsyncClientTransport(String uri) {
        this(uri, new HttpConfiguration.Builder().getConfig());
    }

    public ApacheHttpAsyncClientTransport(String uri, HttpConfiguration httpConfig) {
        this(uri, ApacheHttpAsyncClientTransport.createDefaultHttpClient(httpConfig), null);
    }

    public ApacheHttpAsyncClientTransport(String uri, HttpConfiguration httpConfig, Executor executor) {
        this(uri, ApacheHttpAsyncClientTransport.createDefaultHttpClient(httpConfig), executor);
    }

    public ApacheHttpAsyncClientTransport(String uri, CloseableHttpAsyncClient httpClient, Executor executor) {
        Validate.notNull((Object)uri);
        Validate.notNull((Object)httpClient);
        this.uri = uri;
        this.httpClient = httpClient;
        this.executor = executor;
    }

    private static CloseableHttpAsyncClient createDefaultHttpClient(final HttpConfiguration httpConfig) {
        Validate.notNull((Object)httpConfig);
        try {
            NHttpClientConnectionManager connManager = ApacheHttpAsyncClientTransport.createConnectionManager(httpConfig);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(httpConfig.getSoTimeout()).setConnectTimeout(httpConfig.getConnectTimeout()).build();
            HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setConnectionManager(connManager).setUserAgent(ApacheHttpUtil.VAPI_USER_AGENT).setDefaultRequestConfig(requestConfig).setThreadFactory((ThreadFactory)new DefaultThreadFactory("vAPI-I/O reactor-")).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    return httpConfig.getKeepAlivePeriod();
                }
            });
            HttpConfiguration.HeadersProvider headersProvider = httpConfig.getHeadersProvider();
            if (headersProvider != null) {
                builder.addInterceptorFirst((HttpRequestInterceptor)new ApacheClientHeadersProvider(headersProvider));
            }
            CloseableHttpAsyncClient client = builder.build();
            client.start();
            return client;
        }
        catch (IOReactorException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static NHttpClientConnectionManager createConnectionManager(HttpConfiguration config) throws IOReactorException {
        ConnectingIOReactor ioreactor = ApacheHttpAsyncClientTransport.createConnectionIOReactor(config);
        Registry<SchemeIOSessionStrategy> schemeRegistry = ApacheHttpAsyncClientTransport.createAsyncSchemeRegistry(config);
        PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager(ioreactor, schemeRegistry);
        cm.setMaxTotal(config.getMaxConnections());
        cm.setDefaultMaxPerRoute(config.getMaxConnections());
        return cm;
    }

    private static ConnectingIOReactor createConnectionIOReactor(HttpConfiguration config) throws IOReactorException {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getIoThreadCount()).setSoTimeout(config.getSoTimeout()).setConnectTimeout(config.getConnectTimeout()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig, (ThreadFactory)new DefaultThreadFactory("vAPI-I/O dispatcher-"));
    }

    private static Registry<SchemeIOSessionStrategy> createAsyncSchemeRegistry(HttpConfiguration config) {
        HttpConfiguration.SslConfiguration sslConfig = config.getSslConfiguration();
        X509HostnameVerifier hostnameVerifier = SslClientUtil.createHostnameVerifier(sslConfig.isHostnameVerificationDisabled(), SSLIOSessionStrategy.STRICT_HOSTNAME_VERIFIER);
        return RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(SslClientUtil.createSslContext(sslConfig), sslConfig.getEnabledProtocols(), sslConfig.getEnabledCipherSuites(), hostnameVerifier)).build();
    }

    @Override
    public void send(InputStream request, int requestLength, AbortHandle abortHandle, CorrelatingClient.ResponseCallback cb) {
        Validate.notNull((Object)request);
        Validate.isTrue((requestLength >= -1 ? 1 : 0) != 0);
        Validate.notNull((Object)cb);
        String requestContentType = "application/json";
        HttpPost post = new HttpPost(this.uri);
        post.setEntity((HttpEntity)new InputStreamEntity(request, (long)requestLength));
        post.setHeader("Content-Type", requestContentType);
        post.setHeader("Accept", "application/vnd.vmware.vapi.framed," + requestContentType);
        CorrelatingClient.ResponseCallback decoratedCb = cb;
        if (this.executor != null) {
            decoratedCb = new ExecutorResponseCallback(cb, this.executor);
        }
        if (Util.checkRequestAborted(abortHandle, cb)) {
            return;
        }
        Util.registerAbortListerner(cb, post, abortHandle);
        this.httpClient.execute(HttpAsyncMethods.create((HttpUriRequest)post), (HttpAsyncResponseConsumer)new MainConsumer(decoratedCb, requestContentType, abortHandle), (FutureCallback)new FutureCallbackImpl(abortHandle, cb));
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class MultiResponseConsumer
    extends AsyncByteConsumer<HttpResponse> {
        private volatile HttpResponse httpResponse;
        private final CorrelatingClient.ResponseCallback callback;
        private final FrameDeserializer deserializer;

        public MultiResponseConsumer(FrameDeserializer deserializer, CorrelatingClient.ResponseCallback callback) {
            this.deserializer = deserializer;
            this.callback = callback;
        }

        protected void onResponseReceived(HttpResponse response) {
            this.httpResponse = response;
        }

        protected void onByteReceived(ByteBuffer buf, IOControl ioctrl) throws IOException {
            byte[] frame;
            ByteBufferBinaryInput input = new ByteBufferBinaryInput(buf);
            while ((frame = this.readFrame(input)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received response frame with size " + frame.length);
                }
                this.callback.received(new ByteArrayInputStream(frame));
            }
        }

        protected HttpResponse buildResult(HttpContext context) {
            logger.debug("Streaming HTTP response complete");
            return this.httpResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readFrame(BinaryInput input) throws IOException {
            FrameDeserializer frameDeserializer = this.deserializer;
            synchronized (frameDeserializer) {
                return this.deserializer.readFrame(input);
            }
        }
    }

    private static class SingleResponseConsumer
    extends DecoratorConsumer {
        private final CorrelatingClient.ResponseCallback callback;
        private final String requestContentType;
        private final AbortHandle abortHandle;

        public SingleResponseConsumer(CorrelatingClient.ResponseCallback callback, String requestContentType, AbortHandle abortHandle) {
            this.callback = callback;
            this.decorated = new BasicAsyncResponseConsumer();
            this.requestContentType = requestContentType;
            this.abortHandle = abortHandle;
        }

        @Override
        public void responseCompleted(HttpContext context) {
            super.responseCompleted(context);
            HttpResponse httpResponse = super.getResult();
            if (Util.checkRequestAborted(this.abortHandle, this.callback)) {
                return;
            }
            try {
                ApacheHttpUtil.validateHttpResponse(httpResponse, this.requestContentType);
                this.callback.received(httpResponse.getEntity().getContent());
            }
            catch (Exception ex) {
                logger.debug("Problem with HTTP response", (Throwable)ex);
                this.callback.failed(ApacheHttpClientExceptionTranslator.translate(ex, this.abortHandle));
            }
        }
    }

    private static class MainConsumer
    extends DecoratorConsumer {
        private final CorrelatingClient.ResponseCallback callback;
        private final String requestContentType;
        private final AbortHandle abortHandle;

        public MainConsumer(CorrelatingClient.ResponseCallback callback, String requestContentType, AbortHandle abortHandle) {
            this.callback = callback;
            this.requestContentType = requestContentType;
            this.abortHandle = abortHandle;
        }

        @Override
        public void responseReceived(HttpResponse response) throws IOException, HttpException {
            Header ct = response.getFirstHeader("Content-Type");
            String contentType = null;
            if (ct != null) {
                contentType = ct.getValue();
            }
            if (contentType != null && contentType.startsWith("application/vnd.vmware.vapi.framed")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Receiving streaming HTTP response with content-type '" + contentType + "'");
                }
                this.decorated = new MultiResponseConsumer(new ChunkedTransferEncodingFrameDeserializer(), this.callback);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Receiving HTTP response with content-type '" + contentType + "'");
                }
                this.decorated = new SingleResponseConsumer(this.callback, this.requestContentType, this.abortHandle);
            }
            this.decorated.responseReceived(response);
        }
    }

    private static abstract class DecoratorConsumer
    implements HttpAsyncResponseConsumer<HttpResponse> {
        protected volatile HttpAsyncResponseConsumer<HttpResponse> decorated;

        private DecoratorConsumer() {
        }

        public void responseReceived(HttpResponse response) throws IOException, HttpException {
            if (this.decorated != null) {
                this.decorated.responseReceived(response);
            }
        }

        public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
            if (this.decorated != null) {
                this.decorated.consumeContent(decoder, ioctrl);
            }
        }

        public void responseCompleted(HttpContext context) {
            if (this.decorated != null) {
                this.decorated.responseCompleted(context);
            }
        }

        public void failed(Exception ex) {
            if (this.decorated != null) {
                this.decorated.failed(ex);
            }
        }

        public Exception getException() {
            if (this.decorated != null) {
                return this.decorated.getException();
            }
            return null;
        }

        public HttpResponse getResult() {
            if (this.decorated != null) {
                return (HttpResponse)this.decorated.getResult();
            }
            return null;
        }

        public boolean isDone() {
            if (this.decorated != null) {
                return this.decorated.isDone();
            }
            return false;
        }

        public void close() throws IOException {
            if (this.decorated != null) {
                this.decorated.close();
            }
        }

        public boolean cancel() {
            if (this.decorated != null) {
                return this.decorated.cancel();
            }
            return true;
        }
    }

    private static class FutureCallbackImpl
    implements FutureCallback<HttpResponse> {
        private final CorrelatingClient.ResponseCallback callback;
        private final AbortHandle abortHandle;

        public FutureCallbackImpl(AbortHandle abortHandle, CorrelatingClient.ResponseCallback callback) {
            this.callback = callback;
            this.abortHandle = abortHandle;
        }

        public void completed(HttpResponse result) {
        }

        public void failed(Exception ex) {
            logger.debug("HTTP exchange failed", (Throwable)ex);
            this.callback.failed(ApacheHttpClientExceptionTranslator.translate(ex, this.abortHandle));
        }

        public void cancelled() {
            logger.debug("HTTP exchange cancelled");
            this.callback.failed(ApacheHttpClientExceptionTranslator.translate(new CancellationException(), this.abortHandle));
        }
    }
}

