/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.l10n;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.internal.util.DateTimeConverter;
import com.vmware.vapi.l10n.LocalizationException;
import java.util.Calendar;
import org.apache.commons.lang.Validate;

public class MessageArgConverter {
    public Calendar toCalendarArgument(String arg) {
        Validate.notNull((Object)arg);
        try {
            return new DateTimeConverter().fromStringValue(arg);
        }
        catch (ConverterException ex) {
            throw new LocalizationException("Can't convert Calendar message argument", ex);
        }
    }

    public String fromCalendar(Calendar arg) {
        Validate.notNull((Object)arg);
        try {
            return new DateTimeConverter().toStringValue(arg);
        }
        catch (ConverterException ex) {
            throw new LocalizationException("Can't convert Calendar message argument", ex);
        }
    }

    public Long toLong(String arg) {
        try {
            return Long.valueOf(arg);
        }
        catch (NumberFormatException ex) {
            throw new LocalizationException("Can't convert Long message argument", ex);
        }
    }

    public String fromLong(Long arg) {
        try {
            return Long.toString(arg);
        }
        catch (NumberFormatException ex) {
            throw new LocalizationException("Can't convert Long message argument", ex);
        }
    }

    public Double toDouble(String arg) {
        try {
            return Double.valueOf(arg);
        }
        catch (NumberFormatException ex) {
            throw new LocalizationException("Can't convert Double message argument", ex);
        }
    }

    public String fromDouble(Double arg) {
        try {
            return Double.toString(arg);
        }
        catch (NumberFormatException ex) {
            throw new LocalizationException("Can't convert Double message argument", ex);
        }
    }

    public String[] convertToStrings(Object[] args) {
        if (args == null) {
            return new String[0];
        }
        String[] result = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.convertArgToString(args[i]);
        }
        return result;
    }

    String convertArgToString(Object arg) {
        Validate.notNull((Object)arg);
        if (arg.getClass() == Long.class) {
            return this.fromLong((Long)arg);
        }
        if (arg.getClass() == Double.class) {
            return this.fromDouble((Double)arg);
        }
        if (arg.getClass() == String.class) {
            return (String)arg;
        }
        if (arg instanceof Calendar) {
            return this.fromCalendar((Calendar)arg);
        }
        throw new LocalizationException("Unsupported type for message argument: " + arg.getClass());
    }
}

