/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.provider;

import com.vmware.vapi.ErrorValueFactory;
import com.vmware.vapi.bindings.server.impl.InvocationContextImpl;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.util.TaskUtil;
import com.vmware.vapi.provider.ApiInterface;
import com.vmware.vapi.provider.ApiMethod;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ApiMethodBasedApiInterface
implements ApiInterface {
    private final Map<MethodIdentifier, ApiMethod> methods = new HashMap<MethodIdentifier, ApiMethod>();
    private final InterfaceIdentifier ifaceId;
    private final InterfaceDefinition definition;

    public ApiMethodBasedApiInterface(InterfaceIdentifier iface) {
        this.ifaceId = iface;
        this.definition = new InterfaceDefinition(this.ifaceId, Collections.unmodifiableSet(this.methods.keySet()));
    }

    public ApiMethodBasedApiInterface(String iface) {
        this(new InterfaceIdentifier(iface));
    }

    @Override
    public InterfaceIdentifier getIdentifier() {
        return this.ifaceId;
    }

    @Override
    public InterfaceDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public MethodDefinition getMethodDefinition(MethodIdentifier methodId) {
        ApiMethod method = this.getMethod(methodId);
        if (method != null) {
            return method.getDefinition();
        }
        return null;
    }

    @Override
    public void invoke(ExecutionContext ctx, MethodIdentifier methodId, DataValue input, AsyncHandle<MethodResult> asyncHandle) {
        ApiMethod method = this.getMethod(methodId);
        if (method != null) {
            InvocationContextImpl invocationContext = new InvocationContextImpl(ctx, TaskUtil.isTaskInvocation(methodId.getName()));
            method.invoke(invocationContext, input, asyncHandle);
        } else {
            String operationId = methodId.getName();
            String serviceId = methodId.getInterfaceIdentifier().getName();
            ErrorValue error = ErrorValueFactory.buildErrorValue("com.vmware.vapi.std.errors.operation_not_found", "vapi.method.input.invalid.method", operationId, serviceId);
            MethodResult result = MethodResult.newErrorResult(error);
            asyncHandle.setResult(result);
        }
    }

    private ApiMethod getMethod(MethodIdentifier methodId) {
        if (this.methods.containsKey(methodId)) {
            return this.methods.get(methodId);
        }
        String methodName = methodId.getName();
        int taskIndex = methodName.lastIndexOf("$task");
        if (taskIndex != -1) {
            String nonTaskMethodName = methodName.substring(0, taskIndex);
            MethodIdentifier nonTaskMethodId = new MethodIdentifier(methodId.getInterfaceIdentifier(), nonTaskMethodName);
            return this.methods.get(nonTaskMethodId);
        }
        return null;
    }

    protected void registerMethod(ApiMethod method) {
        MethodIdentifier methodId = method.getIdentifier();
        this.methods.put(methodId, method);
    }
}

