/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.security.AuthenticationConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAuthenticationConfig
implements AuthenticationConfig {
    private static final Logger logger = LoggerFactory.getLogger(JsonAuthenticationConfig.class);
    private static final String AUTHENTICATION_SECTION_NAME = "authentication";
    private static final String PRODUCT_SECTION_NAME = "product";
    private static final String COMPONENT_SECTION_NAME = "component";
    private static final String SERVICES_SECTION_NAME = "services";
    private static final String PACKAGES_SECTION_NAME = "packages";
    private static final String OPERATIONS_SECTION_NAME = "operations";
    private static final String AUTHENTICATION_SCHEME_KEY = "authenticationScheme";
    private static final String SESSION_AWARE_TYPE_VALUE = "SessionAware";
    private static final String SCHEME_TYPE_KEY = "type";
    private static final String SCHEMES_SECTION = "schemes";
    private static final String LOAD_CONFIG_ERR_MSG = "Cannot load authentication config";
    private static final String FIND_CONFIG_ERR_MSG = "Cannot find authentication config file %s on the classpath";
    private Map<String, List<AuthenticationConfig.AuthnScheme>> ifaceRulesTable;
    private Map<String, List<AuthenticationConfig.AuthnScheme>> packageRulesTable;
    private Map<String, List<AuthenticationConfig.AuthnScheme>> operationRulesTable;

    public JsonAuthenticationConfig(String ... resourceNames) {
        Validate.notNull((Object)resourceNames);
        this.initRules(this.loadAndMergeConfig(resourceNames));
    }

    public JsonAuthenticationConfig(Reader ... configReaders) {
        Validate.notNull((Object)configReaders);
        this.initRules(this.loadAndMergeConfig(configReaders));
    }

    @Override
    public Map<String, List<AuthenticationConfig.AuthnScheme>> getPackageAuthenticationRules() {
        return this.packageRulesTable;
    }

    @Override
    public Map<String, List<AuthenticationConfig.AuthnScheme>> getIFaceAuthenticationRules() {
        return this.ifaceRulesTable;
    }

    @Override
    public Map<String, List<AuthenticationConfig.AuthnScheme>> getOperationAuthenticationRules() {
        return this.operationRulesTable;
    }

    private void initRules(Rules rules) {
        this.ifaceRulesTable = Collections.unmodifiableMap(rules.ifaceTable);
        this.operationRulesTable = Collections.unmodifiableMap(rules.operationTable);
        this.packageRulesTable = Collections.unmodifiableMap(rules.packageTable);
    }

    private Rules loadAndMergeConfig(String[] configs) {
        Rules result = new Rules();
        for (String config : configs) {
            Validate.notNull((Object)config);
            Rules rules = this.loadConfig(config);
            result.mergeConfigs(rules);
        }
        return result;
    }

    private Rules loadAndMergeConfig(Reader[] configs) {
        Rules result = new Rules();
        for (Reader config : configs) {
            Validate.notNull((Object)config);
            Rules rules = this.loadConfig(config);
            result.mergeConfigs(rules);
        }
        return result;
    }

    private Rules loadConfig(Reader configReader) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(configReader);
            return this.constructAuthnMap(rootNode);
        }
        catch (IOException e) {
            throw new RuntimeException(LOAD_CONFIG_ERR_MSG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rules loadConfig(String authnConfig) {
        InputStreamReader configStream = new InputStreamReader(this.getInputStream(authnConfig));
        try {
            Rules rules = this.loadConfig(configStream);
            return rules;
        }
        finally {
            IoUtil.silentClose(configStream);
        }
    }

    private Rules constructAuthnMap(JsonNode rootNode) {
        assert (rootNode != null);
        JsonNode authnNode = rootNode.get(AUTHENTICATION_SECTION_NAME);
        JsonNode componentNode = authnNode.get(COMPONENT_SECTION_NAME);
        if (componentNode == null) {
            componentNode = authnNode.get(PRODUCT_SECTION_NAME);
        }
        assert (componentNode != null);
        Map<String, AuthenticationConfig.AuthnScheme> schemes = this.loadSchemes(componentNode);
        Rules rules = new Rules();
        rules.packageTable = this.loadConfigSection(componentNode.get(PACKAGES_SECTION_NAME), schemes);
        rules.ifaceTable = this.loadConfigSection(componentNode.get(SERVICES_SECTION_NAME), schemes);
        rules.operationTable = this.loadConfigSection(componentNode.get(OPERATIONS_SECTION_NAME), schemes);
        return rules;
    }

    private Map<String, AuthenticationConfig.AuthnScheme> loadSchemes(JsonNode componentNode) {
        HashMap<String, AuthenticationConfig.AuthnScheme> result = new HashMap<String, AuthenticationConfig.AuthnScheme>();
        JsonNode schemesNode = componentNode.get(SCHEMES_SECTION);
        if (schemesNode == null) {
            logger.debug("No 'schemes' node found");
            return result;
        }
        Iterator schemesIterator = schemesNode.fields();
        while (schemesIterator.hasNext()) {
            Map.Entry scheme = (Map.Entry)schemesIterator.next();
            logger.debug("Parsing authentication scheme: {}", scheme.getKey());
            result.put((String)scheme.getKey(), this.createAuthnScheme((JsonNode)scheme.getValue()));
        }
        return result;
    }

    private AuthenticationConfig.AuthnScheme createAuthnScheme(JsonNode node) {
        assert (node != null);
        ArrayList<String> schemes = new ArrayList<String>();
        JsonNode type = node.findValue(SCHEME_TYPE_KEY);
        Validate.notNull((Object)type);
        if (type.textValue().equalsIgnoreCase(SESSION_AWARE_TYPE_VALUE)) {
            schemes.add("com.vmware.vapi.std.security.session_id");
        }
        JsonNode scheme = node.get(AUTHENTICATION_SCHEME_KEY);
        Validate.notNull((Object)scheme);
        if (!scheme.textValue().trim().isEmpty()) {
            schemes.add(scheme.textValue());
        }
        return new AuthenticationConfig.AuthnScheme(schemes);
    }

    private Map<String, List<AuthenticationConfig.AuthnScheme>> loadConfigSection(JsonNode rootNode, Map<String, AuthenticationConfig.AuthnScheme> schemes) {
        assert (rootNode != null && schemes != null);
        HashMap<String, List<AuthenticationConfig.AuthnScheme>> result = new HashMap<String, List<AuthenticationConfig.AuthnScheme>>();
        Iterator rules = rootNode.fields();
        while (rules.hasNext()) {
            Map.Entry rule = (Map.Entry)rules.next();
            JsonNode schemeListNode = (JsonNode)rule.getValue();
            Validate.isTrue((boolean)schemeListNode.isArray());
            ArrayList<AuthenticationConfig.AuthnScheme> schemeList = new ArrayList<AuthenticationConfig.AuthnScheme>();
            for (JsonNode schemeName : schemeListNode) {
                AuthenticationConfig.AuthnScheme scheme = schemes.get(schemeName.asText());
                if (scheme == null) {
                    throw new RuntimeException("Unknown scheme name found " + schemeName);
                }
                schemeList.add(scheme);
            }
            result.put((String)rule.getKey(), (List<AuthenticationConfig.AuthnScheme>)schemeList);
        }
        return result;
    }

    private InputStream getInputStream(String resourceName) {
        InputStream result = null;
        result = this.getInputStream(resourceName, Thread.currentThread().getContextClassLoader());
        if (result != null) {
            return result;
        }
        result = this.getInputStream(resourceName, this.getClass().getClassLoader());
        if (result != null) {
            return result;
        }
        result = this.getClass().getResourceAsStream(resourceName);
        if (result != null) {
            return result;
        }
        throw new RuntimeException(String.format(FIND_CONFIG_ERR_MSG, resourceName));
    }

    private InputStream getInputStream(String resourceName, ClassLoader cl) {
        return cl != null ? cl.getResourceAsStream(resourceName) : null;
    }

    private final class Rules {
        private Map<String, List<AuthenticationConfig.AuthnScheme>> ifaceTable = new HashMap<String, List<AuthenticationConfig.AuthnScheme>>();
        private Map<String, List<AuthenticationConfig.AuthnScheme>> packageTable = new HashMap<String, List<AuthenticationConfig.AuthnScheme>>();
        private Map<String, List<AuthenticationConfig.AuthnScheme>> operationTable = new HashMap<String, List<AuthenticationConfig.AuthnScheme>>();

        private Rules() {
        }

        public void mergeConfigs(Rules rules) {
            this.mergeRules(this.ifaceTable, rules.ifaceTable);
            this.mergeRules(this.operationTable, rules.operationTable);
            this.mergeRules(this.packageTable, rules.packageTable);
        }

        private void mergeRules(Map<String, List<AuthenticationConfig.AuthnScheme>> baseRules, Map<String, List<AuthenticationConfig.AuthnScheme>> newRules) {
            for (String entity : newRules.keySet()) {
                if (baseRules.containsKey(entity) && !baseRules.get(entity).equals(newRules.get(entity))) {
                    String mergeErrMsg = String.format("Merge conflict for entity %s", entity);
                    logger.warn(mergeErrMsg);
                    throw new RuntimeException(mergeErrMsg);
                }
                baseRules.put(entity, newRules.get(entity));
            }
        }
    }
}

