/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpAsyncConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerBase;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.core.util.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;

public class HttpAsyncConfigurationCompilerImpl
extends HttpConfigurationCompilerBase {
    @Override
    protected CompiledHttpConfiguration doCompile(HttpConfiguration config) {
        PoolingNHttpClientConnectionManager connManager;
        try {
            connManager = this.createConnectionManager(config);
        }
        catch (IOReactorException e) {
            throw new InternalException("Error creating connection manager", e);
        }
        RequestConfig defaultRequestConfig = this.buildDefaultRequestConfig(config);
        CloseableHttpAsyncClient asyncClient = this.createAsyncHttpClient(config, defaultRequestConfig, (NHttpClientConnectionManager)connManager);
        return new CompiledHttpAsyncConfigurationImpl(asyncClient, defaultRequestConfig, (NHttpClientConnectionManager)connManager, config.getCompressionSupport(), config.getKeepAlivePeriod());
    }

    protected PoolingNHttpClientConnectionManager createConnectionManager(HttpConfiguration config) throws IOReactorException {
        ConnectingIOReactor ioreactor = this.createConnectingIOReactor(config);
        Registry<SchemeIOSessionStrategy> schemeRegistry = this.createAsyncSchemeRegistry(config);
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager(ioreactor, schemeRegistry);
        this.configureConnMgr(connManager, config);
        return connManager;
    }

    protected void configureConnMgr(PoolingNHttpClientConnectionManager connManager, HttpConfiguration config) {
        connManager.setMaxTotal(config.getMaxConnections());
        connManager.setDefaultMaxPerRoute(config.getDefaultMaxConnectionsPerRoute());
        for (HttpConfiguration.RouteConfiguration route : config.getRouteConfigurations()) {
            HttpHost host = new HttpHost(route.getHostName(), route.getPort(), route.getScheme());
            connManager.setMaxPerRoute(new HttpRoute(host), route.getMaxConnections());
        }
    }

    protected ConnectingIOReactor createConnectingIOReactor(HttpConfiguration config) throws IOReactorException {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getNioThreadPoolSize()).setTcpNoDelay(config.getDisableNagle()).setSoTimeout(config.getTimeoutMs()).setConnectTimeout(config.getConnectTimeoutMs()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig, (ThreadFactory)new DefaultThreadFactory("VLSI-I/O dispatcher-"));
    }

    protected Registry<SchemeIOSessionStrategy> createAsyncSchemeRegistry(HttpConfiguration config) {
        RegistryBuilder builder = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        ThumbprintTrustManager trustManager = this.createThumbprintTrustManager(config);
        SSLContext sslContext = this.createSSLContext(config, trustManager);
        ThumbprintTrustManager thumbprintTrustManager = trustManager;
        thumbprintTrustManager.getClass();
        builder.register("https", (Object)new ThumbprintTrustManager.VlsiSslIoSessionStrategy(thumbprintTrustManager, sslContext, config.getEnabledProtocols()));
        return builder.build();
    }

    protected RequestConfig buildDefaultRequestConfig(HttpConfiguration config) {
        return RequestConfig.custom().setExpectContinueEnabled(false).setStaleConnectionCheckEnabled(config.getCheckStaleConnection()).setSocketTimeout(config.getTimeoutMs()).setConnectTimeout(config.getConnectTimeoutMs()).setCookieSpec("standard").build();
    }

    protected CloseableHttpAsyncClient createAsyncHttpClient(HttpConfiguration config, RequestConfig defaultRequestConfig, NHttpClientConnectionManager connManager) {
        CloseableHttpAsyncClient client;
        final long keepAlivePeriod = config.getKeepAlivePeriod();
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setUserAgent(config.getUserAgent()).setConnectionManager(connManager).setDefaultRequestConfig(defaultRequestConfig).setDefaultCookieSpecRegistry(HttpProtocolBindingBase.createCookieSpecProviderRegistry()).setThreadFactory((ThreadFactory)new DefaultThreadFactory("VLSI-I/O reactor-")).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return keepAlivePeriod;
            }
        });
        if (config.getDefaultProxyHost() != null) {
            builder.setProxy(new HttpHost(config.getDefaultProxyHost(), config.getDefaultProxyPort(), config.getDefaultProxyScheme()));
        }
        if (!(client = builder.build()).isRunning()) {
            client.start();
        }
        return client;
    }
}

