/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.impl;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.auth.CRAuthManager;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vim.zeppelin.cr.exception.CRAccessDeniedException;
import com.vmware.vim.zeppelin.cr.exception.CRRuntimeException;
import com.vmware.vim.zeppelin.cr.fs.CRFileData;
import com.vmware.vim.zeppelin.cr.fs.impl.FSFileSystemImpl;
import com.vmware.vim.zeppelin.cr.fs.impl.Permission;
import com.vmware.vim.zeppelin.cr.fs.impl.exception.CRIOException;
import com.vmware.vim.zeppelin.cr.fs.io.ChannelInputStream;
import com.vmware.vim.zeppelin.cr.fs.util.StringUtils;
import com.vmware.vim.zeppelin.cr.fs.util.Utils;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FSFileSystemImplForOlderVersion {
    static final String READ_ONLY_USER_LIST_KEY = "##readOnlyList";
    static final String READ_WRITE_USER_LIST_KEY = "##readWriteList";
    static final String READ_ONLY_GROUP_LIST_KEY = "##readOnlyGroupList";
    static final String READ_WRITE_GROUP_LIST_KEY = "##readWriteGroupList";
    private static final String ACL_LIST_DELIMITER = ",";
    private static final long _maxFileSize = 0xA00000L;

    private static boolean isAllowed(CRAuthManager authMgr, CRUser user, Set<CRAccessControl> acls, Permission permission) {
        if (authMgr != null && acls != null) {
            return authMgr.isAllowed(user, acls, permission.getIntValue());
        }
        return true;
    }

    private static void assertIsAllowed(CRAuthManager authMgr, CRUser user, String nodePath, Set<CRAccessControl> acls, Permission permission) throws CRAccessDeniedException {
        if (acls != null && !FSFileSystemImplForOlderVersion.isAllowed(authMgr, user, acls, permission)) {
            throw new CRAccessDeniedException("User " + user.getName() + " doesn't have " + permission.getDescription() + " privileges on node " + nodePath);
        }
    }

    private static String getACLKey(boolean isGroup, Permission permission) {
        String key;
        block9: {
            block8: {
                if (!isGroup) break block8;
                switch (permission) {
                    case READ: {
                        key = READ_ONLY_GROUP_LIST_KEY;
                        break block9;
                    }
                    case READ_WRITE: {
                        key = READ_WRITE_GROUP_LIST_KEY;
                        break block9;
                    }
                    default: {
                        throw new CRRuntimeException("Unsupported permission: " + permission.getDescription());
                    }
                }
            }
            switch (permission) {
                case READ: {
                    key = READ_ONLY_USER_LIST_KEY;
                    break;
                }
                case READ_WRITE: {
                    key = READ_WRITE_USER_LIST_KEY;
                    break;
                }
                default: {
                    throw new CRRuntimeException("Unsupported permission: " + permission.getDescription());
                }
            }
        }
        return key;
    }

    private static String extractAndAddRights(Set<CRAccessControl> acls, Map<String, String> metaData, boolean isGroup, Permission permission) {
        String key = FSFileSystemImplForOlderVersion.getACLKey(isGroup, permission);
        String stringGrantees = metaData.get(key);
        if (!StringUtils.isBlank(stringGrantees)) {
            String[] grantees;
            for (String grantee : grantees = stringGrantees.split(ACL_LIST_DELIMITER)) {
                acls.add(new CRAccessControl(new CRUser(grantee, isGroup), permission.getIntValue()));
            }
        }
        return key;
    }

    private static Set<CRAccessControl> getACLsFromMetadata(Map<String, String> metaData) {
        HashSet<CRAccessControl> acls = new HashSet<CRAccessControl>();
        FSFileSystemImplForOlderVersion.extractAndAddRights(acls, metaData, false, Permission.READ);
        FSFileSystemImplForOlderVersion.extractAndAddRights(acls, metaData, false, Permission.READ_WRITE);
        FSFileSystemImplForOlderVersion.extractAndAddRights(acls, metaData, true, Permission.READ);
        FSFileSystemImplForOlderVersion.extractAndAddRights(acls, metaData, true, Permission.READ_WRITE);
        return acls;
    }

    private static void removeAllACLsFromMetaData(Map<String, String> metaData) {
        metaData.remove(READ_ONLY_USER_LIST_KEY);
        metaData.remove(READ_WRITE_USER_LIST_KEY);
        metaData.remove(READ_ONLY_GROUP_LIST_KEY);
        metaData.remove(READ_WRITE_GROUP_LIST_KEY);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static FSFileSystemImpl.RevisionData getLatestFileRevision(File rootDir, CRAuthManager authMgr, CRUser user, ReadableByteChannel channel, Date revisionTimestamp, String nodePath, boolean onlyMetadata, boolean removeACLsFromMetadata, boolean checkACLs, String escapedNodePath) throws CRAccessDeniedException {
        FSFileSystemImpl.RevisionData revisionData;
        ChannelInputStream in = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            int numDataBytes;
            in = new ChannelInputStream(channel, false);
            bis = new BufferedInputStream(in);
            ois = new ObjectInputStream(bis);
            int numMetaDataEntries = ois.readInt();
            HashMap<String, String> metaData = new HashMap<String, String>(numMetaDataEntries);
            for (int i = 0; i < numMetaDataEntries; ++i) {
                String key = ois.readUTF();
                String value = (String)ois.readObject();
                metaData.put(key, value);
            }
            Set<CRAccessControl> acls = FSFileSystemImplForOlderVersion.getACLsFromMetadata(metaData);
            if (checkACLs) {
                FSFileSystemImplForOlderVersion.assertIsAllowed(authMgr, user, nodePath, acls, Permission.READ);
            }
            if ((long)(numDataBytes = ois.readInt()) > 0xA00000L) {
                throw new CRIOException("File contents is too large: " + numDataBytes + " bytes. Maximum allowed: " + 0xA00000L + " bytes.");
            }
            byte[] data = new byte[numDataBytes];
            if (numDataBytes < 0) {
                throw new CRIOException("Currupt content - negative content length");
            }
            if (numDataBytes > 0) {
                ois.readFully(data);
            }
            if (removeACLsFromMetadata) {
                FSFileSystemImplForOlderVersion.removeAllACLsFromMetaData(metaData);
            }
            CRFileData fileData = new CRFileData(data);
            metaData.remove(CRFileRevision.NODE_NAME_METADATA_KEY);
            metaData.remove(CRFileRevision.NODE_PATH_METADATA_KEY);
            CRFileRevision rev = new CRFileRevision(null, 1, fileData, revisionTimestamp, metaData);
            revisionData = new FSFileSystemImpl.RevisionData(acls, rev, Utils.getNodeName(nodePath), nodePath, revisionTimestamp);
        }
        catch (CRAccessDeniedException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new CRIOException("Failed to read file: " + nodePath, e2);
                }
            }
            catch (Throwable throwable) {
                Utils.close(ois);
                Utils.close(bis);
                Utils.close(in);
                throw throwable;
            }
        }
        Utils.close(ois);
        Utils.close(bis);
        Utils.close(in);
        return revisionData;
    }
}

