/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class ChannelInputStream
extends InputStream {
    private final InputStream _in;
    private final boolean _closeChannelWhenClosingStream;

    public ChannelInputStream(ReadableByteChannel channel, boolean closeChannelWhenClosingStream) {
        this._in = Channels.newInputStream(channel);
        this._closeChannelWhenClosingStream = closeChannelWhenClosingStream;
    }

    @Override
    public int read() throws IOException {
        return this._in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this._in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this._in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this._in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this._in.available();
    }

    @Override
    public void mark(int readlimit) {
        this._in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this._in.reset();
    }

    @Override
    public boolean markSupported() {
        return this._in.markSupported();
    }

    @Override
    public void close() throws IOException {
        if (this._closeChannelWhenClosingStream) {
            this._in.close();
        }
    }
}

