/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;

public class ChannelOutputStream
extends OutputStream {
    private final OutputStream _out;
    private final FileChannel _channel;
    private final boolean _closeChannelWhenClosingStream;

    public ChannelOutputStream(FileChannel channel, boolean closeChannelWhenClosingStream) {
        this._channel = channel;
        this._out = Channels.newOutputStream(channel);
        this._closeChannelWhenClosingStream = closeChannelWhenClosingStream;
    }

    @Override
    public void write(int b) throws IOException {
        this._out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this._out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this._out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
        this._channel.force(false);
    }

    @Override
    public void close() throws IOException {
        if (this._closeChannelWhenClosingStream) {
            this._out.close();
        }
    }
}

