/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.scheduling.impl;

import com.vmware.vim.binding.vim.scheduler.OnceTaskScheduler;
import com.vmware.vim.binding.vim.scheduler.ScheduledTask;
import com.vmware.vim.binding.vim.scheduler.TaskScheduler;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.scheduling.ScheduledTaskSpec;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduledOpsMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ScheduledOpsMutationProvider.class);
    private DataService _dataService;

    public ScheduledOpsMutationProvider(DataService dataService) {
        this._dataService = dataService;
        _logger.debug((Object)"Instance created");
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        TaskScheduler taskScheduler = (TaskScheduler)scheduledTaskSpec.recurrence;
        if (this.shouldRunNow(taskScheduler).booleanValue()) {
            this.runOperation(managedObjectReference, scheduledTaskSpec);
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        this.removeOperation(managedObjectReference);
        QueryUtil.waitUntilNotSearchable((DataService)this._dataService, (Object)managedObjectReference);
        return operationResult;
    }

    private void runOperation(ManagedObjectReference managedObjectReference, ScheduledTaskSpec scheduledTaskSpec) throws Exception {
        ScheduledTask scheduledTask = (ScheduledTask)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        scheduledTask.run();
    }

    private void removeOperation(ManagedObjectReference managedObjectReference) throws Exception {
        ScheduledTask scheduledTask = (ScheduledTask)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        scheduledTask.remove();
    }

    private Boolean shouldRunNow(TaskScheduler taskScheduler) {
        if (taskScheduler instanceof OnceTaskScheduler) {
            return ((OnceTaskScheduler)taskScheduler).runAt == null;
        }
        return false;
    }
}

