/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class BundleURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final String WAR_BUNDLE_ENTRY_SCHEMA = "war:bundle";
    private static final String WAR_TO_ENTRY_SEPARATOR = "\\^/";
    private static final String WAR_TO_ENTRY_SEPARATOR_NEW = "\\*/";

    public URLConnection openConnection(URL u) throws IOException {
        return new BundleURLConnection(u);
    }

    private static class BundleURLConnection
    extends URLConnection {
        private final URLConnection wrappedUrlConnection;
        private boolean connected = false;

        BundleURLConnection(URL url) throws IOException {
            super(url);
            this.wrappedUrlConnection = this.warToBundle(url).openConnection();
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                this.wrappedUrlConnection.connect();
                this.connected = true;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.wrappedUrlConnection.getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.wrappedUrlConnection.getPermission();
        }

        private URL warToBundle(URL u) throws MalformedURLException {
            String url = u.toExternalForm();
            if (url.startsWith(BundleURLStreamHandlerService.WAR_BUNDLE_ENTRY_SCHEMA)) {
                String path = url.substring(4);
                path = path.contains("*/") ? path.replaceFirst(BundleURLStreamHandlerService.WAR_TO_ENTRY_SEPARATOR_NEW, "") : path.replaceFirst(BundleURLStreamHandlerService.WAR_TO_ENTRY_SEPARATOR, "");
                return new URL(path);
            }
            return u;
        }
    }
}

