/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.CustomizationSpecItem;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementSpec;
import com.vmware.vim.binding.vim.vm.CloneSpec;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.ConfigSpec;
import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vim.vm.customization.AdapterMapping;
import com.vmware.vim.binding.vim.vm.customization.DhcpIpGenerator;
import com.vmware.vim.binding.vim.vm.customization.DhcpIpV6Generator;
import com.vmware.vim.binding.vim.vm.customization.IPSettings;
import com.vmware.vim.binding.vim.vm.customization.IpV6Generator;
import com.vmware.vim.binding.vim.vm.customization.LinuxPrep;
import com.vmware.vim.binding.vim.vm.customization.NameGenerator;
import com.vmware.vim.binding.vim.vm.customization.Specification;
import com.vmware.vim.binding.vim.vm.customization.Sysprep;
import com.vmware.vim.binding.vim.vm.customization.SysprepText;
import com.vmware.vim.binding.vim.vm.customization.UnknownIpGenerator;
import com.vmware.vim.binding.vim.vm.customization.UnknownIpV6Generator;
import com.vmware.vim.binding.vim.vm.customization.UnknownNameGenerator;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.VmConfigSpec;
import com.vmware.vsphere.client.vm.VmConvertSpec;
import com.vmware.vsphere.client.vm.VmCreateSpec;
import com.vmware.vsphere.client.vm.VmCustomizationSpecification;
import com.vmware.vsphere.client.vm.VmCustomizationValidationResult;
import com.vmware.vsphere.client.vm.VmDeviceConnectionSpec;
import com.vmware.vsphere.client.vm.VmNotesSpec;
import com.vmware.vsphere.client.vm.VmParentType;
import com.vmware.vsphere.client.vm.VmProvisioningType;
import com.vmware.vsphere.client.vm.VmRefreshSpec;
import com.vmware.vsphere.client.vm.VmRegistrationSpec;
import com.vmware.vsphere.client.vm.VmRemovalSpec;
import com.vmware.vsphere.client.vm.VmTemplateSpec;
import com.vmware.vsphere.client.vm.api.VmQuestionAnswerSpec;
import com.vmware.vsphere.client.vm.config.impl.ConfigSpecBuilder;
import com.vmware.vsphere.client.vm.ft.VmCreateSecondarySpec;
import com.vmware.vsphere.client.vm.ft.VmDisableSecondarySpec;
import com.vmware.vsphere.client.vm.ft.VmEnableSecondarySpec;
import com.vmware.vsphere.client.vm.ft.VmRestartSecondarySpec;
import com.vmware.vsphere.client.vm.ft.VmTestFailoverSpec;
import com.vmware.vsphere.client.vm.ft.VmTurnOffFtSpec;
import com.vmware.vsphere.client.vm.impl.CompatibilityResult;
import com.vmware.vsphere.client.vm.impl.CompatibilityValidator;
import com.vmware.vsphere.client.vm.impl.DrsStorageRecommendationValidator;
import com.vmware.vsphere.client.vm.powerops.VmPowerStateSpec;
import com.vmware.vsphere.client.vm.powerops.impl.VmPowerOpManager;
import com.vmware.vsphere.client.vm.storageDrs.VmRecommendationsSpec;
import com.vmware.vsphere.client.vm.storageDrs.impl.StoragePlacementSpecBuilder;
import com.vmware.vsphere.client.vm.storageDrs.impl.StorageRecommendationsValidator;
import com.vmware.vsphere.client.vm.tools.VmToolsInstallerSpec;
import com.vmware.vsphere.client.vm.tools.impl.VmToolsManager;
import com.vmware.vsphere.client.vm.util.CompatibilityCheck;
import com.vmware.vsphere.client.vm.util.LocalizableErrorFormatter;
import com.vmware.vsphere.client.vm.util.Util;
import com.vmware.vsphere.client.vm.util.ValidationResultFormatter;
import com.vmware.vsphere.client.vm.version.VmHwVersionSpec;
import com.vmware.vsphere.client.vm.version.impl.VmHwVersionManager;
import com.vmware.vsphere.client.vmui.provisioning.ComputeResourceCompatibilityCheckSpec;
import com.vmware.vsphere.client.vmui.provisioning.ComputeResourceCompatibilityResult;
import com.vmware.vsphere.client.vmui.provisioning.ComputeResourceCompatibilityValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmMutationProvider
implements MutationProvider {
    private static final String RESOURCE_BUNDLE_NAME = "vmservice";
    private static final Log _logger = LogFactory.getLog(VmMutationProvider.class);
    private final DataService _dataService;
    private final TaskMonitor _taskMonitor;
    private final LegacyAuthorizationService _authService;
    private final ServiceLocatorFactory _serviceLocatorFactory;
    private final CompatibilityValidator _compatibilityValidator;
    private final ComputeResourceCompatibilityValidator _computeResourceCompatibilityValidator;
    private final DrsStorageRecommendationValidator _drsStorageRecommendationValidator;
    private QueryExecutor _queryExecutor;

    public VmMutationProvider(DataService dataService, TaskMonitor taskMonitor, LegacyAuthorizationService authService, ServiceLocatorFactory serviceLocatorFactory, CompatibilityValidator compatibilityValidator, ComputeResourceCompatibilityValidator computeResourceCompatibilityValidator, DrsStorageRecommendationValidator drsStorageRecommendationValidator, QueryExecutor queryExecutor) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._authService = authService;
        this._serviceLocatorFactory = serviceLocatorFactory;
        this._compatibilityValidator = compatibilityValidator;
        this._computeResourceCompatibilityValidator = computeResourceCompatibilityValidator;
        this._drsStorageRecommendationValidator = drsStorageRecommendationValidator;
        this._queryExecutor = queryExecutor;
    }

    public OperationResult add(VmCreateSpec spec) {
        OperationResult result = this.checkSpec(spec, new String[0]);
        if (result.error != null) {
            return result;
        }
        if (spec.parentType == VmParentType.folder) {
            result = this.checkSpec(spec, "folder", "pool");
            if (result.error != null) {
                return result;
            }
            result.entity = spec.folder;
            try {
                ConfigSpec cs = ConfigSpecBuilder.createSpec(spec.spec);
                cs.name = MixedUtil.escapeVimEntityNameSpecialChars((String)cs.name);
                Folder folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.folder);
                ManagedObjectReference task = folder.createVm(cs, spec.pool, spec.host);
                result.task = task;
            }
            catch (Exception e) {
                _logger.error((Object)"Could not create VM in folder", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
            }
            return result;
        }
        if (spec.parentType == VmParentType.vapp) {
            if (spec.pool == null) {
                _logger.error((Object)"VmCreateSpec.pool cannot be null");
                result.entity = spec.pool;
                result.error = Util.getInvalidEntityFault();
                return result;
            }
            result.entity = spec.pool;
            try {
                ConfigSpec cs = ConfigSpecBuilder.createSpec(spec.spec);
                ResourcePool pool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.pool);
                ManagedObjectReference task = pool.createVm(cs, spec.host);
                result.task = task;
            }
            catch (Exception e) {
                _logger.error((Object)"Could not create VM in resource pool", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
            }
            return result;
        }
        result.error = new MethodFault("Unsupported parent type");
        return result;
    }

    public OperationResult addDeferred(VmCreateSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        OperationResult result = this.checkSpec(spec, new String[0]);
        if (result.error != null) {
            return result;
        }
        if (spec.parentType == VmParentType.folder) {
            result = this.checkSpec(spec, "folder", "pool");
            if (result.error != null) {
                return result;
            }
            try {
                ConfigSpec cs = ConfigSpecBuilder.createSpec(spec.spec);
                cs.name = MixedUtil.escapeVimEntityNameSpecialChars((String)cs.name);
                ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
                vcTaskSpec.action = SchedulingUtil.newMethodAction((String)"CreateVM_Task", (Object[])new Object[]{cs, spec.pool, spec.host});
                result.entity = scheduleSpec.scheduledTask != null ? SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec) : SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)spec.folder, (ScheduledTaskSpec)vcTaskSpec);
            }
            catch (Exception e) {
                _logger.error((Object)"addDeffered", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
            }
            return result;
        }
        if (spec.parentType == VmParentType.vapp) {
            result = this.checkSpec(spec, "pool");
            if (result.error != null) {
                return result;
            }
            try {
                ConfigSpec cs = ConfigSpecBuilder.createSpec(spec.spec);
                ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
                vcTaskSpec.action = SchedulingUtil.newMethodAction((String)"CreateChildVM_Task", (Object[])new Object[]{cs, spec.host});
                result.entity = scheduleSpec.scheduledTask != null ? SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec) : SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)spec.pool, (ScheduledTaskSpec)vcTaskSpec);
            }
            catch (Exception e) {
                _logger.error((Object)"Could not create VM in resource pool", (Throwable)e);
                result.error = MixedUtil.getMethodFault((Throwable)e);
            }
            return result;
        }
        result.error = new MethodFault("Unsupported parent type");
        return result;
    }

    private OperationResult checkSpec(VmCloneSpec vmCloneSpec) {
        OperationResult result = new OperationResult();
        if (vmCloneSpec.vm == null) {
            _logger.error((Object)"VmCloneSpec.vm cannot be null");
            result.error = Util.getInvalidEntityFault("VmCloneSpec.vm");
            return result;
        }
        if (vmCloneSpec.folder == null) {
            _logger.error((Object)"VmCloneSpec.folder cannot be null");
            result.error = Util.getInvalidEntityFault("VmCloneSpec.folder");
            return result;
        }
        return result;
    }

    private OperationResult checkSpec(VmCreateSpec spec, String ... properties) {
        OperationResult result = new OperationResult();
        if (spec == null) {
            _logger.error((Object)"VmCreateSpec cannot be null");
            result.error = Util.getInvalidEntityFault("VmCreateSpec");
            return result;
        }
        if (properties == null) {
            return result;
        }
        for (String property : properties) {
            if (property.equals("folder") && spec.folder == null) {
                _logger.error((Object)"VmCreateSpec.folder cannot be null");
                result.error = Util.getInvalidEntityFault("VmCreateSpec.folder");
                return result;
            }
            if (!property.equals("pool") || spec.pool != null) continue;
            _logger.error((Object)"VmCreateSpec.pool cannot be null");
            result.error = Util.getInvalidEntityFault("VmCreateSpec.pool");
            return result;
        }
        return result;
    }

    public OperationResult add(VmCloneSpec vmCloneSpec) {
        OperationResult result = this.checkSpec(vmCloneSpec);
        if (result.error != null) {
            return result;
        }
        result.entity = vmCloneSpec.vm;
        try {
            com.vmware.vim.binding.vim.vApp.VmConfigSpec vAppConfig = null;
            if (vmCloneSpec.cloneSpec != null && vmCloneSpec.cloneSpec.config != null) {
                vAppConfig = vmCloneSpec.cloneSpec.config.vAppConfig;
            }
            if (vmCloneSpec.vmSpec != null) {
                vmCloneSpec.cloneSpec.config = ConfigSpecBuilder.buildSpec(vmCloneSpec.vmSpec);
                vmCloneSpec.cloneSpec.config.files = null;
            }
            if (vAppConfig != null) {
                if (vmCloneSpec.cloneSpec.config == null) {
                    vmCloneSpec.cloneSpec.config = new ConfigSpec();
                }
                vmCloneSpec.cloneSpec.config.vAppConfig = vAppConfig;
            }
            Util.populateSpecWithXvcInfo(vmCloneSpec, true, this._dataService, this._serviceLocatorFactory);
            String name = MixedUtil.escapeVimEntityNameSpecialChars((String)vmCloneSpec.name);
            if (vmCloneSpec.cloneSpec.customization != null && this.checkTypicalNetworkSettings(vmCloneSpec.cloneSpec.customization)) {
                int nicCount = this.countNics(vmCloneSpec.vm);
                this.updateCustomizationToUseStandardNetworkSettings(vmCloneSpec.cloneSpec.customization, nicCount);
            }
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmCloneSpec.vm);
            ManagedObjectReference task = vm.clone(vmCloneSpec.folder, name, vmCloneSpec.cloneSpec);
            result.task = task;
            return result;
        }
        catch (Exception e) {
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
    }

    public OperationResult addDeferred(VmCloneSpec vmCloneSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec schedulingSpec) {
        OperationResult result = this.checkSpec(vmCloneSpec);
        if (result.error != null) {
            return result;
        }
        result.entity = vmCloneSpec.vm;
        try {
            if (vmCloneSpec.vmSpec != null) {
                vmCloneSpec.cloneSpec.config = ConfigSpecBuilder.buildSpec(vmCloneSpec.vmSpec);
                vmCloneSpec.cloneSpec.config.files = null;
            }
            Util.populateSpecWithXvcInfo(vmCloneSpec, true, this._dataService, this._serviceLocatorFactory);
            String name = MixedUtil.escapeVimEntityNameSpecialChars((String)vmCloneSpec.name);
            ManagedObjectReference entity = null;
            entity = schedulingSpec.scheduledTask != null ? this.addDeferredExisting(vmCloneSpec.vm, name, vmCloneSpec.folder, vmCloneSpec.cloneSpec, schedulingSpec) : this.addDeferredNew(vmCloneSpec.vm, name, vmCloneSpec.folder, vmCloneSpec.cloneSpec, schedulingSpec);
            result.entity = entity;
        }
        catch (Exception e) {
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private ManagedObjectReference addDeferredExisting(ManagedObjectReference vm, String name, ManagedObjectReference folder, CloneSpec cloneSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)"CloneVM_Task", (Object[])new Object[]{folder, name, cloneSpec});
        vcTaskSpec.action = action;
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ManagedObjectReference addDeferredNew(ManagedObjectReference vm, String name, ManagedObjectReference folder, CloneSpec cloneSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)"CloneVM_Task", (Object[])new Object[]{folder, name, cloneSpec});
        vcTaskSpec.action = action;
        return SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)vm, (ScheduledTaskSpec)vcTaskSpec);
    }

    public OperationResult add(VmRecommendationsSpec spec) {
        OperationResult result = new OperationResult();
        if (spec == null) {
            _logger.error((Object)"VmRecommendationsSpec cannot be null.");
            result.error = Util.getInvalidEntityFault();
            return result;
        }
        if (spec.recommendations == null || spec.recommendations.length == 0) {
            _logger.error((Object)"VmRecommendationsSpec.recommendations cannot be null or empty.");
            result.error = Util.getInvalidEntityFault();
            return result;
        }
        try {
            StorageResourceManager storageManager = this.getStorageResourceManager(spec.moRef);
            ManagedObjectReference task = storageManager.applyRecommendation(spec.recommendations);
            result.task = task;
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult add(VmRegistrationSpec spec) {
        OperationResult opResult = new OperationResult();
        ResourcePool rp = null;
        String errorMessage = null;
        try {
            HostSystem host;
            Folder folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.folder);
            if (spec.pool != null && (rp = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.pool)) == null) {
                errorMessage = this.getLocalizedString("error.badresourcePool");
                throw new IllegalArgumentException(errorMessage);
            }
            if (spec.host != null && (host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.host)) == null) {
                errorMessage = this.getLocalizedString("error.badHost");
                throw new IllegalArgumentException(errorMessage);
            }
            String name = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name);
            if (VmMutationProvider.isVAppRelated(spec.pool)) {
                ResourcePool pool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.pool);
                opResult.task = pool.registerVm(spec.path, name, spec.host);
            } else {
                opResult.task = folder.registerVm(spec.path, name, spec.asTemplate.booleanValue(), spec.pool, spec.host);
            }
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference vm, VmCreateSecondarySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vm;
        try {
            VirtualMachine primaryVm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vm);
            boolean isVc60_OrLater = VcServiceUtil.is2014VcOrLater((String)vm.getServerGuid());
            result.task = spec.useCptFt && isVc60_OrLater ? primaryVm.createSecondaryEx(spec.host, spec.configSpec) : primaryVm.createSecondary(spec.host);
        }
        catch (Exception e) {
            _logger.error((Object)"Could not create secondary VM", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vm, VmTurnOffFtSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vm;
        try {
            VirtualMachine primaryVm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vm);
            result.task = primaryVm.turnOffFaultTolerance();
        }
        catch (Exception e) {
            _logger.error((Object)"Could not turn off fault tolerance for virtual machine.", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vm, VmEnableSecondarySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vm;
        try {
            VirtualMachine primaryVm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vm);
            ManagedObjectReference secondaryVmRef = Util.getSecondaryVmRef(this._dataService, vm);
            result.task = primaryVm.enableSecondary(secondaryVmRef, null);
        }
        catch (Exception e) {
            _logger.error((Object)"Could not disable secondary virtual machine.", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vm, VmDisableSecondarySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vm;
        try {
            VirtualMachine primaryVm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vm);
            ManagedObjectReference secondaryVmRef = Util.getSecondaryVmRef(this._dataService, vm);
            result.task = primaryVm.disableSecondary(secondaryVmRef);
        }
        catch (Exception e) {
            _logger.error((Object)"Could not disable secondary virtual machine.", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vm, VmTestFailoverSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vm;
        try {
            VirtualMachine primaryVm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vm);
            ManagedObjectReference secondaryVmRef = Util.getSecondaryVmRef(this._dataService, vm);
            result.task = primaryVm.makePrimary(secondaryVmRef);
            result.effect = new OperationEffect();
            result.effect.isDelayed = true;
        }
        catch (Exception e) {
            _logger.error((Object)"Could not test fault tolerance for virtual machine.", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vm, VmRestartSecondarySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vm;
        try {
            VirtualMachine primaryVm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vm);
            ManagedObjectReference secondaryVmRef = Util.getSecondaryVmRef(this._dataService, vm);
            result.task = primaryVm.terminateFaultTolerantVM(secondaryVmRef);
            result.effect = new OperationEffect();
            result.effect.isDelayed = true;
        }
        catch (Exception e) {
            _logger.error((Object)"Could not restart secondary virtual machine.", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] entities, VmPowerStateSpec spec) {
        VmPowerOpManager powerOpManager = new VmPowerOpManager(this._dataService, this._taskMonitor, this._authService);
        return powerOpManager.applyPowerOp(entities, spec);
    }

    public OperationResult[] applyOnMultiEntityDeferred(ManagedObjectReference[] entities, VmPowerStateSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        String operationId = null;
        try {
            Util.validatePowerStateSpec(spec);
            operationId = this.getMethodName(spec);
        }
        catch (IllegalArgumentException ex) {
            _logger.error((Object)"Invalid parameters to applyOnMultiEntityDeferred", (Throwable)ex);
            OperationResult result = new OperationResult();
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return new OperationResult[]{result};
        }
        OperationResult[] result = new OperationResult[entities.length];
        VmPowerOpManager powerOpManager = new VmPowerOpManager(this._dataService, this._taskMonitor, this._authService);
        String origTaskName = scheduleSpec.name;
        for (int i = 0; i < result.length; ++i) {
            OperationResult currentResult = new OperationResult();
            scheduleSpec.name = SchedulingUtil.formatTaskNameForBatch((String)origTaskName, (int)i, (int)result.length);
            ManagedObjectReference scheduledTaskRef = null;
            scheduledTaskRef = scheduleSpec.scheduledTask != null ? powerOpManager.applyEntityDeferredExisting(entities[i], spec, scheduleSpec, operationId) : powerOpManager.applyEntityDeferredNew(entities[i], spec, scheduleSpec, operationId);
            currentResult.entity = scheduledTaskRef;
            result[i] = currentResult;
        }
        return result;
    }

    private String getMethodName(VmPowerStateSpec spec) {
        String operationId = null;
        switch (spec.powerState) {
            case poweredOff: {
                if (spec.powerOpType == VmPowerStateSpec.PowerOpType.hard) {
                    operationId = "PowerOffVM_Task";
                    break;
                }
                operationId = "ShutdownGuest";
                break;
            }
            case poweredOn: {
                if (spec.reset) {
                    if (spec.powerOpType == VmPowerStateSpec.PowerOpType.hard) {
                        operationId = "ResetVM_Task";
                        break;
                    }
                    operationId = "RebootGuest";
                    break;
                }
                operationId = "PowerOnVM_Task";
                break;
            }
            case suspended: {
                operationId = "SuspendVM_Task";
                break;
            }
            default: {
                throw new IllegalArgumentException(Util.getLocalizedString("error.unrecognizedPowerOp"));
            }
        }
        return operationId;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmToolsInstallerSpec spec) {
        return VmToolsManager.apply(vmRef, spec);
    }

    public OperationResult apply(ManagedObjectReference entity, VmHwVersionSpec spec) {
        return VmHwVersionManager.apply(entity, spec);
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmNotesSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            ConfigSpec config = new ConfigSpec();
            config.annotation = spec.notes;
            ManagedObjectReference task = vm.reconfigure(config);
            result.task = task;
        }
        catch (Exception e) {
            _logger.error((Object)("Could not reconfigure VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmTemplateSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            vm.markAsTemplate();
        }
        catch (Exception e) {
            _logger.error((Object)("Could not convert VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef) + " to template."), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmRefreshSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        OperationEffect effect = new OperationEffect();
        effect.isDelayed = true;
        result.effect = effect;
        return result;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmConvertSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            vm.markAsVirtualMachine(spec.pool, spec.host);
        }
        catch (Exception e) {
            _logger.error((Object)("Could not convert template " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef) + " to virtual machine."), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmConfigSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            ConfigSpec cs = ConfigSpecBuilder.buildSpec(spec);
            cs.crypto = spec.cryptoSpec;
            ManagedObjectReference task = vm.reconfigure(cs);
            result.task = task;
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Could not reconfigure VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmRecommendationsSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            StorageResourceManager storageManager = this.getStorageResourceManager(vmRef);
            ManagedObjectReference task = storageManager.applyRecommendation(spec.recommendations);
            result.task = task;
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Could not reconfigure VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmQuestionAnswerSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            vm.answer(spec.questionId, spec.answerChoice);
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Could not answer VM question " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmDeviceConnectionSpec spec) {
        assert (vmRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            ConfigSpec cs = new ConfigSpec();
            cs.deviceChange = new VirtualDeviceSpec[1];
            cs.deviceChange[0] = spec.deviceSpec;
            ManagedObjectReference task = vm.reconfigure(cs);
            result.task = task;
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Could not reconfigure VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmCustomizationSpecification spec) {
        assert (vmRef != null);
        assert (spec != null);
        assert (spec.spec != null);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            if (this.checkTypicalNetworkSettings(spec.spec)) {
                int nicCount = this.countNics(vmRef);
                this.updateCustomizationToUseStandardNetworkSettings(spec.spec, nicCount);
            }
            ManagedObjectReference task = vm.customize(spec.spec);
            result.task = task;
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)("Could not customize VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
            return result;
        }
    }

    public OperationResult applyDeferred(ManagedObjectReference vmRef, VmConfigSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        OperationResult result = new OperationResult();
        try {
            ManagedObjectReference entity = null;
            entity = scheduleSpec.scheduledTask != null ? this.applyDeferredExisting(vmRef, spec, scheduleSpec) : this.applyDeferredNew(vmRef, spec, scheduleSpec);
            result.entity = entity;
        }
        catch (Exception ex) {
            _logger.error((Object)"Could not update the scheduled task of the virtual machine", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return result;
        }
        return result;
    }

    private ManagedObjectReference applyDeferredExisting(ManagedObjectReference rp, VmConfigSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        ConfigSpec cs = ConfigSpecBuilder.buildSpec(spec);
        MethodAction action = SchedulingUtil.newMethodAction((String)"ReconfigVM_Task", (Object[])new Object[]{cs});
        vcTaskSpec.action = action;
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ManagedObjectReference applyDeferredNew(ManagedObjectReference vm, VmConfigSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        ConfigSpec cs = ConfigSpecBuilder.buildSpec(spec);
        MethodAction action = SchedulingUtil.newMethodAction((String)"ReconfigVM_Task", (Object[])new Object[]{cs});
        vcTaskSpec.action = action;
        return SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)vm, (ScheduledTaskSpec)vcTaskSpec);
    }

    public OperationResult remove(ManagedObjectReference vmRef, VmRemovalSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = vmRef;
        _logger.info((Object)("Removing VirtualMachine: " + vmRef));
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            if (spec.deleteFromDisk != null && spec.deleteFromDisk.booleanValue()) {
                opResult.task = vm.destroy();
            } else {
                vm.unregister();
            }
            _logger.info((Object)("Removed VirtualMachine: " + vmRef));
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public ValidationResult validate(ManagedObjectReference vm, VmCloneSpec vmCloneSpec) throws Exception {
        return this._drsStorageRecommendationValidator.validate(vm, vmCloneSpec);
    }

    public ValidationResult validate(ManagedObjectReference managedObjectRef, VmCreateSpec createSpec) throws Exception {
        StoragePlacementSpec spec = StoragePlacementSpecBuilder.createSpec(createSpec);
        StorageRecommendationsValidator validator = new StorageRecommendationsValidator(managedObjectRef, spec);
        ValidationResult result = validator.getValidationResult();
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vm, VmConfigSpec vmConfigSpec) throws Exception {
        StoragePlacementSpec spec = StoragePlacementSpecBuilder.createSpec(vm, vmConfigSpec);
        StorageRecommendationsValidator validator = new StorageRecommendationsValidator(vm, spec);
        ValidationResult result = validator.getValidationResult();
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vmRef, String specInfoName) throws Exception {
        ValidationResult result = new ValidationResult();
        VcService service = VimSessionUtil.getService((String)vmRef.getServerGuid());
        CustomizationSpecManager cstManager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().customizationSpecManager);
        CustomizationSpecItem specItem = cstManager.get(specInfoName);
        VmCustomizationValidationResult resultSpec = new VmCustomizationValidationResult();
        resultSpec.specInfoName = specInfoName;
        resultSpec.isPublicKeyTheSame = this.checkPublicKey(cstManager, specItem);
        if (this.checkTypicalNetworkSettings(specItem.spec)) {
            resultSpec.areTypicalNetworkingSettingsUsed = true;
        } else {
            boolean isNicCountMatching = true;
            int vmNetworkCardCount = this.countNics(vmRef);
            if (specItem.spec.nicSettingMap == null) {
                if (vmNetworkCardCount > 0) {
                    isNicCountMatching = false;
                }
            } else {
                isNicCountMatching = vmNetworkCardCount == specItem.spec.nicSettingMap.length;
            }
            resultSpec.isNetworkCardsCountTheSame = isNicCountMatching;
        }
        resultSpec.spec = specItem.spec;
        NameGenerator nameSpec = null;
        if (specItem.spec.identity instanceof LinuxPrep) {
            nameSpec = ((LinuxPrep)specItem.spec.identity).hostName;
        } else if (specItem.spec.identity instanceof Sysprep) {
            nameSpec = ((Sysprep)specItem.spec.identity).userData.computerName;
        }
        resultSpec.hasUnknownNameTypeGen = nameSpec != null ? nameSpec instanceof UnknownNameGenerator : false;
        resultSpec.hasUnknownIpv4TypeGen = false;
        resultSpec.hasUnknownIpv6TypeGen = false;
        if (specItem.spec.nicSettingMap != null) {
            for (int i = 0; i < specItem.spec.nicSettingMap.length; ++i) {
                if (specItem.spec.nicSettingMap[i] == null || specItem.spec.nicSettingMap[i].adapter == null) continue;
                if (!resultSpec.hasUnknownIpv4TypeGen && specItem.spec.nicSettingMap[i].adapter.ip instanceof UnknownIpGenerator) {
                    resultSpec.hasUnknownIpv4TypeGen = true;
                }
                if (resultSpec.hasUnknownIpv6TypeGen || specItem.spec.nicSettingMap[i].adapter.ipV6Spec == null || specItem.spec.nicSettingMap[i].adapter.ipV6Spec.ip == null || specItem.spec.nicSettingMap[i].adapter.ipV6Spec.ip.length <= 0 || !(specItem.spec.nicSettingMap[i].adapter.ipV6Spec.ip[0] instanceof UnknownIpV6Generator)) continue;
                resultSpec.hasUnknownIpv6TypeGen = true;
            }
        }
        result.result = resultSpec;
        result.entity = vmRef;
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vmRef, VmCreateSecondarySpec spec) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{vmRef, spec});
        ValidationResult result = new ValidationResult();
        try {
            ManagedObjectReference clusterRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)"cluster");
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            ClusterComputeResource.FtConfigSpecVerificationResult verificationResult = cluster.verifyFaultToleranceConfigSpec(vmRef, spec.host, spec.configSpec);
            result.result = verificationResult;
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference objRef, CompatibilityCheck preCheckSpec) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objRef});
        ValidationUtil.paramsNotNull((Object[])new Object[]{preCheckSpec});
        CompatibilityResult generalCompatibilityResult = this._compatibilityValidator.validate(objRef, preCheckSpec);
        ValidationResult validationResult = new ValidationResult();
        if (generalCompatibilityResult.messages.size() != 0) {
            generalCompatibilityResult.vmCloneSpec = null;
            validationResult.result = new CompatibilityResult[]{generalCompatibilityResult};
        } else if (this.provisioningTypeIsClone(preCheckSpec.vmProvisioningType)) {
            if (preCheckSpec.disks != null) {
                generalCompatibilityResult.vmCloneSpec.cloneSpec.location.disk = preCheckSpec.disks;
            }
            validationResult = this.cloneValidation(objRef, generalCompatibilityResult);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference objRef, ComputeResourceCompatibilityCheckSpec checkSpec) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objRef});
        ValidationUtil.paramsNotNull((Object[])new Object[]{checkSpec});
        ComputeResourceCompatibilityResult compatibilityResult = this._computeResourceCompatibilityValidator.validate(objRef, checkSpec);
        ValidationResult validationResult = new ValidationResult();
        validationResult.result = new ComputeResourceCompatibilityResult[]{compatibilityResult};
        if (!compatibilityResult.messages.isEmpty()) {
            compatibilityResult.vmCloneSpec = null;
        } else if (this.provisioningTypeIsClone(checkSpec.vmProvisioningType)) {
            validationResult = this.cloneValidation(objRef, compatibilityResult);
            this.adaptResultForComputeResourceValidation(validationResult, compatibilityResult);
        }
        return validationResult;
    }

    private ValidationResult cloneValidation(ManagedObjectReference objRef, CompatibilityResult generalCompatibilityResult) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        List<Object> compatibilityResultsList = new ArrayList();
        ValidationResult validate = this._drsStorageRecommendationValidator.validate(objRef, generalCompatibilityResult.vmCloneSpec);
        if (validate.error != null) {
            String errorStr = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"compatibilityError.vmValidationError", (String[])new String[]{LocalizableErrorFormatter.buildMessage(validate.error)}, (ClassLoader)this.getClass().getClassLoader());
            generalCompatibilityResult.addErrorMessage(errorStr);
            generalCompatibilityResult.vmCloneSpec = null;
            compatibilityResultsList.add(generalCompatibilityResult);
            validationResult.result = compatibilityResultsList.toArray(new CompatibilityResult[compatibilityResultsList.size()]);
        } else {
            Map<ManagedObjectReference, CompatibilityResult> compatibilityResults = this.createHostCompatibilityResults((Result[])validate.result);
            compatibilityResultsList = this.addHostNameToCompatibilityResult(compatibilityResults);
            validationResult.result = compatibilityResultsList.toArray(new CompatibilityResult[compatibilityResultsList.size()]);
        }
        return validationResult;
    }

    private Map<ManagedObjectReference, CompatibilityResult> createHostCompatibilityResults(Result[] results) {
        HashMap<ManagedObjectReference, CompatibilityResult> compatibilityResults = new HashMap<ManagedObjectReference, CompatibilityResult>();
        if (results == null) {
            return compatibilityResults;
        }
        for (Result result : results) {
            if (result == null) continue;
            CompatibilityResult tempCompatibilityResult = new CompatibilityResult();
            if (result.getError() != null || result.getWarning() != null) {
                tempCompatibilityResult = ValidationResultFormatter.format(result, true);
            }
            tempCompatibilityResult.host = result.getHost();
            compatibilityResults.put(result.getHost(), tempCompatibilityResult);
        }
        return compatibilityResults;
    }

    private List<CompatibilityResult> addHostNameToCompatibilityResult(Map<ManagedObjectReference, CompatibilityResult> compatibilityResults) throws Exception {
        Set<ManagedObjectReference> hosts = compatibilityResults.keySet();
        if (compatibilityResults.size() > 0) {
            PropertyValue[] hostsProperties;
            for (PropertyValue property : hostsProperties = this._queryExecutor.getProperties(hosts.toArray(new Object[hosts.size()]), new String[]{"name"})) {
                compatibilityResults.get((Object)property.resourceObject).hostName = (String)property.value;
            }
        }
        return new ArrayList<CompatibilityResult>(compatibilityResults.values());
    }

    private void adaptResultForComputeResourceValidation(ValidationResult validationResult, ComputeResourceCompatibilityResult computeResourceCompatibilityResult) {
        CompatibilityResult[] resultList = (CompatibilityResult[])validationResult.result;
        if (resultList == null || resultList.length < 1) {
            return;
        }
        CompatibilityResult cloneValidationResult = resultList[0];
        computeResourceCompatibilityResult.hostName = cloneValidationResult.hostName;
        computeResourceCompatibilityResult.host = cloneValidationResult.host;
        computeResourceCompatibilityResult.messages = cloneValidationResult.messages;
        resultList[0] = computeResourceCompatibilityResult;
    }

    private boolean provisioningTypeIsClone(VmProvisioningType provisioningType) {
        return provisioningType == VmProvisioningType.cloneTemplateToVm || provisioningType == VmProvisioningType.cloneVmToVm || provisioningType == VmProvisioningType.cloneVmToTemplate || provisioningType == VmProvisioningType.cloneTemplateToTemplate;
    }

    private boolean checkPublicKey(CustomizationSpecManager cstManager, CustomizationSpecItem specItem) {
        if (!"Windows".equalsIgnoreCase(specItem.info.type) || specItem.spec.identity instanceof SysprepText) {
            return true;
        }
        byte[] key = cstManager.getEncryptionKey();
        return Arrays.equals(key, specItem.spec.encryptionKey);
    }

    private boolean checkTypicalNetworkSettings(Specification spec) {
        if (ArrayUtil.isNullOrEmpty((Object[])spec.nicSettingMap)) {
            return true;
        }
        if (spec.nicSettingMap.length > 1) {
            return false;
        }
        IPSettings adapter = spec.nicSettingMap[0].adapter;
        return adapter != null && adapter.ip != null && adapter.ip instanceof DhcpIpGenerator && ArrayUtil.isNullOrEmpty((Object[])adapter.dnsServerList) && ArrayUtil.isNullOrEmpty((Object[])adapter.gateway) && StringUtil.isNullOrEmpty((String)adapter.primaryWINS) && StringUtil.isNullOrEmpty((String)adapter.secondaryWINS) && StringUtil.isNullOrEmpty((String)adapter.subnetMask);
    }

    private int countNics(ManagedObjectReference vmRef) throws Exception {
        int count = 0;
        ConfigInfo config = (ConfigInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)"config");
        if (config == null) {
            return 0;
        }
        VirtualDevice[] devices = config.hardware.device;
        if (devices == null) {
            return 0;
        }
        for (VirtualDevice device : devices) {
            if (!(device instanceof VirtualEthernetCard)) continue;
            ++count;
        }
        return count;
    }

    private void updateCustomizationToUseStandardNetworkSettings(Specification spec, int nicCount) {
        spec.nicSettingMap = new AdapterMapping[nicCount];
        for (int i = 0; i < nicCount; ++i) {
            spec.nicSettingMap[i] = new AdapterMapping();
            spec.nicSettingMap[i].adapter = new IPSettings();
            spec.nicSettingMap[i].adapter.ip = new DhcpIpGenerator();
            spec.nicSettingMap[i].adapter.ipV6Spec = new IPSettings.IpV6AddressSpec();
            spec.nicSettingMap[i].adapter.ipV6Spec.ip = new IpV6Generator[1];
            spec.nicSettingMap[i].adapter.ipV6Spec.ip[0] = new DhcpIpV6Generator();
        }
    }

    private static boolean isVAppRelated(ManagedObjectReference testObject) {
        try {
            if (testObject == null) {
                return false;
            }
            ManagedEntity entity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)testObject);
            if (VirtualApp.class.isInstance(entity)) {
                return true;
            }
            return VmMutationProvider.isVAppRelated(entity.getParent());
        }
        catch (Exception exc) {
            _logger.error((Object)"Error encountered in checking for related vApp.", (Throwable)exc);
            return false;
        }
    }

    private StorageResourceManager getStorageResourceManager(ManagedObjectReference managedObjectRef) throws Exception {
        String serverGuid = managedObjectRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        StorageResourceManager storageManager = (StorageResourceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.storageResourceManager);
        return storageManager;
    }

    private String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)this.getClass().getClassLoader());
    }
}

