/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.DasVmConfigInfo;
import com.vmware.vim.binding.vim.cluster.DasVmSettings;
import com.vmware.vim.binding.vim.vm.CdromInfo;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigSpec;
import com.vmware.vim.binding.vim.vm.FloppyInfo;
import com.vmware.vim.binding.vim.vm.GuestOsDescriptor;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceOption;
import com.vmware.vim.binding.vim.vm.device.VirtualDiskOption;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.util.OvfUtil;
import com.vmware.vsphere.client.util.envbrowser.EnvironmentBrowserUtil;
import com.vmware.vsphere.client.vm.VmFaultToleranceServiceInternal;
import com.vmware.vsphere.client.vm.api.DatastoreMirrorsInfo;
import com.vmware.vsphere.client.vm.ft.VmFtCompatibleDatastores;
import com.vmware.vsphere.client.vm.util.StretchedStorageResolver;
import com.vmware.vsphere.client.vm.util.Util;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmPropertyProvider
implements PropertyProviderBean {
    private static final String CLUSTER_PROPERTY_DAS_VM_CONFIG = "configurationEx[@type='ClusterConfigInfoEx'].dasVmConfig";
    private static final String CLUSTER_PROPERTY_DAS_HA_ENABLED = "configurationEx[@type='ClusterConfigInfoEx'].dasConfig.enabled";
    private static final Log _logger = LogFactory.getLog(VmPropertyProvider.class);
    private DataService _dataService;
    private VmFaultToleranceServiceInternal _ftService;

    public VmPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public void setFtService(VmFaultToleranceServiceInternal ftService) {
        this._ftService = ftService;
    }

    @type(value="VirtualMachine")
    public boolean getThinProvisioningSupported(ManagedObjectReference virtualMachineRef) throws Exception {
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)virtualMachineRef);
        ManagedObjectReference environmentBrowserRef = vm.getEnvironmentBrowser();
        EnvironmentBrowser environmentBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)environmentBrowserRef);
        ConfigOption configOptions = environmentBrowser.queryConfigOption(null, null);
        if (configOptions == null) {
            return false;
        }
        for (VirtualDeviceOption deviceOption : configOptions.hardwareOptions.virtualDeviceOption) {
            if (!(deviceOption instanceof VirtualDiskOption)) continue;
            VirtualDiskOption virtualDiskOption = (VirtualDiskOption)deviceOption;
            for (VirtualDeviceOption.BackingOption backing : virtualDiskOption.backingOption) {
                if (!(backing instanceof VirtualDiskOption.FlatVer2BackingOption)) continue;
                VirtualDiskOption.FlatVer2BackingOption flatBackingVer2 = (VirtualDiskOption.FlatVer2BackingOption)backing;
                if (!flatBackingVer2.thinProvisioned.supported) continue;
                return true;
            }
        }
        return false;
    }

    @type(value="VirtualMachine")
    public VirtualDeviceOption[] getHardwareOptions(ManagedObjectReference vmRef) throws Exception {
        assert (vmRef != null);
        try {
            ConfigOption configOptions = Util.getVmConfigOption(vmRef);
            if (configOptions == null) {
                return null;
            }
            return configOptions.hardwareOptions.virtualDeviceOption;
        }
        catch (Exception e) {
            _logger.error((Object)"exception in getHardwareOptions", (Throwable)e);
            throw e;
        }
    }

    @type(value="VirtualMachine")
    public CdromInfo[] getHostCdromDevices(ManagedObjectReference vmRef) throws Exception {
        assert (vmRef != null);
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            assert (vm != null);
            ManagedObjectReference browserRef = vm.getEnvironmentBrowser();
            assert (browserRef != null);
            EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
            assert (browser != null);
            EnvironmentBrowser.ConfigTargetQuerySpec onlyDevicesSpec = new EnvironmentBrowser.ConfigTargetQuerySpec(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
            ConfigTarget configTarget = EnvironmentBrowserUtil.queryConfigTarget((EnvironmentBrowser)browser, null, (EnvironmentBrowser.ConfigTargetQuerySpec)onlyDevicesSpec);
            assert (configTarget != null);
            return configTarget.cdRom;
        }
        catch (Exception e) {
            _logger.error((Object)"exception in getHostCdromDevices", (Throwable)e);
            throw e;
        }
    }

    @type(value="VirtualMachine")
    public FloppyInfo[] getHostFloppyDevices(ManagedObjectReference vmRef) throws Exception {
        assert (vmRef != null);
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            assert (vm != null);
            ManagedObjectReference browserRef = vm.getEnvironmentBrowser();
            assert (browserRef != null);
            EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
            assert (browser != null);
            EnvironmentBrowser.ConfigTargetQuerySpec onlyDevicesSpec = new EnvironmentBrowser.ConfigTargetQuerySpec(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
            ConfigTarget configTarget = EnvironmentBrowserUtil.queryConfigTarget((EnvironmentBrowser)browser, null, (EnvironmentBrowser.ConfigTargetQuerySpec)onlyDevicesSpec);
            assert (configTarget != null);
            return configTarget.floppy;
        }
        catch (Exception e) {
            _logger.error((Object)"exception in getHostFloppyDevices", (Throwable)e);
            throw e;
        }
    }

    @type(value="VirtualMachine")
    public String getOvfEnvironment(ManagedObjectReference vmRef) throws Exception, RuntimeException, TransformerException {
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        String ovfenv = vm.extractOvfEnvironment();
        return OvfUtil.styleOvfSection((String)ovfenv);
    }

    @type(value="VirtualMachine")
    public ClusterComputeResource.FtCompatibleHostResult[] getFtCompatibleHosts(ManagedObjectReference vmRef, FaultToleranceConfigSpec placement) throws Exception {
        ClusterComputeResource.FtCompatibleHostResult[] result = new ClusterComputeResource.FtCompatibleHostResult[]{};
        if (this._ftService != null) {
            result = this._ftService.getFtCompatibleHosts(vmRef, placement);
        }
        return result;
    }

    @type(value="VirtualMachine")
    public VmFtCompatibleDatastores getFtCompatibleDatastores(ManagedObjectReference vmRef) throws Exception {
        VmFtCompatibleDatastores result = null;
        if (this._ftService != null) {
            result = this._ftService.getFtCompatibleDatastores(vmRef);
        }
        return result;
    }

    @type(value="VirtualMachine")
    public ClusterComputeResource.FtCompatibilityResult getFtCompatibility(ManagedObjectReference vmRef) throws Exception {
        ClusterComputeResource.FtCompatibilityResult result = null;
        if (this._ftService != null) {
            result = this._ftService.getFaultToleranceCompatibility(vmRef);
        }
        return result;
    }

    @type(value="VirtualMachine")
    public DasVmSettings getDasVmSettings(ManagedObjectReference vmRef) throws Exception {
        DasVmSettings vmSettings = null;
        PropertyValue[] values = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)vmRef, (String)"cluster", (String)"ClusterComputeResource", (String)CLUSTER_PROPERTY_DAS_VM_CONFIG);
        if (values != null) {
            for (PropertyValue pv : values) {
                DasVmConfigInfo[] VmConfigInfos;
                if (pv.value == null || !(pv.value instanceof DasVmConfigInfo[])) continue;
                for (DasVmConfigInfo vmConfigInfo : VmConfigInfos = (DasVmConfigInfo[])pv.value) {
                    if (vmConfigInfo == null || !vmConfigInfo.key.equals((Object)vmRef)) continue;
                    vmSettings = vmConfigInfo.dasSettings;
                }
            }
        }
        return vmSettings;
    }

    @type(value="VirtualMachine")
    public DatastoreMirrorsInfo[] getVmDatastoresInfo(ManagedObjectReference vmRef) throws Exception {
        StretchedStorageResolver storageResolver = new StretchedStorageResolver(this._dataService);
        return storageResolver.getDatastoresInfoByVm(vmRef);
    }

    @type(value="VirtualMachine")
    public boolean getHaEnabled(ManagedObjectReference vmRef) throws Exception {
        boolean haEnabled = false;
        PropertyValue[] values = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)vmRef, (String)"cluster", (String)"ClusterComputeResource", (String)CLUSTER_PROPERTY_DAS_HA_ENABLED);
        if (values != null) {
            for (PropertyValue pv : values) {
                if (pv.value == null || !(pv.value instanceof Boolean)) continue;
                haEnabled = (Boolean)pv.value;
            }
        }
        return haEnabled;
    }

    @type(value="VirtualMachine")
    public GuestOsDescriptor[] getGuestOsList(ManagedObjectReference vmRef) throws Exception {
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        ManagedObjectReference envBrowserMoref = vm.getEnvironmentBrowser();
        EnvironmentBrowser environmentBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserMoref);
        if (environmentBrowser == null) {
            return null;
        }
        ConfigOption configOption = environmentBrowser.queryConfigOption(null, null);
        GuestOsDescriptor[] retVal = configOption.guestOSDescriptor;
        return retVal;
    }

    @type(value="VirtualMachine")
    public String getToolsVersionXyz(ManagedObjectReference vmRef) throws Exception {
        if (vmRef == null) {
            return "";
        }
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            String ver = vm.getGuest().toolsVersion;
            int n = Integer.parseInt(ver);
            String retVal = VmPropertyProvider.formatXyzVersion(n);
            return retVal;
        }
        catch (Throwable e) {
            return "";
        }
    }

    private static String formatXyzVersion(int T) throws Exception {
        if (T <= 0 || T == -1 || T == Integer.MAX_VALUE) {
            return "";
        }
        int MJR = T / 1024;
        int MNR = T % 1024 / 32;
        int BASE = T % 1024 % 32;
        String format = "(%1$d.%2$d.%3$d)";
        String retVal = String.format(format, MJR, MNR, BASE);
        return retVal;
    }

    @type(value="VirtualMachine")
    public VirtualDevice[] getVmDevice(ManagedObjectReference vmRef) throws Exception {
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        return vm.getConfig().hardware.device;
    }
}

