/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceLocator;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcServiceLocatorFactory
implements ServiceLocatorFactory {
    private static final Log _logger = LogFactory.getLog(VcServiceLocatorFactory.class);
    private static final String VC_SERVICE_ENDPOINT_TYPE_ID = "com.vmware.vim";
    private static final String UPN_SEPARATOR = "@";
    private static final ServiceLocator INVALID_LOCATOR = new ServiceLocator();
    private final SsoService _ssoService;
    private final LookupService _lookupService;
    private final LoadingCache<Context, ServiceLocator> _cachedLocatorsByContext = CacheBuilder.newBuilder().softValues().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new Loader());

    public VcServiceLocatorFactory(SsoService ssoService, LookupService lookupService) {
        this._ssoService = ssoService;
        this._lookupService = lookupService;
    }

    public ServiceLocator newServiceLocator(String serviceId, ServiceLocator.NamePassword credential) {
        ServiceLocator vcLocator = this.createVcLocatorWithCredential(serviceId, (ServiceLocator.Credential)credential);
        return vcLocator;
    }

    public ServiceLocator newServiceLocator(String serviceId, SamlToken token, String delegeeServiceId) {
        ServiceLocator vcLocator = null;
        try {
            Context context = new Context(serviceId, token, delegeeServiceId);
            vcLocator = (ServiceLocator)this._cachedLocatorsByContext.getUnchecked((Object)context);
        }
        catch (IllegalArgumentException iaeException) {
            _logger.error((Object)("Invalid ServiceLocator creation context: " + iaeException.getMessage()), (Throwable)iaeException);
        }
        catch (Exception exception) {
            _logger.error((Object)("Unexpected error, while creating ServiceLocator for serviceId: " + serviceId + " and delegeeServiceId: " + delegeeServiceId + " : " + exception.getMessage()), (Throwable)exception);
        }
        if (vcLocator == INVALID_LOCATOR) {
            return null;
        }
        return vcLocator;
    }

    private ServiceLocator.Credential createSamlCredential(SamlToken token, String delegeeServiceId) {
        ServiceLocator.SAMLCredential credential = null;
        if (delegeeServiceId == null) {
            credential = new ServiceLocator.SAMLCredential(token.toXml());
            return credential;
        }
        try {
            ServiceRegistration.Info vcInfo = this._lookupService.find(delegeeServiceId);
            String delegateName = VcServiceLocatorFactory.extractUsernameFromUpn(vcInfo.getOwnerId());
            SamlToken delegatedToken = SsoUtil.getDelegatedToken((SsoService)this._ssoService, (SamlToken)token, (String)delegateName, (boolean)true);
            credential = new ServiceLocator.SAMLCredential(delegatedToken.toXml());
        }
        catch (EntryNotFoundFault lsFault) {
            _logger.error((Object)("Error, while retrieving delegee service from LS: " + lsFault.getMessage()), (Throwable)lsFault);
        }
        catch (SsoServiceException ssoException) {
            _logger.error((Object)("Error, while delegating token: " + ssoException.getMessage()), (Throwable)ssoException);
        }
        return credential;
    }

    private ServiceLocator createVcLocatorWithCredential(String serverGuid, ServiceLocator.Credential credential) {
        if (credential == null) {
            _logger.error((Object)"Error, during ServiceLocator creation! Provided credential must not be null!");
            return null;
        }
        String vcEndpointUrl = this.getVcEndpointUrl(serverGuid);
        if (vcEndpointUrl == null) {
            _logger.error((Object)("Error, during ServiceLocator creation! Cannot find ServiceEndpoint data for VC with GUID: " + serverGuid));
            return null;
        }
        ServiceDirectory.ServiceEndpoint vcEndpoint = VcServiceUtil.getServiceEndpoint((String)serverGuid);
        if (vcEndpoint == null) {
            _logger.error((Object)("Error, during ServiceLocator creation! Cannot find ServiceEndpoint data for VC with GUID: " + serverGuid));
            return null;
        }
        ServiceLocator vcLocator = new ServiceLocator(serverGuid, vcEndpointUrl, credential, vcEndpoint.sslThumbprint);
        return vcLocator;
    }

    private String getVcEndpointUrl(String serverGuid) {
        ServiceRegistration.Endpoint endpoint = null;
        try {
            ServiceRegistration.Info vcServiceInfo = this._lookupService.find(serverGuid);
            endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)vcServiceInfo, (String)VC_SERVICE_ENDPOINT_TYPE_ID);
        }
        catch (EntryNotFoundFault lsFault) {
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Url retrived from lookup service : " + endpoint.getUrl().toString()));
        }
        return endpoint.getUrl().toString();
    }

    private static String extractUsernameFromUpn(String ownerId) {
        if (ownerId == null) {
            return null;
        }
        String username = Utils.getStringBeforeSubStr((String)ownerId, (String)UPN_SEPARATOR);
        return username;
    }

    private static final class Context {
        private final String _serviceId;
        private final SamlToken _token;
        private final String _delegeeServiceId;
        private volatile int _hashCode;

        public Context(String serviceId, SamlToken token, String delegeeServiceId) {
            if (serviceId == null) {
                throw new IllegalArgumentException("The serviceId argument cannot be null!");
            }
            if (token == null) {
                throw new IllegalArgumentException("The token argument cannot be null!");
            }
            this._serviceId = serviceId;
            this._token = token;
            this._delegeeServiceId = delegeeServiceId;
        }

        public String serviceId() {
            return this._serviceId;
        }

        public SamlToken token() {
            return this._token;
        }

        public String delegeeServiceId() {
            return this._delegeeServiceId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context otherContext = (Context)other;
            if (!this._serviceId.equals(otherContext._serviceId)) {
                return false;
            }
            if (!Objects.equals(this._token.getId(), otherContext._token.getId())) {
                return false;
            }
            return Objects.equals(this._delegeeServiceId, otherContext._delegeeServiceId);
        }

        public int hashCode() {
            int result = this._hashCode;
            if (result == 0) {
                result = 17;
                result = 31 * result + this._serviceId.hashCode();
                result = 31 * result + Objects.hashCode(this._token.getId());
                this._hashCode = result = 31 * result + Objects.hashCode(this._delegeeServiceId);
            }
            return result;
        }
    }

    private final class Loader
    extends CacheLoader<Context, ServiceLocator> {
        private Loader() {
        }

        public ServiceLocator load(Context context) throws Exception {
            ServiceLocator.Credential credential = VcServiceLocatorFactory.this.createSamlCredential(context.token(), context.delegeeServiceId());
            ServiceLocator vcLocator = VcServiceLocatorFactory.this.createVcLocatorWithCredential(context.serviceId(), credential);
            if (vcLocator == null) {
                return INVALID_LOCATOR;
            }
            return vcLocator;
        }
    }
}

