/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.storageDrs.PodSelectionSpec;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementResult;
import com.vmware.vim.binding.vim.storageDrs.StoragePlacementSpec;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigInfo;
import com.vmware.vim.binding.vim.vm.FileInfo;
import com.vmware.vim.binding.vim.vm.ProfileSpec;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.check.ProvisioningChecker;
import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDeviceSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.data.QueryDataUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.vm.api.migration.VmLocationSpecValidatorConfiguration;
import com.vmware.vsphere.client.vm.check.CheckType;
import com.vmware.vsphere.client.vm.check.SdrsResult;
import com.vmware.vsphere.client.vm.migration.LocationSpec;
import com.vmware.vsphere.client.vm.migration.LocationSpecPair;
import com.vmware.vsphere.client.vm.migration.impl.DiskLocationInfo;
import com.vmware.vsphere.client.vm.storageDrs.impl.StorageRecommendationsValidator;
import com.vmware.vsphere.client.vm.storageDrs.impl.StorageValidationUtil;
import com.vmware.vsphere.client.vm.util.LocalizableErrorFormatter;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class VmLocationSpecValidator {
    private DataService _dataService;
    private TaskMonitor _taskMonitor;
    private LocationSpecPair[] _locationSpecs;
    private ArrayList<ValidationResult> _validationResults = null;
    private HashMap<String, ProvisioningChecker> _provisioningCheckerByVcServerCache = null;
    private HashMap<String, ManagedObjectReference> _vmBySubmittedTask = null;
    private Set<ManagedObjectReference> _submittedTasks = null;
    private List<TaskInfo> _completedTaskInfos = null;
    private final ServiceLocatorFactory _serviceLocatorFactory;
    private VmLocationSpecValidatorConfiguration _validatorConfiguration;
    private static Log _logger = LogFactory.getLog(VmLocationSpecValidator.class);
    private static int VMX_DISK_ID = -1;
    private String POD_CONFIG_ENABLED = "podStorageDrsEntry.storageDrsConfig.podConfig.enabled";
    private String POD_VM_CONFIG = "podStorageDrsEntry.storageDrsConfig.vmConfig";
    private static String PROPERTY_VM_FT_INFO = "config.ftInfo";
    private static String PROPERTY_VM_FT_STATE = "runtime.faultToleranceState";
    private static String PROPERTY_VM_POWER_STATE = "runtime.powerState";
    private static String PROPERTY_VM_HOST = "host";
    private static String PROPERTY_VM_RP = "resourcePool";
    private static String PROPERTY_RP_CR = "owner";
    private static String PROPERTY_HOST_CR = "parent";

    public VmLocationSpecValidator(DataService dataService, TaskMonitor taskMonitor, ServiceLocatorFactory serviceLocatorFactory, LocationSpecPair[] locationSpecPairs, VmLocationSpecValidatorConfiguration validatorConfiguration) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._locationSpecs = locationSpecPairs;
        this._serviceLocatorFactory = serviceLocatorFactory;
        this._validationResults = new ArrayList();
        this._vmBySubmittedTask = new HashMap();
        this._submittedTasks = new HashSet<ManagedObjectReference>();
        this._provisioningCheckerByVcServerCache = new HashMap();
        this._validatorConfiguration = validatorConfiguration;
    }

    public ValidationResult[] execute() throws Exception {
        for (LocationSpecPair entitySpec : this._locationSpecs) {
            ValidationResult validationResult = this.newValidationResultFor(entitySpec.entity);
            this._validationResults.add(validationResult);
            if (entitySpec.entity == null) {
                validationResult.error = Util.getInvalidEntityFault();
                continue;
            }
            try {
                Util.validateLocationSpec((DataObject)entitySpec.spec);
                ManagedObjectReference vm = entitySpec.entity;
                LocationSpec locationSpec = entitySpec.spec;
                Util.populateVcServiceIfNeeded(entitySpec, this._serviceLocatorFactory);
                Util.keepCurrentVmPoolIfPossible(entitySpec, this._dataService);
                RelocateSpec strippedSpec = null;
                DiskLocationInfo diskLocation = null;
                DiskLocationInfo newDiskLocation = null;
                boolean isStorageValidated = VmLocationSpecValidator.isStorageValidated(locationSpec);
                if (isStorageValidated) {
                    diskLocation = this.retriveDiskLocationInfo(vm);
                    this.padSpec(locationSpec.relocateSpec, diskLocation);
                    strippedSpec = this.cloneStorage(locationSpec.relocateSpec);
                    this.stripUnchangedStorage(strippedSpec, diskLocation);
                    newDiskLocation = this.retriveDiskLocationInfo(vm, strippedSpec);
                    this.copyDiskNames(diskLocation, newDiskLocation);
                }
                if (!this.executeFtChecks(vm, locationSpec)) {
                    return this._validationResults.toArray(new ValidationResult[0]);
                }
                if (!isStorageValidated || !this.isStoragePodInvolved(locationSpec.relocateSpec) && !this.isStoragePodInvolved(newDiskLocation) || this.isXVmotion(vm, locationSpec, newDiskLocation)) {
                    this.executeRelocateChecks(vm, locationSpec);
                    continue;
                }
                this.executeSdrsChecks(vm, locationSpec, strippedSpec, diskLocation, newDiskLocation);
            }
            catch (Exception e) {
                _logger.error((Object)"Error found during validation: ", (Throwable)e);
                validationResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
        }
        this._completedTaskInfos = this.monitorTasks(this._submittedTasks);
        this.gatherTaskResults();
        return this._validationResults.toArray(new ValidationResult[0]);
    }

    private List<TaskInfo> monitorTasks(Set<ManagedObjectReference> incompleteTasks) throws Exception {
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
        int sleepTimeInMs = 100;
        int maxSleepTimeInMs = 1000;
        while (!incompleteTasks.isEmpty()) {
            PropertyValue[] propertyValues;
            try {
                Thread.sleep(Math.min(sleepTimeInMs, maxSleepTimeInMs));
                sleepTimeInMs *= 2;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object[] incompleteTasksArr = incompleteTasks.toArray(new ManagedObjectReference[0]);
            for (PropertyValue propValue : propertyValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])incompleteTasksArr, (String)"info")) {
                ManagedObjectReference task = (ManagedObjectReference)propValue.resourceObject;
                TaskInfo info = (TaskInfo)propValue.value;
                if (!VmLocationSpecValidator.isTaskCompleted(info)) continue;
                result.add(info);
                incompleteTasks.remove(task);
            }
        }
        return result;
    }

    private static boolean isTaskCompleted(TaskInfo info) {
        if (info == null) {
            return false;
        }
        return info.state == TaskInfo.State.error || info.state == TaskInfo.State.success;
    }

    private static boolean isStorageValidated(LocationSpec spec) {
        boolean hasDatastoreTests = ArrayUtil.contains((Object)((Object)CheckType.datastoreTests), (Object[])spec.testsToRun);
        boolean hasStoragePodTests = ArrayUtil.contains((Object)((Object)CheckType.storagePodTests), (Object[])spec.testsToRun);
        return hasDatastoreTests || hasStoragePodTests;
    }

    private void executeRelocateChecks(ManagedObjectReference entity, LocationSpec spec) throws Exception {
        if (!ArrayUtil.contains((Object)((Object)CheckType.storagePodTests), (Object[])spec.testsToRun).booleanValue() || spec.testsToRun.length != 1) {
            ProvisioningChecker checker = this.getProvisioningChecker(entity.getServerGuid());
            this.submitCheckRelocateTask(entity, spec, checker);
        }
    }

    private boolean executeFtChecks(ManagedObjectReference vm, LocationSpec locationSpec) throws Exception {
        boolean isSecondary;
        if (!ArrayUtil.contains((Object)((Object)CheckType.resourcePoolTests), (Object[])locationSpec.testsToRun).booleanValue()) {
            return true;
        }
        RelocateSpec spec = locationSpec.relocateSpec;
        PropertyValue[] vmProps = QueryUtil.getProperties((DataService)this._dataService, (Object)vm, (String[])new String[]{PROPERTY_VM_FT_INFO, PROPERTY_VM_FT_STATE, PROPERTY_VM_RP});
        FaultToleranceConfigInfo ftInfo = null;
        VirtualMachine.FaultToleranceState ftState = null;
        ManagedObjectReference vmPool = null;
        for (PropertyValue val : vmProps) {
            if (val.propertyName.equals(PROPERTY_VM_FT_INFO)) {
                ftInfo = (FaultToleranceConfigInfo)val.value;
                continue;
            }
            if (val.propertyName.equals(PROPERTY_VM_FT_STATE)) {
                ftState = (VirtualMachine.FaultToleranceState)val.value;
                continue;
            }
            if (!val.propertyName.equals(PROPERTY_VM_RP)) continue;
            vmPool = (ManagedObjectReference)val.value;
        }
        boolean isFtConfigured = ftState != null && ftState != VirtualMachine.FaultToleranceState.notConfigured;
        boolean isPrimary = isFtConfigured && ftInfo != null && ftInfo.role == 1;
        boolean bl = isSecondary = isFtConfigured && ftInfo != null && ftInfo.role > 1;
        if (!isPrimary && !isSecondary) {
            return true;
        }
        Result result = null;
        ManagedObjectReference sourceCluster = this.getComputeResourceFor(vmPool);
        ManagedObjectReference targetCluster = this.getComputeResourceFor(spec.pool != null ? spec.pool : spec.host);
        if (targetCluster != null && !targetCluster.equals((Object)sourceCluster)) {
            result = this.newResultFor(vm, spec.host, true, "error.migrateFtVmOutsideCluster");
            this.setValidationResultFor(vm, result);
            return false;
        }
        if (spec.pool != null && !spec.pool.equals((Object)vmPool)) {
            if (isSecondary) {
                result = this.newResultFor(vm, spec.host, true, "error.migrateSecondaryVmOutsidePool");
                this.setValidationResultFor(vm, result);
                return false;
            }
            result = this.newResultFor(vm, spec.host, false, "warning.migratePrimaryVmToNewPool");
            this.setValidationResultFor(vm, result);
        }
        return true;
    }

    private ManagedObjectReference getComputeResourceFor(ManagedObjectReference entity) throws Exception {
        if (entity == null) {
            return null;
        }
        String propName = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)entity, VirtualApp.class)) {
            propName = PROPERTY_RP_CR;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, HostSystem.class)) {
            propName = PROPERTY_HOST_CR;
        } else {
            _logger.error((Object)("Invalid entity type: " + entity.getType()));
            String errorMsg = ResourceUtil.getString((String)Util.VM_SERVICE_STRINGS, (String)"error.invalidEntityType", (String[])new String[]{entity.getType()}, (ClassLoader)this.getClass().getClassLoader());
            throw new IllegalArgumentException(errorMsg);
        }
        QueryUtil.PropertyValueMap props = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new ManagedObjectReference[]{entity}, (String[])new String[]{propName});
        PropertyValue cr = props.getProperty((Object)entity, propName);
        return (ManagedObjectReference)cr.value;
    }

    private void executeSdrsChecks(ManagedObjectReference entity, LocationSpec spec, RelocateSpec strippedSpec, DiskLocationInfo currentDiskLocation, DiskLocationInfo newDiskLocation) throws Exception {
        if (!ArrayUtil.contains((Object)((Object)CheckType.storagePodTests), (Object[])spec.testsToRun).booleanValue()) {
            this.executeSdrSanityChecks(entity, spec, strippedSpec, currentDiskLocation, newDiskLocation, true);
            return;
        }
        this.executeSdrSanityChecks(entity, spec, strippedSpec, currentDiskLocation, newDiskLocation, false);
        PodSelectionSpec podSpec = this.buildRelatedPodSpec(entity, spec, currentDiskLocation, newDiskLocation);
        SdrsResult checkResult = this.validateStorageDrsRecomendations(entity, spec, podSpec);
        this.setValidationResultFor(entity, checkResult);
    }

    private void executeSdrSanityChecks(ManagedObjectReference entity, LocationSpec spec, RelocateSpec strippedSpec, DiskLocationInfo currentDiskLocation, DiskLocationInfo newDiskLocation, boolean addWarning) throws Exception {
        Result checkResult = null;
        checkResult = StorageValidationUtil.checkStorageIsDifferent(spec.relocateSpec, currentDiskLocation, true);
        if (!StorageValidationUtil.isStorageSpecified(strippedSpec).booleanValue()) {
            this.setValidationResultFor(entity, checkResult);
            return;
        }
        checkResult = StorageValidationUtil.checkForDisabledStoragePods(strippedSpec, newDiskLocation);
        if (checkResult != null) {
            this.setValidationResultFor(entity, checkResult);
            return;
        }
        if (!addWarning) {
            return;
        }
        checkResult = this.newValidationSkippedCheckResult(entity, spec.relocateSpec.host);
        this.setValidationResultFor(entity, checkResult);
    }

    private Result newValidationSkippedCheckResult(ManagedObjectReference vm, ManagedObjectReference host) {
        Result result = new Result();
        MethodFault fault = new MethodFault();
        fault.setMessage(Util.getLocalizedString("warning.storagePodNoValidation"));
        result.warning = new MethodFault[]{fault};
        result.vm = vm;
        result.host = host;
        return result;
    }

    private PodSelectionSpec buildRelatedPodSpec(ManagedObjectReference vm, LocationSpec locationSpec, DiskLocationInfo currentDiskLocation, DiskLocationInfo newDiskLocation) throws MethodFault {
        RelocateSpec relocSpec = locationSpec.relocateSpec;
        PodSelectionSpec podSpec = new PodSelectionSpec();
        HashMap<ManagedObjectReference, PodSelectionSpec.VmPodConfig> podConfigs = new HashMap<ManagedObjectReference, PodSelectionSpec.VmPodConfig>();
        HashMap<PodSelectionSpec.VmPodConfig, ArrayList<PodSelectionSpec.DiskLocator>> podDisks = new HashMap<PodSelectionSpec.VmPodConfig, ArrayList<PodSelectionSpec.DiskLocator>>();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)relocSpec.datastore, StoragePod.class)) {
            ManagedObjectReference pod = relocSpec.datastore;
            Boolean podChanged = StorageValidationUtil.isDiskLocationChanged(VMX_DISK_ID, pod, currentDiskLocation);
            podSpec.storagePod = podChanged != false ? relocSpec.datastore : null;
            relocSpec.datastore = null;
        } else {
            PodSelectionSpec.VmPodConfig podConfig = this.maybeDisablePodDrs(VMX_DISK_ID, vm, newDiskLocation, podConfigs);
            ManagedObjectReference managedObjectReference = podSpec.storagePod = podConfig != null ? podConfig.storagePod : null;
        }
        if (relocSpec.disk != null) {
            ArrayList<RelocateSpec.DiskLocator> fixedDisks = new ArrayList<RelocateSpec.DiskLocator>();
            PodSelectionSpec.VmPodConfig podConfig = null;
            for (RelocateSpec.DiskLocator disk : relocSpec.disk) {
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)disk.datastore, Datastore.class)) {
                    fixedDisks.add(disk);
                    podConfig = this.maybeDisablePodDrs(disk.diskId, vm, newDiskLocation, podConfigs);
                    this.addDiskLocator(podConfig, disk.diskId, disk.diskBackingInfo, disk.profile, podDisks);
                    continue;
                }
                ManagedObjectReference pod = disk.datastore;
                Boolean podChanged = StorageValidationUtil.isDiskLocationChanged(disk.diskId, pod, currentDiskLocation);
                if (!podChanged.booleanValue() && disk.profile == null) continue;
                podConfig = this.getPodConfig(pod, podConfigs);
                this.addDiskLocator(podConfig, disk.diskId, disk.diskBackingInfo, disk.profile, podDisks);
            }
            relocSpec.disk = (RelocateSpec.DiskLocator[])ArrayUtil.toArrayOrNull(fixedDisks, RelocateSpec.DiskLocator.class);
        }
        if (!podConfigs.isEmpty()) {
            ArrayList<PodSelectionSpec.VmPodConfig> initalVmPodConfigs = new ArrayList<PodSelectionSpec.VmPodConfig>();
            for (ManagedObjectReference pod : podConfigs.keySet()) {
                PodSelectionSpec.VmPodConfig podConfig = podConfigs.get(pod);
                ArrayList disks = (ArrayList)podDisks.get(podConfig);
                podConfig.disk = (PodSelectionSpec.DiskLocator[])ArrayUtil.toArrayOrNull((Collection)disks, PodSelectionSpec.DiskLocator.class);
                initalVmPodConfigs.add(podConfig);
            }
            podSpec.initialVmConfig = (PodSelectionSpec.VmPodConfig[])ArrayUtil.toArrayOrNull(initalVmPodConfigs, PodSelectionSpec.VmPodConfig.class);
        }
        return podSpec;
    }

    private void addDiskLocator(PodSelectionSpec.VmPodConfig podConfig, int diskId, VirtualDevice.BackingInfo diskBacking, ProfileSpec[] profile, HashMap<PodSelectionSpec.VmPodConfig, ArrayList<PodSelectionSpec.DiskLocator>> podDisks) {
        if (diskId == VMX_DISK_ID) {
            return;
        }
        if (podConfig == null) {
            return;
        }
        ArrayList<PodSelectionSpec.DiskLocator> disks = this.getPodDisks(podConfig, podDisks);
        PodSelectionSpec.DiskLocator podDiskLocator = new PodSelectionSpec.DiskLocator();
        podDiskLocator.diskId = diskId;
        podDiskLocator.diskBackingInfo = diskBacking;
        podDiskLocator.profile = profile;
        disks.add(podDiskLocator);
    }

    private PodSelectionSpec.VmPodConfig getPodConfig(ManagedObjectReference storagePod, Map<ManagedObjectReference, PodSelectionSpec.VmPodConfig> podConfigs) {
        PodSelectionSpec.VmPodConfig podConfig = podConfigs.get(storagePod);
        if (podConfig == null) {
            podConfig = this.newVmPodConfig(storagePod);
            podConfigs.put(storagePod, podConfig);
        }
        return podConfig;
    }

    private ArrayList<PodSelectionSpec.DiskLocator> getPodDisks(PodSelectionSpec.VmPodConfig podConfig, HashMap<PodSelectionSpec.VmPodConfig, ArrayList<PodSelectionSpec.DiskLocator>> podDisks) {
        ArrayList<Object> disks = podDisks.get(podConfig);
        if (disks == null) {
            disks = new ArrayList();
            podDisks.put(podConfig, disks);
        }
        return disks;
    }

    private PodSelectionSpec.VmPodConfig maybeDisablePodDrs(int diskId, ManagedObjectReference vm, DiskLocationInfo newDiskLocation, Map<ManagedObjectReference, PodSelectionSpec.VmPodConfig> podConfigs) {
        Boolean drsEnabled = newDiskLocation.drsEnabledByDiskId.get(diskId);
        if (drsEnabled == null || !drsEnabled.booleanValue()) {
            return null;
        }
        ManagedObjectReference storagePod = newDiskLocation.storagePodByDiskId.get(diskId);
        PodSelectionSpec.VmPodConfig podConfig = this.getPodConfig(storagePod, podConfigs);
        this.setPodDrs(podConfig, vm, false);
        return podConfig;
    }

    private PodSelectionSpec.VmPodConfig newVmPodConfig(ManagedObjectReference storagePod) {
        return this.newVmPodConfig(storagePod, null, true);
    }

    private PodSelectionSpec.VmPodConfig newVmPodConfig(ManagedObjectReference storagePod, ManagedObjectReference vm, boolean drsEnabled) {
        PodSelectionSpec.VmPodConfig result = new PodSelectionSpec.VmPodConfig();
        result.storagePod = storagePod;
        this.setPodDrs(result, vm, drsEnabled);
        return result;
    }

    private void setPodDrs(PodSelectionSpec.VmPodConfig podConfig, ManagedObjectReference vm, boolean drsEnabled) {
        if (podConfig.vmConfig != null) {
            if (drsEnabled) {
                podConfig.vmConfig = null;
            } else {
                podConfig.vmConfig.enabled = false;
            }
        } else if (!drsEnabled) {
            podConfig.vmConfig = new VmConfigInfo();
            podConfig.vmConfig.enabled = drsEnabled;
            podConfig.vmConfig.vm = vm;
        }
    }

    private boolean isXVmotion(ManagedObjectReference vm, LocationSpec locationSpec, DiskLocationInfo newDiskLocation) throws Exception {
        boolean isComputeResourceUnchanged;
        boolean isStorageUnchanged = newDiskLocation.datastoreByDiskId.isEmpty();
        ManagedObjectReference destinationPool = locationSpec.relocateSpec.pool;
        ManagedObjectReference destinationHost = locationSpec.relocateSpec.host;
        boolean bl = isComputeResourceUnchanged = destinationPool == null && destinationHost == null;
        if (isStorageUnchanged || isComputeResourceUnchanged) {
            return false;
        }
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new ManagedObjectReference[]{vm}, (String[])new String[]{PROPERTY_VM_HOST, PROPERTY_VM_POWER_STATE});
        PropertyValue hostPropValue = resultMap.getProperty((Object)vm, PROPERTY_VM_HOST);
        ManagedObjectReference currentHost = (ManagedObjectReference)hostPropValue.value;
        boolean isSameHost = ManagedObjectUtil.areEqual((ManagedObjectReference)currentHost, (ManagedObjectReference)destinationHost);
        PropertyValue powerStatePropValue = resultMap.getProperty((Object)vm, PROPERTY_VM_POWER_STATE);
        VirtualMachine.PowerState powerState = (VirtualMachine.PowerState)powerStatePropValue.value;
        boolean isVmPoweredOn = powerState == VirtualMachine.PowerState.poweredOn;
        boolean isXVmotion = !isSameHost && isVmPoweredOn;
        return isXVmotion;
    }

    private boolean isStoragePodInvolved(RelocateSpec relocSpec) {
        if (relocSpec == null) {
            return false;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)relocSpec.datastore, StoragePod.class)) {
            return true;
        }
        if (relocSpec.disk != null) {
            for (RelocateSpec.DiskLocator disk : relocSpec.disk) {
                if (!ManagedObjectUtil.isOfType((ManagedObjectReference)disk.datastore, StoragePod.class)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStoragePodInvolved(DiskLocationInfo newDiskLocation) {
        boolean result = false;
        for (Boolean drsEnabled : newDiskLocation.drsEnabledByDiskId.values()) {
            if (!drsEnabled.booleanValue()) continue;
            result = true;
            break;
        }
        return result;
    }

    private ValidationResult newValidationResultFor(Object entity) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = entity;
        return validationResult;
    }

    private Result newResultFor(ManagedObjectReference vm, ManagedObjectReference host, boolean isError, String descKey) {
        Result result = new Result();
        MethodFault fault = new MethodFault();
        fault.setMessage(Util.getLocalizedString(descKey));
        if (isError) {
            result.error = new MethodFault[]{fault};
        } else {
            result.warning = new MethodFault[]{fault};
        }
        result.vm = vm;
        result.host = host;
        return result;
    }

    private void gatherTaskResults() {
        for (TaskInfo taskInfo : this._completedTaskInfos) {
            ManagedObjectReference entity = this._vmBySubmittedTask.get(ManagedObjectUtil.morefToString((ManagedObjectReference)taskInfo.task));
            ValidationResult result = this.findValidationResultFor(entity);
            if (result == null) continue;
            if (taskInfo.state == TaskInfo.State.success) {
                if (this._validatorConfiguration.getIsManualLocalizationRequired()) {
                    VmLocationSpecValidator.localizeTaskResults((Result[])taskInfo.result);
                }
                result.result = ArrayUtils.addAll((Object[])((Object[])result.result), (Object[])((Result[])taskInfo.result));
                continue;
            }
            MethodFault fault = new MethodFault();
            fault.initCause((Throwable)taskInfo.error);
            if (this._validatorConfiguration.getIsManualLocalizationRequired()) {
                LocalizableErrorFormatter.localizeFault((Exception)fault);
            }
            result.error = fault;
        }
    }

    private ProvisioningChecker getProvisioningChecker(String serverGuid) throws Exception {
        ProvisioningChecker checker = this._provisioningCheckerByVcServerCache.get(serverGuid);
        if (checker == null) {
            checker = this.getProvisioningCheckerFromVCService(serverGuid);
            this._provisioningCheckerByVcServerCache.put(serverGuid, checker);
        }
        if (checker == null) {
            _logger.error((Object)("No Provisioning checker found for VC service, guid = " + serverGuid));
            String errorMsg = ResourceUtil.getString((String)Util.VM_SERVICE_STRINGS, (String)"error.provisioningCheckerNotFound", (ClassLoader)this.getClass().getClassLoader());
            throw new Exception(errorMsg);
        }
        return checker;
    }

    private void submitCheckRelocateTask(ManagedObjectReference entity, LocationSpec locationSpec, ProvisioningChecker checker) throws Exception {
        try {
            String[] testsToRun = this.convertTestTypesToStrings(locationSpec.testsToRun, new CheckType[]{CheckType.storagePodTests});
            ManagedObjectReference taskRef = checker.checkRelocate(entity, locationSpec.relocateSpec, testsToRun);
            this._submittedTasks.add(taskRef);
            this._vmBySubmittedTask.put(ManagedObjectUtil.morefToString((ManagedObjectReference)taskRef), entity);
        }
        catch (InvalidState e) {
            _logger.error((Object)("InvalidState exception received for checkRelocate for VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)entity)));
            throw e;
        }
        catch (Exception e) {
            _logger.error((Object)("Exception occurred for checkRelocate of VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)entity)));
            throw e;
        }
    }

    private String[] convertTestTypesToStrings(CheckType[] testTypes, CheckType[] skip) {
        ArrayList<String> tests = new ArrayList<String>();
        if (testTypes != null && testTypes.length > 0) {
            for (CheckType testType : testTypes) {
                if (ArrayUtil.contains((Object)((Object)testType), (Object[])skip).booleanValue()) continue;
                tests.add(testType.toString());
            }
        }
        String[] testsToRun = null;
        if (!tests.isEmpty()) {
            testsToRun = tests.toArray(new String[0]);
        }
        return testsToRun;
    }

    private ValidationResult findValidationResultFor(ManagedObjectReference entity) {
        if (this._validationResults != null) {
            for (ValidationResult result : this._validationResults) {
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)((ManagedObjectReference)result.entity), (ManagedObjectReference)entity).booleanValue()) continue;
                return result;
            }
        }
        return null;
    }

    private void setValidationResultFor(ManagedObjectReference entity, Result checkResult) {
        ValidationResult validationResult = this.findValidationResultFor(entity);
        if (validationResult != null) {
            validationResult.result = checkResult == null ? null : ArrayUtils.add((Object[])((Object[])validationResult.result), (Object)checkResult);
        }
    }

    private ProvisioningChecker getProvisioningCheckerFromVCService(String serverGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        if (vcService == null) {
            _logger.error((Object)("Could not get VcService for guid " + serverGuid));
            return null;
        }
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        if (content == null) {
            _logger.error((Object)("ServiceInstanceContent found null for VC service guid " + serverGuid));
            return null;
        }
        ProvisioningChecker checker = (ProvisioningChecker)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.vmProvisioningChecker);
        return checker;
    }

    private SdrsResult validateStorageDrsRecomendations(ManagedObjectReference vm, LocationSpec locationSpec, PodSelectionSpec podSpec) throws Exception {
        SdrsResult retVal = new SdrsResult();
        StoragePlacementSpec placementSpec = new StoragePlacementSpec();
        placementSpec.type = StoragePlacementSpec.PlacementType.relocate.toString();
        placementSpec.relocateSpec = locationSpec.relocateSpec;
        placementSpec.host = locationSpec.relocateSpec.host;
        placementSpec.resourcePool = locationSpec.relocateSpec.pool;
        placementSpec.vm = vm;
        placementSpec.priority = locationSpec.priority;
        placementSpec.podSelectionSpec = podSpec;
        placementSpec.resourceLeaseDurationSec = 180;
        ManagedObjectReference target = vm;
        StorageRecommendationsValidator drsValidator = new StorageRecommendationsValidator(target, placementSpec);
        try {
            drsValidator.cancelDatastoreRecommendations(locationSpec.cancelRecommendations, true);
            retVal.result = drsValidator.getDatastoreRecomendations();
        }
        catch (Exception e) {
            _logger.error((Object)"Exception happened when requested recommendations: ", (Throwable)e);
            _logger.debug((Object)"Will convert the exception info DrsFaults instance");
            retVal.result = this.newStoragePlacementResult(vm, e);
        }
        retVal.vm = vm;
        retVal.host = locationSpec.relocateSpec.host;
        return retVal;
    }

    private StoragePlacementResult newStoragePlacementResult(ManagedObjectReference vm, Exception e) {
        MethodFault fault = MixedUtil.getMethodFault((Throwable)e);
        DrsFaults.FaultsByVm vmFaults = new DrsFaults.FaultsByVm(vm, (Exception[])new MethodFault[]{fault});
        DrsFaults drsFaults = new DrsFaults(null, new DrsFaults.FaultsByVm[]{vmFaults});
        StoragePlacementResult retVal = new StoragePlacementResult(null, drsFaults, null);
        return retVal;
    }

    private String extractDatastoreName(String filePath) {
        Pattern DATASTORE_REGEXP = Pattern.compile("\\[(.*)\\]");
        Matcher matcher = DATASTORE_REGEXP.matcher(filePath);
        String retVal = null;
        if (matcher.find() && matcher.groupCount() > 0) {
            retVal = matcher.group(1);
        }
        return retVal;
    }

    private DiskLocationInfo retriveDiskLocationInfo(ManagedObjectReference vm) throws Exception {
        DiskLocationInfo retVal = new DiskLocationInfo();
        retVal.vm = vm;
        PropertyValue[] dsPropValues = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)vm, (String)"datastore", null, (String[])new String[]{"name", "parent"});
        PropertyValue[] result = QueryUtil.getProperties((DataService)this._dataService, (Object)vm, (String[])new String[]{"config.files", "config.hardware.device"});
        HashMap<String, ManagedObjectReference> podByDatastore = new HashMap<String, ManagedObjectReference>();
        if (dsPropValues != null) {
            for (PropertyValue dsPropValue : dsPropValues) {
                ManagedObjectReference parent;
                if (dsPropValue == null || dsPropValue.value == null || !dsPropValue.propertyName.equals("parent") || !ManagedObjectUtil.isOfType((ManagedObjectReference)(parent = (ManagedObjectReference)dsPropValue.value), StoragePod.class)) continue;
                podByDatastore.put(((ManagedObjectReference)dsPropValue.resourceObject).getValue(), parent);
            }
        }
        for (PropertyValue val : result) {
            VirtualDevice[] devices;
            if (val.propertyName.equals("config.files") && val.value != null) {
                FileInfo fileInfo = (FileInfo)val.value;
                String configFileDs = this.extractDatastoreName(fileInfo.vmPathName);
                if (configFileDs == null || dsPropValues == null) continue;
                PropertyValue[] propertyValueArray = dsPropValues;
                int n = propertyValueArray.length;
                for (int i = 0; i < n; ++i) {
                    PropertyValue dsPropValue = propertyValueArray[i];
                    if (!dsPropValue.propertyName.equals("name") || !dsPropValue.value.equals(configFileDs)) continue;
                    ManagedObjectReference ds = (ManagedObjectReference)dsPropValue.resourceObject;
                    retVal.datastoreByDiskId.put(VMX_DISK_ID, ds);
                    retVal.storagePodByDiskId.put(VMX_DISK_ID, (ManagedObjectReference)podByDatastore.get(ds.getValue()));
                    retVal.diskNameByDiskId.put(VMX_DISK_ID, Util.getLocalizedString("vm.configFile"));
                }
            }
            if (!val.propertyName.equals("config.hardware.device") || val.value == null) continue;
            for (VirtualDevice device : devices = (VirtualDevice[])val.value) {
                if (!(device instanceof VirtualDisk)) continue;
                VirtualDisk disk = (VirtualDisk)device;
                VirtualDevice.FileBackingInfo backing = (VirtualDevice.FileBackingInfo)disk.backing;
                ManagedObjectReference ds = backing.datastore;
                retVal.datastoreByDiskId.put(disk.key, ds);
                retVal.storagePodByDiskId.put(disk.key, (ManagedObjectReference)podByDatastore.get(ds.getValue()));
                retVal.diskNameByDiskId.put(disk.key, disk.deviceInfo.label);
                if (!Util.isPMemBacking(backing)) continue;
                retVal.pmemDiskNameByDiskId.put(disk.key, disk.deviceInfo.label);
            }
        }
        return retVal;
    }

    private DiskLocationInfo retriveDiskLocationInfo(ManagedObjectReference vm, RelocateSpec spec) throws Exception {
        DiskLocationInfo result = new DiskLocationInfo();
        result.vm = vm;
        Object[] datastores = this.collectDatastores(spec);
        QueryUtil.PropertyValueMap parents = new QueryUtil.PropertyValueMap();
        if (datastores.length > 0) {
            String[] properties = new String[]{"parent"};
            parents = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])datastores, (String[])properties);
        }
        QueryUtil.PropertyValueMap podInfo = new QueryUtil.PropertyValueMap();
        Object[] storagePods = this.collectStoragePods(spec, parents);
        if (storagePods.length > 0) {
            String[] properties = new String[]{this.POD_CONFIG_ENABLED, this.POD_VM_CONFIG};
            podInfo = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])storagePods, (String[])properties);
        }
        this.fillLocationInfo(vm, VMX_DISK_ID, spec.datastore, parents, podInfo, result);
        if (spec.disk != null) {
            for (RelocateSpec.DiskLocator disk : spec.disk) {
                this.fillLocationInfo(vm, disk.diskId, disk.datastore, parents, podInfo, result);
            }
        }
        return result;
    }

    private void copyDiskNames(DiskLocationInfo source, DiskLocationInfo destination) {
        String diskName;
        for (int diskId : destination.datastoreByDiskId.keySet()) {
            diskName = source.diskNameByDiskId.get(diskId);
            if (diskName == null) continue;
            destination.diskNameByDiskId.put(diskId, diskName);
        }
        for (int diskId : destination.storagePodByDiskId.keySet()) {
            diskName = source.diskNameByDiskId.get(diskId);
            if (diskName == null) continue;
            destination.diskNameByDiskId.put(diskId, diskName);
        }
    }

    private ManagedObjectReference[] collectStoragePods(RelocateSpec spec, QueryUtil.PropertyValueMap parents) {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.datastore, StoragePod.class)) {
            result.add(spec.datastore);
        }
        if (spec.disk != null) {
            for (RelocateSpec.DiskLocator disk : spec.disk) {
                if (!ManagedObjectUtil.isOfType((ManagedObjectReference)disk.datastore, StoragePod.class) || result.contains(disk.datastore)) continue;
                result.add(disk.datastore);
            }
        }
        for (PropertyValue propertyValue : parents.data.values()) {
            ManagedObjectReference storage;
            if (propertyValue.value == null || !ManagedObjectUtil.isOfType((ManagedObjectReference)(storage = (ManagedObjectReference)propertyValue.value), StoragePod.class) || result.contains(storage)) continue;
            result.add(storage);
        }
        return result.toArray(new ManagedObjectReference[0]);
    }

    private ManagedObjectReference[] collectDatastores(RelocateSpec spec) {
        ArrayList<ManagedObjectReference> storages = new ArrayList<ManagedObjectReference>();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.datastore, Datastore.class)) {
            storages.add(spec.datastore);
        }
        if (spec.disk != null) {
            for (RelocateSpec.DiskLocator disk : spec.disk) {
                if (!ManagedObjectUtil.isOfType((ManagedObjectReference)disk.datastore, Datastore.class) || storages.contains(disk.datastore)) continue;
                storages.add(disk.datastore);
            }
        }
        return storages.toArray(new ManagedObjectReference[0]);
    }

    private void fillLocationInfo(ManagedObjectReference vm, int diskId, ManagedObjectReference storage, QueryUtil.PropertyValueMap storageParents, QueryUtil.PropertyValueMap podInfo, DiskLocationInfo result) {
        if (storage == null) {
            return;
        }
        Boolean isStoragePod = ManagedObjectUtil.isOfType((ManagedObjectReference)storage, StoragePod.class);
        if (isStoragePod.booleanValue()) {
            result.storagePodByDiskId.put(diskId, storage);
        } else {
            ManagedObjectReference parent;
            result.datastoreByDiskId.put(diskId, storage);
            PropertyValue property = storageParents.getProperty((Object)storage, "parent");
            if (property != null && ManagedObjectUtil.isOfType((ManagedObjectReference)(parent = (ManagedObjectReference)property.value), StoragePod.class)) {
                result.storagePodByDiskId.put(diskId, parent);
            }
        }
        Boolean storagePodConfigEnabled = false;
        ManagedObjectReference storagePod = result.storagePodByDiskId.get(diskId);
        PropertyValue property = podInfo.getProperty((Object)storagePod, this.POD_CONFIG_ENABLED);
        if (property != null && property.value != null) {
            storagePodConfigEnabled = (Boolean)property.value;
        }
        result.drsEnabledByDiskId.put(diskId, storagePodConfigEnabled);
        if (storagePodConfigEnabled.booleanValue() && (property = podInfo.getProperty((Object)storagePod, this.POD_VM_CONFIG)) != null && property.value != null) {
            VmConfigInfo[] configInfos;
            for (VmConfigInfo vmInfo : configInfos = (VmConfigInfo[])property.value) {
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)vmInfo.vm, (ManagedObjectReference)vm).booleanValue()) continue;
                boolean enabled = vmInfo.enabled == null || vmInfo.enabled != false;
                result.drsEnabledByDiskId.put(diskId, enabled);
            }
        }
    }

    private void stripUnchangedStorage(RelocateSpec spec, DiskLocationInfo currentLocation) {
        if (!StorageValidationUtil.isDiskLocationChanged(VMX_DISK_ID, spec.datastore, currentLocation).booleanValue()) {
            spec.datastore = null;
        }
        if (spec.disk == null) {
            return;
        }
        ArrayList<RelocateSpec.DiskLocator> newDisks = new ArrayList<RelocateSpec.DiskLocator>();
        for (RelocateSpec.DiskLocator disk : spec.disk) {
            if (!StorageValidationUtil.isDiskLocationChanged(disk.diskId, disk.datastore, currentLocation).booleanValue()) continue;
            newDisks.add(disk);
        }
        if (newDisks.isEmpty()) {
            spec.disk = null;
            return;
        }
        if (newDisks.size() != spec.disk.length) {
            spec.disk = newDisks.toArray(new RelocateSpec.DiskLocator[0]);
            return;
        }
    }

    private void padSpec(RelocateSpec spec, DiskLocationInfo currentDiskLocation) {
        if (spec.disk != null && spec.disk.length > 0) {
            return;
        }
        if (spec.datastore == null) {
            return;
        }
        ArrayList<RelocateSpec.DiskLocator> disks = new ArrayList<RelocateSpec.DiskLocator>();
        for (int diskId : currentDiskLocation.diskNameByDiskId.keySet()) {
            if (diskId == VMX_DISK_ID || currentDiskLocation.pmemDiskNameByDiskId.containsKey(diskId) || this.isDiskUpgradedToPmem(spec, diskId)) continue;
            RelocateSpec.DiskLocator disk = new RelocateSpec.DiskLocator();
            disk.diskId = diskId;
            disk.datastore = spec.datastore;
            disks.add(disk);
        }
        spec.disk = (RelocateSpec.DiskLocator[])ArrayUtil.toArrayOrNull(disks, RelocateSpec.DiskLocator.class);
    }

    private boolean isDiskUpgradedToPmem(RelocateSpec spec, int diskId) {
        for (VirtualDeviceSpec deviceChange : spec.deviceChange) {
            if (deviceChange == null || !(deviceChange.device instanceof VirtualDisk) || !(deviceChange.device.backing instanceof VirtualDevice.FileBackingInfo) || !Util.isPMemBacking((VirtualDevice.FileBackingInfo)deviceChange.device.backing) || deviceChange.device.key != diskId) continue;
            return true;
        }
        return false;
    }

    private RelocateSpec cloneStorage(RelocateSpec spec) {
        RelocateSpec result = new RelocateSpec();
        result.datastore = spec.datastore;
        ArrayList<RelocateSpec.DiskLocator> copy = new ArrayList<RelocateSpec.DiskLocator>();
        if (spec.disk != null) {
            for (RelocateSpec.DiskLocator diskLocator : spec.disk) {
                copy.add(diskLocator);
            }
            result.disk = (RelocateSpec.DiskLocator[])ArrayUtil.toArrayOrNull(copy, RelocateSpec.DiskLocator.class);
        }
        return result;
    }

    private static void localizeTaskResults(Result[] checkResults) {
        for (Result r : (Result[])ArrayUtil.toSafe((Object[])checkResults, Result.class)) {
            for (Exception e : (Exception[])ArrayUtil.toSafe((Object[])r.warning, Exception.class)) {
                LocalizableErrorFormatter.localizeFault(e);
            }
            for (Exception e : (Exception[])ArrayUtil.toSafe((Object[])r.error, Exception.class)) {
                LocalizableErrorFormatter.localizeFault(e);
            }
        }
    }
}

