/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.vm.api.migration.VmLocationSpecValidatorConfiguration;
import com.vmware.vsphere.client.vm.migration.LocationSpec;
import com.vmware.vsphere.client.vm.migration.LocationSpecPair;
import com.vmware.vsphere.client.vm.migration.VmMigrationOptions;
import com.vmware.vsphere.client.vm.migration.VmMigrationService;
import com.vmware.vsphere.client.vm.migration.impl.VmLocationSpecValidator;
import com.vmware.vsphere.client.vm.migration.impl.VmMigrationOptionsRetriever;
import com.vmware.vsphere.client.vm.migration.impl.VmRelocator;
import com.vmware.vsphere.client.vm.util.Util;

public class VmMigrationServiceImpl
implements VmMigrationService,
MutationProvider {
    private final DataService _dataService;
    private final TaskMonitor _taskMonitor;
    private final ServiceLocatorFactory _serviceLocatorFactory;
    private final QueryExecutor _queryExecutor;
    private VmLocationSpecValidatorConfiguration _validatorConfiguration;

    public VmMigrationServiceImpl(DataService dataService, TaskMonitor taskMonitor, ServiceLocatorFactory serviceLocatorFactory, QueryExecutor queryExecutor) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._serviceLocatorFactory = serviceLocatorFactory;
        this._queryExecutor = queryExecutor;
    }

    public void setValidatorConfiguration(VmLocationSpecValidatorConfiguration validatorConfiguration) {
        this._validatorConfiguration = validatorConfiguration;
    }

    @Override
    public VmMigrationOptions[] getVmMigrationOptions(ManagedObjectReference[] vms) throws Exception {
        VmMigrationOptionsRetriever optionsRetriever = new VmMigrationOptionsRetriever(this._queryExecutor, vms);
        return optionsRetriever.getVmMigrationOptions();
    }

    @Override
    public ValidationResult validate(ManagedObjectReference vm, LocationSpec locationSpec) throws Exception {
        LocationSpecPair locationSpecPair = new LocationSpecPair();
        locationSpecPair.entity = vm;
        locationSpecPair.spec = locationSpec;
        VmLocationSpecValidator validator = new VmLocationSpecValidator(this._dataService, this._taskMonitor, this._serviceLocatorFactory, new LocationSpecPair[]{locationSpecPair}, this._validatorConfiguration);
        Object[] validationResult = validator.execute();
        return ArrayUtil.isNullOrEmpty((Object[])validationResult) ? null : validationResult[0];
    }

    public ValidationResult[] validateMultiSpec(LocationSpecPair[] locationSpecs) throws Exception {
        if (locationSpecs == null || locationSpecs.length == 0) {
            return new ValidationResult[0];
        }
        VmLocationSpecValidator validator = new VmLocationSpecValidator(this._dataService, this._taskMonitor, this._serviceLocatorFactory, locationSpecs, this._validatorConfiguration);
        return validator.execute();
    }

    public OperationResult apply(ManagedObjectReference vm, LocationSpec locationSpec) {
        return VmRelocator.relocateVm(vm, locationSpec, this._dataService, this._serviceLocatorFactory);
    }

    public OperationResult applyDeferred(ManagedObjectReference vm, LocationSpec locationSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        OperationResult result = new OperationResult();
        ManagedObjectReference entity = scheduleSpec.scheduledTask != null ? this.applyDeferredExisting(vm, locationSpec, scheduleSpec) : this.applyDeferredNew(vm, locationSpec, scheduleSpec);
        result.entity = entity;
        return result;
    }

    private ManagedObjectReference applyDeferredExisting(ManagedObjectReference vm, LocationSpec locationSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createRelocateScheduledTaskSpec(vm, locationSpec, scheduleSpec);
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ManagedObjectReference applyDeferredNew(ManagedObjectReference vm, LocationSpec locationSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createRelocateScheduledTaskSpec(vm, locationSpec, scheduleSpec);
        return SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)vm, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ScheduledTaskSpec createRelocateScheduledTaskSpec(ManagedObjectReference vm, LocationSpec locationSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        LocationSpecPair locationSpecPair = new LocationSpecPair();
        locationSpecPair.entity = vm;
        locationSpecPair.spec = locationSpec;
        Util.populateSpecWithXvcInfo(locationSpecPair, true, this._dataService, this._serviceLocatorFactory);
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)"RelocateVM_Task", (Object[])new Object[]{locationSpec.relocateSpec, locationSpec.priority});
        vcTaskSpec.action = action;
        return vcTaskSpec;
    }
}

