/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.storageDrs.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;

public class StorageRecommendationsManager {
    private ManagedObjectReference _mor;
    private StorageResourceManager _storageResMgr;
    private boolean _cancelRecommendationSupported = false;

    public StorageRecommendationsManager(ManagedObjectReference managedObjectRef) {
        this._mor = managedObjectRef;
    }

    public void cancelDatastoreRecommendations(String[] recommendations, Boolean ignoreMissingKeys) throws Exception {
        block4: {
            if (ArrayUtil.isNullOrEmpty((Object[])recommendations)) {
                return;
            }
            try {
                StorageResourceManager storageManager = this.getStorageResourceManager();
                if (!this._cancelRecommendationSupported) {
                    return;
                }
                storageManager.cancelRecommendation(recommendations);
            }
            catch (InvalidArgument e) {
                if (ignoreMissingKeys.booleanValue()) break block4;
                throw e;
            }
        }
    }

    public ManagedObjectReference applyDatastoreRecommendations(String[] recommendations) throws Exception {
        StorageResourceManager storageManager = this.getStorageResourceManager();
        return storageManager.applyRecommendation(recommendations);
    }

    protected StorageResourceManager getStorageResourceManager() throws Exception {
        if (this._storageResMgr != null) {
            return this._storageResMgr;
        }
        String serverGuid = this._mor.getServerGuid();
        this._cancelRecommendationSupported = VcServiceUtil.isMNnextVcOrLater((String)serverGuid);
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        this._storageResMgr = (StorageResourceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.storageResourceManager);
        return this._storageResMgr;
    }
}

