/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.util;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.ExtendedFault;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.core.model.MutableMessageException;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionInvalidatedException;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vsphere.client.vm.util.ValidationResultFormatter;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

public class LocalizableErrorFormatter {
    private static Log _logger = LogFactory.getLog(LocalizableErrorFormatter.class);
    static final String PROPERTY_NAME_MESSAGE = "message";
    static final String PROPERTY_NAME_LOCALIZED_MESSAGE = "lmsg";

    public static String buildMessage(Throwable fault) {
        return LocalizableErrorFormatter.buildMessage(fault, new StringBuilder());
    }

    public static void localizeFault(Exception fault) {
        if (fault instanceof MethodFault) {
            ((MethodFault)fault).setMessage(LocalizableErrorFormatter.buildMessage(fault));
        }
        if (fault instanceof RuntimeFault) {
            ((RuntimeFault)fault).setMessage(LocalizableErrorFormatter.buildMessage(fault));
        }
    }

    private static String buildMessage(Throwable fault, StringBuilder builder) {
        String msg;
        if (fault == null) {
            return builder.toString();
        }
        String message = LocalizableErrorFormatter.getLocalizedFaultMessage(fault = (Throwable)LocalizableErrorFormatter.getErrorInstance(fault));
        if (!StringUtil.isNullOrEmpty((String)message)) {
            builder.append(message);
            builder.append("\n");
        }
        if (fault instanceof NoPermission) {
            builder.append(LocalizableErrorFormatter.getNoPermissionFaultMessage((NoPermission)fault));
            builder.append("\n");
        }
        LocalizableMessage[] faultMessage = null;
        Exception faultCause = null;
        if (fault instanceof MethodFault) {
            MethodFault methodFault = (MethodFault)fault;
            faultMessage = methodFault.getFaultMessage();
            faultCause = methodFault.getFaultCause();
        } else if (fault instanceof RuntimeFault) {
            RuntimeFault runtimeFault = (RuntimeFault)fault;
            faultMessage = runtimeFault.getFaultMessage();
            faultCause = runtimeFault.getFaultCause();
        }
        if (faultCause == fault) {
            faultCause = null;
        }
        if (faultMessage != null) {
            for (int i = faultMessage.length - 1; i >= 0; --i) {
                LocalizableMessage msg2 = faultMessage[i];
                String msgKey = msg2.getKey();
                String lmsg = LocalizationUtil.getLocalizedMessage((String)msgKey, (KeyAnyValue[])msg2.getArg());
                if (lmsg.equals(msgKey)) {
                    lmsg = msg2.getMessage();
                }
                String itemMsg = lmsg;
                if (StringUtil.isNullOrEmpty((String)lmsg)) {
                    itemMsg = !StringUtil.isNullOrEmpty((String)msg2.getMessage()) ? msg2.getMessage() : msg2.getKey();
                }
                if (StringUtil.isNullOrEmpty((String)itemMsg)) continue;
                itemMsg = itemMsg.trim();
                if (!StringUtil.isNullOrEmpty((String)message) && message.equals(itemMsg)) continue;
                builder.append(itemMsg);
                builder.append("\n");
            }
        }
        if (faultCause != null && !StringUtil.isNullOrEmpty((String)(msg = LocalizableErrorFormatter.buildMessage(faultCause)))) {
            builder.append("\n");
            builder.append(LocalizableErrorFormatter.text("ThrowableProxy.cause"));
            builder.append("\n");
            builder.append(msg);
            builder.append("\n");
        }
        return builder.toString().trim();
    }

    private static String getLocalizedFaultMessage(Throwable fault) {
        String message = null;
        String key = null;
        try {
            KeyAnyValue[] args = LocalizableErrorFormatter.constructKeyValuePairs(fault);
            if (fault instanceof ExtendedFault) {
                ExtendedFault extf = (ExtendedFault)fault;
                key = LocalizableErrorFormatter.getMessageKey(extf.getFaultTypeId());
                message = LocalizableErrorFormatter.fillInExtendFaultData(LocalizationUtil.getLocalizedMessage((String)key, (KeyAnyValue[])args), extf.getData());
                if (message != null && message.equals(key)) {
                    message = null;
                }
            } else {
                key = LocalizableErrorFormatter.getMessageKey(fault.getClass().getSimpleName());
                message = LocalizationUtil.getLocalizedMessage((String)key, (KeyAnyValue[])args);
                if (message == null || message.equals(key)) {
                    message = LocalizableErrorFormatter.isServiceNotAvailable(fault) ? LocalizableErrorFormatter.text("ThrowableProxy.unexpectedStatusCode503") : null;
                }
            }
        }
        catch (NotAuthenticatedError notAuthenticatedError) {
            // empty catch block
        }
        if (StringUtil.isNullOrEmpty(message)) {
            message = fault.getMessage();
        }
        if (message != null) {
            message = message.trim();
        }
        return message;
    }

    private static String getMessageKey(String errorId) {
        return String.format("%s.summary", errorId);
    }

    private static boolean isServiceNotAvailable(Throwable fault) {
        if (fault instanceof UnexpectedStatusCodeException) {
            UnexpectedStatusCodeException unexpectedException = (UnexpectedStatusCodeException)fault;
            return unexpectedException.getStatusCode() == 503;
        }
        return false;
    }

    private static KeyAnyValue[] constructKeyValuePairs(Throwable fault) {
        List<KeyAnyValue> args = LocalizableErrorFormatter.constructKeyValuePairsInternal(fault);
        if (args == null) {
            return null;
        }
        KeyAnyValue[] result = new KeyAnyValue[args.size()];
        int index = 0;
        for (KeyAnyValue kv : args) {
            if (kv != null && kv.getValue() instanceof MethodFault) {
                MethodFault mf = (MethodFault)kv.getValue();
                kv.setValue((Object)LocalizableErrorFormatter.buildMessage((Throwable)mf));
            }
            result[index] = kv;
            ++index;
        }
        return result;
    }

    private static String fillInExtendFaultData(String msg, KeyValue[] pairs) {
        int end;
        String result = msg;
        int start = result.indexOf("[data.");
        if (start == -1 || pairs == null || pairs.length == 0) {
            return result;
        }
        while ((end = result.indexOf("]", start + 6)) != -1) {
            String lookup = result.substring(start + 6, end);
            String val = null;
            for (KeyValue kv : pairs) {
                if (!lookup.equals(kv.getKey())) continue;
                val = LocalizableErrorFormatter.escapeOpenBrace(kv.getValue());
                break;
            }
            if (val == null) {
                _logger.warn((Object)("FormatExtensionFaultData: Unable to substitute " + lookup));
                val = String.format("<%s>", LocalizableErrorFormatter.text("ThrowableProxy.propertyUnset"));
            }
            result = result.substring(0, start) + val + result.substring(end + 1);
            start += val.length() + 1;
            if ((start = result.indexOf("[data.", start + 1)) != -1) continue;
        }
        return result;
    }

    private static String escapeOpenBrace(String str) {
        int start = str.indexOf(123);
        if (start == -1) {
            return str;
        }
        String result = "";
        int lastStart = 0;
        do {
            result = result + str.substring(lastStart, start + 1) + "{";
        } while ((start = str.indexOf(123, lastStart = start + 1)) != -1);
        result = result + str.substring(lastStart);
        return result;
    }

    private static List<KeyAnyValue> constructKeyValuePairsInternal(Object instance) {
        PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(instance.getClass());
        if (descriptors == null || descriptors.length == 0) {
            return null;
        }
        ArrayList<KeyAnyValue> args = new ArrayList<KeyAnyValue>();
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getName().equals(PROPERTY_NAME_MESSAGE) || descriptor.getName().equals(PROPERTY_NAME_LOCALIZED_MESSAGE)) continue;
            try {
                Method method = descriptor.getReadMethod();
                if (method == null) continue;
                args.add(LocalizableErrorFormatter.newKeyValue(descriptor.getName(), method.invoke(instance, new Object[0])));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return args;
    }

    public static KeyAnyValue newKeyValue(String key, Object value) {
        KeyAnyValueImpl kv = new KeyAnyValueImpl();
        kv.setKey(key);
        kv.setValue(value);
        return kv;
    }

    private static String getNoPermissionFaultMessage(NoPermission npf) {
        String privilegeId = npf.getPrivilegeId();
        String text = LocalizableErrorFormatter.getPrivilegeText(privilegeId);
        String name = null;
        String type2 = "?";
        ManagedObjectReference moRef = npf.getObject();
        if (moRef != null) {
            name = QueryUtil.getReferenceUid((Object)moRef);
            String moRefType = moRef.getType();
            if (moRefType != null) {
                type2 = ManagedObjectUtil.getLocalizedEntityType((String)moRefType);
            } else {
                _logger.warn((Object)("A " + NoPermission.class.getSimpleName() + " fault's moRef contains a null type."));
            }
        } else {
            name = "?";
            _logger.warn((Object)("A " + NoPermission.class.getSimpleName() + " fault contains a null moRef."));
        }
        String key = "NoPermission.message.format";
        String format = LocalizableErrorFormatter.text("NoPermission.message.format");
        format = String.format(format, text, type2, name);
        return format;
    }

    private static String getPrivilegeText(String privilegeId) {
        if (StringUtil.isNullOrEmpty((String)privilegeId)) {
            return "?";
        }
        String[] parts = privilegeId.split("\\.");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            String part;
            String key;
            String localized;
            int pos = 0;
            for (int k = 0; k < i + 1; ++k) {
                if ((pos = privilegeId.indexOf(".", pos + 1)) != -1) continue;
                pos = privilegeId.length();
                break;
            }
            if ((localized = LocalizationUtil.getLocalizedMessage((String)(key = String.format("privilege.%s.label", part = privilegeId.substring(0, pos))), null)) != null && !localized.equals(key)) {
                if (buffer.length() > 0) {
                    buffer.append(" > ");
                }
                buffer.append(localized);
                continue;
            }
            _logger.warn((Object)("Unable to localize key '" + key + "'"));
        }
        return buffer.toString();
    }

    private static final String text(String key) {
        ClassLoader classLoader = ValidationResultFormatter.class.getClassLoader();
        return ResourceUtil.getString((String)"vmservice", (String)key, (ClassLoader)classLoader);
    }

    private static Object getErrorInstance(Object instance) {
        if (instance == null || !(instance instanceof Throwable)) {
            return instance;
        }
        if (Exception.class.getName().equals(instance.getClass().getName())) {
            Exception e = (Exception)instance;
            return new MutableMessageException(e.getMessage());
        }
        Object newInstance = instance;
        if (ExceptionUtil.isCausedBy((Throwable)((Throwable)instance), SessionDataContainerMissingException.class) || ExceptionUtil.isCausedBy((Throwable)((Throwable)instance), SessionInvalidatedException.class)) {
            newInstance = new NotAuthenticatedError();
        }
        if (MethodFault.class.equals(instance.getClass()) && !((newInstance = ((Throwable)instance).getCause()) instanceof MethodFault) && !(newInstance instanceof RuntimeFault)) {
            newInstance = instance;
        }
        return newInstance;
    }
}

