/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.util;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vim.vApp.PropertyInfo;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.data.QueryDataUtil;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.migration.LocationSpec;
import com.vmware.vsphere.client.vm.migration.LocationSpecPair;
import com.vmware.vsphere.client.vm.model.FtStorageFileItem;
import com.vmware.vsphere.client.vm.powerops.VmPowerStateSpec;
import com.vmware.vsphere.client.vm.storageDrs.VmStorageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;

public class Util {
    public static String VM_SERVICE_STRINGS = "vmservice";
    private static final String VALID_DESTINATION_HOSTS_PROPERTY = "validDestinationHosts";
    private static final String FT_SECONDARIES = "secondaries";
    private static final String FT_FILE_TYPE_DISK = "itemTypeDisk";
    private static final String FT_FILE_TYPE_CONFIG = "itemTypeConfiguration";
    private static final String FT_FILE_TYPE_TIEBREAKER = "itemTypeFtMetainfFile";
    private static final String DATASTORE_PARENT_PROPERTY = "parent";
    private static final String POD_CONFIG_ENABLED_PROPERTY = "podStorageDrsEntry.storageDrsConfig.podConfig.enabled";
    private static final String POD_VM_CONFIG_PROPERTY = "podStorageDrsEntry.storageDrsConfig.vmConfig";
    private static final ManagedObjectReference[] EMPTY_ENTITY_ARRAY = new ManagedObjectReference[0];

    public static boolean isPrimaryVmPoweredOnAndFTNotDisabled(RuntimeInfo runtimeInfo, int ftRole) {
        return runtimeInfo.powerState == VirtualMachine.PowerState.poweredOn && Util.isPrimaryVm(ftRole) && runtimeInfo.faultToleranceState != VirtualMachine.FaultToleranceState.disabled;
    }

    private static boolean isPrimaryVm(int ftRole) {
        return ftRole == 1;
    }

    public static boolean isSecondaryVm(int ftRole) {
        return ftRole > 1;
    }

    public static ManagedObjectReference getSecondaryVmRef(DataService dataService, ManagedObjectReference primaryVmRef) throws Exception {
        ManagedObjectReference secondaryVmRef = null;
        ManagedObjectReference[] secondaryVMs = (ManagedObjectReference[])QueryUtil.getProperty((DataService)dataService, (Object)primaryVmRef, (String)FT_SECONDARIES);
        if (secondaryVMs != null && secondaryVMs.length > 0) {
            secondaryVmRef = secondaryVMs[0];
        }
        return secondaryVmRef;
    }

    public static boolean isTemplate(DataService dataService, ManagedObjectReference vmRef) throws Exception {
        Boolean isTemplate = (Boolean)QueryUtil.getProperty((DataService)dataService, (Object)vmRef, (String)"config.template");
        return isTemplate != null ? isTemplate : false;
    }

    public static void validateLocationSpec(DataObject spec) throws IllegalArgumentException {
        String errorMsg = null;
        if (!(spec instanceof LocationSpec)) {
            errorMsg = Util.getLocalizedString("error.locationSpecRequired");
            throw new IllegalArgumentException(errorMsg);
        }
        LocationSpec locationSpec = (LocationSpec)spec;
        if (locationSpec.relocateSpec == null) {
            errorMsg = Util.getLocalizedString("error.relocateSpecNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static void validateCloneSpec(DataObject spec) throws IllegalArgumentException {
        String errorMsg = null;
        if (!(spec instanceof VmCloneSpec)) {
            errorMsg = Util.getLocalizedString("error.cloneSpecRequired");
            throw new IllegalArgumentException(errorMsg);
        }
        VmCloneSpec vmCloneSpec = (VmCloneSpec)spec;
        if (vmCloneSpec.cloneSpec == null) {
            errorMsg = Util.getLocalizedString("error.cloneSpecNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
        if (vmCloneSpec.cloneSpec.location == null) {
            errorMsg = Util.getLocalizedString("error.relocateSpecNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
        if (vmCloneSpec.folder == null) {
            errorMsg = Util.getLocalizedString("error.vmFolderNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
        if (vmCloneSpec.name == null || vmCloneSpec.name.isEmpty()) {
            errorMsg = Util.getLocalizedString("error.vmNameNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static void validatePowerStateSpec(VmPowerStateSpec spec) throws IllegalArgumentException {
        String errorMsg = null;
        if (spec == null) {
            errorMsg = Util.getLocalizedString("error.powerStateSpecNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
        if (spec.powerState == null) {
            errorMsg = Util.getLocalizedString("error.powerStateNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public static MethodFault getInvalidEntityFault() {
        return Util.getInvalidEntityFault("");
    }

    public static MethodFault getInvalidEntityFault(String entity) {
        String errorMsg = Util.getLocalizedString("error.invalidEntityArgumentFormatted");
        errorMsg = String.format(errorMsg, entity);
        IllegalArgumentException ex = new IllegalArgumentException(errorMsg);
        MethodFault fault = MixedUtil.getMethodFault((Throwable)ex);
        return fault;
    }

    public static Exception getVmNotFoundError(ManagedObjectReference entity) {
        ManagedObjectNotFound error = new ManagedObjectNotFound(entity);
        String errorMsg = Util.getLocalizedString("error.virtualMachineNotFound");
        error.setMessage(errorMsg);
        return error;
    }

    public static VmDc[] getDatacenterForVmList(ManagedObjectReference[] vms, DataService dataService) throws Exception {
        ArrayList<QuerySpec> specs = new ArrayList<QuerySpec>();
        ArrayList<ManagedObjectReference> specVM = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference vm : vms) {
            if (vm == null) continue;
            Constraint relConstraint = QueryUtil.createConstraintForRelationship((Object)vm, (String)"dc", (String)"Datacenter");
            QuerySpec querySpec = new QuerySpec();
            querySpec.resourceSpec = QueryUtil.createEmptyResourceSpec();
            querySpec.resourceSpec.constraint = relConstraint;
            specVM.add(vm);
            specs.add(querySpec);
        }
        if (specs.size() == 0) {
            return null;
        }
        QuerySpec[] querySpecs = specs.toArray(new QuerySpec[0]);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs;
        Response response = dataService.getData(requestSpec);
        VmDc[] vmDcList = new VmDc[response.resultSet.length];
        for (int i = 0; i < response.resultSet.length; ++i) {
            Object[] dcRefs;
            ResultSet result = response.resultSet[i];
            ManagedObjectReference vm = (ManagedObjectReference)specVM.get(i);
            Datacenter dc = null;
            if (result != null && (dcRefs = QueryUtil.findMoRefsIn((ResultSet)result)) != null && dcRefs.length > 0) {
                dc = (Datacenter)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)dcRefs[0]));
            }
            vmDcList[i] = new VmDc(vm, dc);
        }
        return vmDcList;
    }

    public static Map<String, ArrayList<ManagedObjectReference>> getVmsByService(ManagedObjectReference[] entities) {
        if (entities == null) {
            return null;
        }
        HashMap<String, ArrayList<ManagedObjectReference>> vmsByService = new HashMap<String, ArrayList<ManagedObjectReference>>(entities.length);
        for (ManagedObjectReference entity : entities) {
            String serverGuid = entity.getServerGuid();
            if (serverGuid == null) continue;
            ArrayList<ManagedObjectReference> vmGroup = (ArrayList<ManagedObjectReference>)vmsByService.get(serverGuid);
            if (vmGroup == null) {
                vmGroup = new ArrayList<ManagedObjectReference>();
                vmsByService.put(serverGuid, vmGroup);
            }
            vmGroup.add(entity);
        }
        return vmsByService;
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)VM_SERVICE_STRINGS, (String)key, (ClassLoader)Util.class.getClassLoader());
    }

    public static String getLocalizedString(String key, String ... parameters) {
        return ResourceUtil.getString((String)VM_SERVICE_STRINGS, (String)key, (String[])parameters, (ClassLoader)Util.class.getClassLoader());
    }

    public static Map<String, VirtualMachine.PowerState> getVmPowerStates(ManagedObjectReference[] vms, DataService dataService) throws Exception {
        if (dataService == null) {
            String errorMsg = Util.getLocalizedString("error.dataServiceNotProvided");
            throw new IllegalArgumentException(errorMsg);
        }
        if (vms == null || vms.length < 1) {
            return null;
        }
        HashMap<String, VirtualMachine.PowerState> powerStateByMorefMap = new HashMap<String, VirtualMachine.PowerState>();
        Map listResultItemsByMorefMap = QueryDataUtil.getProperties((DataService)dataService, (Object[])vms, (String[])new String[]{"runtime.powerState"});
        if (listResultItemsByMorefMap != null) {
            for (String key : listResultItemsByMorefMap.keySet()) {
                List results = (List)listResultItemsByMorefMap.get(key);
                VirtualMachine.PowerState powerState = (VirtualMachine.PowerState)QueryUtil.findPropertyValueIn((String)"runtime.powerState", (List)results);
                powerStateByMorefMap.put(key, powerState);
            }
        }
        return powerStateByMorefMap;
    }

    public static VmStorageInfo getVmStorageInfo(DataService dataService, ManagedObjectReference vmRef, ManagedObjectReference vmDatastore) throws Exception {
        VmStorageInfo storageInfo = new VmStorageInfo();
        storageInfo.datastore = vmDatastore;
        if (vmDatastore == null) {
            return storageInfo;
        }
        Object[] spodPropertyValues = QueryUtil.getPropertiesForRelatedObjects((DataService)dataService, (Object)vmDatastore, (String)DATASTORE_PARENT_PROPERTY, (String)StoragePod.class.getSimpleName(), (String[])new String[]{POD_CONFIG_ENABLED_PROPERTY, POD_VM_CONFIG_PROPERTY});
        if (ArrayUtil.isNullOrEmpty((Object[])spodPropertyValues)) {
            return storageInfo;
        }
        for (Object propValue : spodPropertyValues) {
            VmConfigInfo[] vmConfigInfos;
            VmConfigInfo vmInfo;
            if (POD_CONFIG_ENABLED_PROPERTY.equals(((PropertyValue)propValue).propertyName)) {
                storageInfo.isSdrsEnabledForDsCluster = (Boolean)((PropertyValue)propValue).value;
                storageInfo.datastoreCluster = (ManagedObjectReference)((PropertyValue)propValue).resourceObject;
                continue;
            }
            if (!POD_VM_CONFIG_PROPERTY.equals(((PropertyValue)propValue).propertyName) || (vmInfo = Util.getVmConfigInfoByVm(vmConfigInfos = (VmConfigInfo[])((PropertyValue)propValue).value, vmRef)) == null) continue;
            storageInfo.isSdrsEnabledForVm = vmInfo.enabled;
        }
        return storageInfo;
    }

    private static VmConfigInfo getVmConfigInfoByVm(VmConfigInfo[] vmConfigInfos, ManagedObjectReference vmRef) {
        if (ArrayUtil.isNullOrEmpty((Object[])vmConfigInfos)) {
            return null;
        }
        for (VmConfigInfo vmInfo : vmConfigInfos) {
            if (!ManagedObjectUtil.areEqual((ManagedObjectReference)vmInfo.vm, (ManagedObjectReference)vmRef).booleanValue()) continue;
            return vmInfo;
        }
        return null;
    }

    public static String[] formatAsHexStringArray(long[] source) {
        String[] formatted = new String[]{};
        if (source != null && source.length > 0) {
            int elementCount = source.length;
            formatted = new String[elementCount];
            for (int i = 0; i < elementCount; ++i) {
                formatted[i] = Long.toString(source[i], 16);
            }
        }
        return formatted;
    }

    public static boolean populateSpecWithXvcInfo(VmCloneSpec vmCloneSpec, boolean autoSelectHost, DataService dataService, ServiceLocatorFactory serviceLocatorFactory) throws IllegalStateException {
        if (!Util.populateVcServiceIfNeeded(vmCloneSpec, serviceLocatorFactory)) {
            return false;
        }
        if (vmCloneSpec.podSelectionSpec != null) {
            vmCloneSpec.podSelectionSpec = null;
        }
        RelocateSpec spec = vmCloneSpec.cloneSpec.location;
        if (spec.folder == null) {
            spec.folder = vmCloneSpec.folder;
        }
        if (spec.host == null && autoSelectHost) {
            Object[] validHosts = Util.getValidDestinationHosts(spec.pool, (Object)vmCloneSpec, dataService);
            if (ArrayUtil.isNullOrEmpty((Object[])validHosts)) {
                throw new IllegalStateException(Util.getLocalizedString("error.noValidHostToAutoselect"));
            }
            spec.host = validHosts[0];
        }
        return true;
    }

    public static boolean populateSpecWithXvcInfo(LocationSpecPair locationSpecPair, boolean autoSelectHost, DataService dataService, ServiceLocatorFactory serviceLocatorFactory) throws IllegalStateException {
        if (!Util.populateVcServiceIfNeeded(locationSpecPair, serviceLocatorFactory)) {
            return false;
        }
        RelocateSpec spec = locationSpecPair.spec.relocateSpec;
        if (spec.host == null && autoSelectHost) {
            Object[] validHosts = Util.getValidDestinationHosts(spec.pool, locationSpecPair, dataService);
            if (ArrayUtil.isNullOrEmpty((Object[])validHosts)) {
                throw new IllegalStateException(Util.getLocalizedString("error.noValidHostToAutoselect"));
            }
            spec.host = validHosts[0];
        }
        return true;
    }

    public static boolean populateVcServiceIfNeeded(LocationSpecPair locationSpecPair, ServiceLocatorFactory serviceLocatorFactory) {
        if (locationSpecPair == null || locationSpecPair.entity == null || locationSpecPair.spec == null || locationSpecPair.spec.relocateSpec == null) {
            return false;
        }
        RelocateSpec spec = locationSpecPair.spec.relocateSpec;
        ManagedObjectReference vm = locationSpecPair.entity;
        String serverGuid = Util.getDestinationServerGuid(spec);
        if (vm.getServerGuid().equals(serverGuid)) {
            return false;
        }
        if (spec.service == null) {
            spec.service = serviceLocatorFactory.newServiceLocator(serverGuid, AuthSessionUtil.getSsoToken(), vm.getServerGuid());
        }
        return true;
    }

    public static boolean populateVcServiceIfNeeded(VmCloneSpec vmCloneSpec, ServiceLocatorFactory serviceLocatorFactory) {
        if (vmCloneSpec == null || vmCloneSpec.vm == null || vmCloneSpec.cloneSpec == null || vmCloneSpec.cloneSpec.location == null) {
            return false;
        }
        RelocateSpec spec = vmCloneSpec.cloneSpec.location;
        ManagedObjectReference vm = vmCloneSpec.vm;
        String serverGuid = Util.getDestinationServerGuid(spec);
        if (vm.getServerGuid().equals(serverGuid)) {
            return false;
        }
        if (spec.service == null) {
            spec.service = serviceLocatorFactory.newServiceLocator(serverGuid, AuthSessionUtil.getSsoToken(), vm.getServerGuid());
        }
        return true;
    }

    public static final ManagedObjectReference[] getValidDestinationHosts(ManagedObjectReference resourceRef, Object spec, DataService dataService) {
        QuerySpec query = Util.createValidHostsQuerySpec(resourceRef, spec);
        ResultSet result = null;
        try {
            result = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
        }
        catch (Exception e) {
            return EMPTY_ENTITY_ARRAY;
        }
        if (result == null || ArrayUtil.isNullOrEmpty((Object[])result.items) || ArrayUtil.isNullOrEmpty((Object[])result.items[0].properties)) {
            return EMPTY_ENTITY_ARRAY;
        }
        ManagedObjectReference[] hosts = (ManagedObjectReference[])result.items[0].properties[0].value;
        return hosts;
    }

    private static QuerySpec createValidHostsQuerySpec(ManagedObjectReference resourceRef, Object spec) {
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.parameter = spec;
        paramSpec.propertyName = VALID_DESTINATION_HOSTS_PROPERTY;
        PropertySpec propSpec = new PropertySpec();
        propSpec.type = QueryUtil.getReferenceType((Object)resourceRef);
        propSpec.propertyNames = new String[]{VALID_DESTINATION_HOSTS_PROPERTY};
        propSpec.parameters = new ParameterSpec[]{paramSpec};
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = QueryUtil.createObjectIdentityConstraint((Object)resourceRef);
        resourceSpec.propertySpecs = new PropertySpec[]{propSpec};
        QuerySpec query = new QuerySpec();
        query.resourceSpec = resourceSpec;
        return query;
    }

    private static String getDestinationServerGuid(RelocateSpec spec) {
        ManagedObjectReference target = null;
        if (spec.pool != null) {
            target = spec.pool;
        }
        if (target == null && spec.host != null) {
            target = spec.host;
        }
        if (target == null && spec.datastore != null) {
            target = spec.datastore;
        }
        if (target == null) {
            return "";
        }
        String serverGuid = target.getServerGuid();
        return serverGuid;
    }

    public static final boolean keepCurrentVmPoolIfPossible(LocationSpecPair locationSpecPair, DataService dataService) {
        if (locationSpecPair == null || locationSpecPair.entity == null || locationSpecPair.spec == null || locationSpecPair.spec.relocateSpec == null) {
            return false;
        }
        RelocateSpec spec = locationSpecPair.spec.relocateSpec;
        ManagedObjectReference vm = locationSpecPair.entity;
        if (spec.pool == null || spec.host == null) {
            return false;
        }
        boolean shouldNullDestinationPool = false;
        try {
            VmDestPoolData data2 = Util.getVmDestPoolData(dataService, vm, spec.pool);
            shouldNullDestinationPool = Util.shouldPreserveCurrentVmPool(data2);
        }
        catch (Exception e) {
            return false;
        }
        if (shouldNullDestinationPool) {
            spec.pool = null;
        }
        return shouldNullDestinationPool;
    }

    private static boolean shouldPreserveCurrentVmPool(VmDestPoolData data2) throws Exception {
        if (data2 == null || data2.destPoolParent == null || data2.destPoolOwnerResource == null || data2.destResourceHosts == null || data2.vmPoolOwnerResource == null) {
            throw new Exception("Unable to retrieve data for determining VM relocation resource pool.");
        }
        if (!ManagedObjectUtil.areEqual((ManagedObjectReference)data2.vmPoolOwnerResource, (ManagedObjectReference)data2.destPoolOwnerResource).booleanValue()) {
            return false;
        }
        if (!ManagedObjectUtil.areEqual((ManagedObjectReference)data2.destPoolParent, (ManagedObjectReference)data2.destPoolOwnerResource).booleanValue()) {
            return false;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)data2.destPoolOwnerResource, ComputeResource.class)) {
            return false;
        }
        return data2.destResourceHosts.length > 1;
    }

    private static VmDestPoolData getVmDestPoolData(DataService dataService, ManagedObjectReference vm, ManagedObjectReference pool) throws Exception {
        ObjectIdentityConstraint destPoolConstraint = QueryUtil.createObjectIdentityConstraint((Object)pool);
        Constraint destPoolOwnerConstraint = QueryUtil.createConstraintForRelationship((Object)pool, (String)"owner", (String)ComputeResource.class.getSimpleName());
        ObjectIdentityConstraint vmConstraint = QueryUtil.createObjectIdentityConstraint((Object)vm);
        Constraint vmPoolConstraint = QueryUtil.createConstraintForRelationship((Object)vm, (String)"resourcePool", (String)ResourcePool.class.getSimpleName());
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{destPoolConstraint, destPoolOwnerConstraint, vmConstraint, vmPoolConstraint}, (Conjoiner)Conjoiner.OR);
        PropertySpec computePSpec = new PropertySpec();
        computePSpec.propertyNames = new String[]{"host"};
        computePSpec.type = ComputeResource.class.getSimpleName();
        PropertySpec rpPSpec = new PropertySpec();
        rpPSpec.propertyNames = new String[]{DATASTORE_PARENT_PROPERTY, "owner"};
        rpPSpec.type = ResourcePool.class.getSimpleName();
        PropertySpec vmPSpec = new PropertySpec();
        vmPSpec.propertyNames = new String[]{"resourcePool"};
        vmPSpec.type = VirtualMachine.class.getSimpleName();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{computePSpec, rpPSpec, vmPSpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        querySpec.name = "check-if-vm-pool-preservable-during-migration";
        ResultSet queryResult = QueryUtil.getData((DataService)dataService, (QuerySpec)querySpec);
        ManagedObjectReference destPoolParent = null;
        ManagedObjectReference destPoolOwnerResource = null;
        ManagedObjectReference[] destResourceHosts = null;
        ManagedObjectReference vmPoolOwnerResource = null;
        Map<Object, Map<String, Object>> objectProperties = Util.toPropertyMap(queryResult);
        destPoolParent = (ManagedObjectReference)Util.getObjectProperty(pool, DATASTORE_PARENT_PROPERTY, objectProperties);
        destPoolOwnerResource = (ManagedObjectReference)Util.getObjectProperty(pool, "owner", objectProperties);
        destResourceHosts = (ManagedObjectReference[])Util.getObjectProperty(destPoolOwnerResource, "host", objectProperties);
        ManagedObjectReference vmRp = (ManagedObjectReference)Util.getObjectProperty(vm, "resourcePool", objectProperties);
        vmPoolOwnerResource = (ManagedObjectReference)Util.getObjectProperty(vmRp, "owner", objectProperties);
        return new VmDestPoolData(destPoolParent, destPoolOwnerResource, destResourceHosts, vmPoolOwnerResource);
    }

    private static Map<Object, Map<String, Object>> toPropertyMap(ResultSet dsResult) {
        if (ArrayUtil.isNullOrEmpty((Object[])dsResult.items)) {
            return Collections.emptyMap();
        }
        HashMap<Object, Map<String, Object>> propertyMap = new HashMap<Object, Map<String, Object>>();
        for (ResultItem resultItem : dsResult.items) {
            HashMap<String, Object> objectProperties = new HashMap<String, Object>();
            propertyMap.put(resultItem.resourceObject, objectProperties);
            for (PropertyValue pValue : resultItem.properties) {
                objectProperties.put(pValue.propertyName, pValue.value);
            }
        }
        return propertyMap;
    }

    private static <T> T getObjectProperty(Object resource, String propName, Map<Object, Map<String, Object>> objectProperties) {
        Validate.notNull((Object)propName);
        Validate.notNull(objectProperties);
        Object result = null;
        if (resource != null && objectProperties.containsKey(resource)) {
            Object value;
            Map<String, Object> properties = objectProperties.get(resource);
            result = value = properties.get(propName);
        }
        return (T)result;
    }

    public static ConfigOption getVmConfigOption(ManagedObjectReference vmRef) throws Exception {
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        ManagedObjectReference browserRef = vm.getEnvironmentBrowser();
        if (browserRef == null) {
            return null;
        }
        EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
        if (browser == null) {
            return null;
        }
        String vcGuid = vmRef.getServerGuid();
        ConfigOption configOption = !StringUtil.isNullOrEmpty((String)vcGuid) && VcServiceUtil.is2014VcOrLater((String)vcGuid) ? browser.queryConfigOptionEx(null) : browser.queryConfigOption(null, null);
        return configOption;
    }

    public static void sortOVFProperties(com.vmware.vim.binding.vim.vApp.VmConfigInfo configProperties) {
        if (configProperties == null || configProperties.property == null) {
            return;
        }
        PropertyInfo[] ovfProperties = configProperties.property;
        TreeMap<String, 1> sortedMapOfCategories = new TreeMap<String, 1>();
        for (final PropertyInfo property : ovfProperties) {
            String propertyCategory = property.getCategory();
            final String propertyLabel = property.getLabel();
            if (!sortedMapOfCategories.containsKey(propertyCategory)) {
                sortedMapOfCategories.put(propertyCategory, new TreeMap<String, PropertyInfo>(){
                    {
                        this.put(propertyLabel, property);
                    }
                });
                continue;
            }
            if (((Map)sortedMapOfCategories.get(propertyCategory)).containsKey(propertyLabel)) continue;
            ((Map)sortedMapOfCategories.get(propertyCategory)).put(propertyLabel, property);
        }
        ArrayList<PropertyInfo> sortedListOfOVFProperties = new ArrayList<PropertyInfo>();
        for (Map properies : sortedMapOfCategories.values()) {
            for (PropertyInfo property : properies.values()) {
                sortedListOfOVFProperties.add(property);
            }
        }
        configProperties.property = sortedListOfOVFProperties.toArray(new PropertyInfo[sortedListOfOVFProperties.size()]);
    }

    public static boolean isPMemBacking(VirtualDevice.FileBackingInfo backing) {
        if (backing == null) {
            return false;
        }
        if (VirtualDisk.LocalPMemBackingInfo.class.isInstance(backing)) {
            return true;
        }
        return backing != null && backing.fileName.startsWith("[PMem");
    }

    public static FtStorageFileItem[] getFtVmDisks(VirtualDisk[] virtualDisks, String vmName) {
        ArrayList<FtStorageFileItem> ftStorageFileItems = new ArrayList<FtStorageFileItem>();
        Util.processVmxFile(ftStorageFileItems, vmName);
        Util.processFtMetainfFile(ftStorageFileItems, vmName);
        if (virtualDisks != null) {
            for (VirtualDisk virtualDisk : virtualDisks) {
                FtStorageFileItem ftStorageFileItem = new FtStorageFileItem();
                ftStorageFileItem.vmName = vmName;
                String capacity = FormatUtil.getStorageFormatted((Long)virtualDisk.capacityInKB, (long)1024L, (long)-1L);
                ftStorageFileItem.fileName = virtualDisk.getDeviceInfo() != null ? virtualDisk.getDeviceInfo().getLabel() + " (" + capacity + ")" : capacity;
                ftStorageFileItem.key = virtualDisk.getKey();
                ftStorageFileItem.itemType = FT_FILE_TYPE_DISK;
                ftStorageFileItem.id = FT_FILE_TYPE_DISK + virtualDisk.getKey();
                ftStorageFileItems.add(ftStorageFileItem);
            }
        }
        return ftStorageFileItems.toArray(new FtStorageFileItem[0]);
    }

    private static void processFtMetainfFile(List<FtStorageFileItem> ftStorageFileItems, String vmName) {
        FtStorageFileItem ftStorageFileItem = new FtStorageFileItem();
        ftStorageFileItem.itemType = FT_FILE_TYPE_TIEBREAKER;
        ftStorageFileItem.vmName = vmName;
        ftStorageFileItem.id = FT_FILE_TYPE_TIEBREAKER;
        ftStorageFileItems.add(ftStorageFileItem);
    }

    private static void processVmxFile(List<FtStorageFileItem> ftStorageFileItems, String vmName) {
        FtStorageFileItem ftStorageFileItem = new FtStorageFileItem();
        ftStorageFileItem.itemType = FT_FILE_TYPE_CONFIG;
        ftStorageFileItem.vmName = vmName;
        ftStorageFileItem.id = FT_FILE_TYPE_CONFIG;
        ftStorageFileItems.add(ftStorageFileItem);
    }

    private static final class VmDestPoolData {
        private final ManagedObjectReference destPoolParent;
        private final ManagedObjectReference destPoolOwnerResource;
        private final ManagedObjectReference[] destResourceHosts;
        private final ManagedObjectReference vmPoolOwnerResource;

        public VmDestPoolData(ManagedObjectReference destPoolParent, ManagedObjectReference destPoolOwnerResource, ManagedObjectReference[] destResourceHosts, ManagedObjectReference vmPoolOwnerResource) {
            this.destPoolParent = destPoolParent;
            this.destPoolOwnerResource = destPoolOwnerResource;
            this.destResourceHosts = destResourceHosts;
            this.vmPoolOwnerResource = vmPoolOwnerResource;
        }
    }

    public static class VmDc {
        public final ManagedObjectReference vm;
        public final Datacenter dc;

        public VmDc(ManagedObjectReference vm, Datacenter dc) {
            this.vm = vm;
            this.dc = dc;
        }
    }
}

