/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.Action;
import com.vmware.vim.binding.vim.cluster.ActionHistory;
import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vim.cluster.HostInfraUpdateHaModeAction;
import com.vmware.vim.binding.vim.cluster.HostPowerAction;
import com.vmware.vim.binding.vim.cluster.InitialPlacementAction;
import com.vmware.vim.binding.vim.cluster.MigrationAction;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.DrsRecommendationListItemData;
import com.vmware.vsphere.client.clusterui.model.monitor.FaultVmTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.history.DrsActionHistoryListItem;
import com.vmware.vsphere.client.clusterui.util.DrsActionHistoryUtil;
import com.vmware.vsphere.client.clusterui.util.DrsFaultsUtil;
import com.vmware.vsphere.client.clusterui.util.Util;
import com.vmware.vsphere.client.drs.RecommendationsService;
import com.vmware.vsphere.client.drs.model.DrsFaultListItem;
import com.vmware.vsphere.client.drs.model.HostMonitorTargetData;
import com.vmware.vsphere.client.drs.model.HostNameData;
import com.vmware.vsphere.client.drs.model.IdentifiableModel;
import com.vmware.vsphere.client.drs.model.MonitorTargetData;
import com.vmware.vsphere.client.drs.model.RecommendationData;
import com.vmware.vsphere.client.drs.model.VmMonitorTargetData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DrsMonitorPropertyProvider {
    private static final String HOST_ENTER_QUARANTINE_ICON = "vx-icon-hostEnterQuarantine";
    private static final String VIRTUAL_MACHINE_ICON = "vsphere-icon-vm";
    private static final String HOST_EXIT_QUARANTINE_ICON = "vx-icon-hostExitQuarantine";
    private static final String HOST_POWER_OFF_ICON = "vx-icon-hostShutDown";
    private static final String HOST_POWER_ON_ICON = "vx-icon-hostPowerOn";
    private static final String HOST_ENTER_MAINTENANCE_ICON = "vx-icon-hostEnterMaintenanceMode";
    public static final String PROPERTY_RECOMMENDATION = "recommendation";
    public static final String PROPERTY_FAULT = "drsFault";
    public static final String PROPERTY_ACTION_HISTORY = "actionHistory";
    public static final String FAULT_FIELD_HOST = "host";
    public static final String FAULT_METHOD_HOST = "getHost";
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;
    private final ObjectReferenceService _objectReferenceService;
    private final RecommendationsService _recommendationsService;

    public DrsMonitorPropertyProvider(QueryServiceFactory queryServiceFactory, QueryBindingServiceFactory queryBindingServiceFactory, ObjectReferenceService objectReferenceService, RecommendationsService recommendationsService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._objectReferenceService = objectReferenceService;
        this._recommendationsService = recommendationsService;
    }

    @PropertyProvider(value="ClusterComputeResource/computedDrsRecommendations")
    public List<DrsRecommendationListItemData[]> getComputedDrsRecommendations(Collection<ManagedObjectReference> objects) {
        ArrayList<DrsRecommendationListItemData[]> result = new ArrayList<DrsRecommendationListItemData[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_RECOMMENDATION}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{this.buildIdentityFilter(objects)}).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            Recommendation[] recommendations = (Recommendation[])resultItem.get(PROPERTY_RECOMMENDATION);
            result.add(this.getRecommendationListData(recommendations));
        }
        return result;
    }

    @PropertyProvider(value="ClusterComputeResource/computedDrsFaults")
    public List<DrsFaultListItem[]> getComputedDrsFaults(Collection<ManagedObjectReference> objects) throws Exception {
        ArrayList<DrsFaultListItem[]> result = new ArrayList<DrsFaultListItem[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_FAULT}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{this.buildIdentityFilter(objects)}).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            DrsFaults[] faults = (DrsFaults[])resultItem.get(PROPERTY_FAULT);
            result.add(this.getFaultListData(faults));
        }
        return result;
    }

    @PropertyProvider(value="ClusterComputeResource/computedActionHistory")
    public List<DrsActionHistoryListItem[]> getComputedActionHistory(Collection<ManagedObjectReference> objects) {
        ArrayList<DrsActionHistoryListItem[]> result = new ArrayList<DrsActionHistoryListItem[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_ACTION_HISTORY}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{this.buildIdentityFilter(objects)}).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            ActionHistory[] actionHistory = (ActionHistory[])resultItem.get(PROPERTY_ACTION_HISTORY);
            result.add(this.getActionHistoryListData(actionHistory));
        }
        return result;
    }

    private PropertyPredicate buildIdentityFilter(Collection<?> objects) {
        return new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects);
    }

    private DrsRecommendationListItemData[] getRecommendationListData(Recommendation[] recommendations) {
        if (ArrayUtil.isNullOrEmpty((Object[])recommendations)) {
            return new DrsRecommendationListItemData[0];
        }
        List recommendationsData = this._recommendationsService.getRecommendationListItems(recommendations);
        HashSet<ManagedObjectReference> targets = new HashSet<ManagedObjectReference>();
        for (RecommendationData recommendation : recommendationsData) {
            targets.addAll(Arrays.asList(recommendation.targetObjects));
        }
        Map<String, VmMonitorTargetData> vmPropsByRef = this.getObjectProperties(targets, VirtualMachine.class.getSimpleName(), VmMonitorTargetData.class);
        Map<String, HostMonitorTargetData> hostPropsByRef = this.getObjectProperties(targets, HostSystem.class.getSimpleName(), HostMonitorTargetData.class);
        HashMap<String, MonitorTargetData> objPropsByRef = new HashMap<String, MonitorTargetData>();
        objPropsByRef.putAll(vmPropsByRef);
        objPropsByRef.putAll(hostPropsByRef);
        DrsRecommendationListItemData[] result = new DrsRecommendationListItemData[recommendationsData.size()];
        for (int i = 0; i < recommendationsData.size(); ++i) {
            RecommendationData item = (RecommendationData)recommendationsData.get(i);
            String formatRecString = DrsMonitorPropertyProvider.getRecommendationText(item.action);
            DrsRecommendationListItemData listItem = new DrsRecommendationListItemData();
            listItem.recommendationData = item;
            listItem.recommendationText = formatRecString;
            listItem.targets = this.getTargetObjectsData(objPropsByRef, item.targetObjects);
            listItem.image = this.getRecommendationImage(item.action, objPropsByRef);
            result[i] = listItem;
        }
        return result;
    }

    private MonitorTargetData[] getTargetObjectsData(Map<String, MonitorTargetData> objPropsByRef, ManagedObjectReference[] targets) {
        if (targets == null) {
            return new MonitorTargetData[0];
        }
        MonitorTargetData[] targetsData = new MonitorTargetData[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            targetsData[i] = objPropsByRef.get(this._objectReferenceService.getUid((Object)targets[i]));
        }
        return targetsData;
    }

    private DrsActionHistoryListItem[] getActionHistoryListData(ActionHistory[] actionHistory) {
        if (ArrayUtil.isNullOrEmpty((Object[])actionHistory)) {
            return new DrsActionHistoryListItem[0];
        }
        HashMap<ActionHistory, List<ManagedObjectReference>> objectsPerHistoryItem = new HashMap<ActionHistory, List<ManagedObjectReference>>();
        HashSet<ManagedObjectReference> allRelatedObjects = new HashSet<ManagedObjectReference>();
        for (ActionHistory actionHistoryItem : actionHistory) {
            List<ManagedObjectReference> actionObjects = DrsActionHistoryUtil.collectTargetsFromActionHistory(actionHistoryItem);
            objectsPerHistoryItem.put(actionHistoryItem, actionObjects);
            allRelatedObjects.addAll(actionObjects);
        }
        Map<Object, MonitorTargetData> vmsData = this.getDrsTargetDataForObjects(allRelatedObjects, VirtualMachine.class.getSimpleName(), VmMonitorTargetData.class);
        Map<Object, MonitorTargetData> hostsData = this.getDrsTargetDataForObjects(allRelatedObjects, HostSystem.class.getSimpleName(), HostMonitorTargetData.class);
        HashMap<Object, MonitorTargetData> objectDataByRef = new HashMap<Object, MonitorTargetData>();
        objectDataByRef.putAll(vmsData);
        objectDataByRef.putAll(hostsData);
        List<DrsActionHistoryListItem> result = DrsActionHistoryUtil.makeGridData(actionHistory, objectsPerHistoryItem, objectDataByRef);
        return result.toArray(new DrsActionHistoryListItem[0]);
    }

    private String getRecommendationImage(Action action, Map<String, MonitorTargetData> objPropsByRef) {
        if (action instanceof HostPowerAction) {
            HostPowerAction hostPowerAction = (HostPowerAction)action;
            if (hostPowerAction.operationType == HostPowerAction.OperationType.powerOn) {
                return HOST_POWER_ON_ICON;
            }
            return HOST_POWER_OFF_ICON;
        }
        if (action instanceof MigrationAction) {
            MigrationAction migrationAction = (MigrationAction)action;
            String vmId = this._objectReferenceService.getUid((Object)migrationAction.drsMigration.vm);
            MonitorTargetData objectDetailsMigration = objPropsByRef.get(vmId);
            return objectDetailsMigration.getPrimaryIconId();
        }
        if (action instanceof InitialPlacementAction) {
            InitialPlacementAction initialPlacementAction = (InitialPlacementAction)action;
            String targetUid = this._objectReferenceService.getUid((Object)initialPlacementAction.target);
            MonitorTargetData objectDetailsPlacement = objPropsByRef.get(targetUid);
            return objectDetailsPlacement.getPrimaryIconId();
        }
        if (action instanceof HostInfraUpdateHaModeAction) {
            HostInfraUpdateHaModeAction infraUpdateHaAction = (HostInfraUpdateHaModeAction)action;
            String opType = infraUpdateHaAction.operationType;
            switch (HostInfraUpdateHaModeAction.OperationType.valueOf((String)opType)) {
                case enterMaintenance: {
                    return HOST_ENTER_MAINTENANCE_ICON;
                }
                case exitQuarantine: {
                    return HOST_EXIT_QUARANTINE_ICON;
                }
                case enterQuarantine: {
                    return HOST_ENTER_QUARANTINE_ICON;
                }
            }
        }
        return VIRTUAL_MACHINE_ICON;
    }

    private <T extends MonitorTargetData> Map<Object, MonitorTargetData> getDrsTargetDataForObjects(Collection<ManagedObjectReference> objects, String objectType, Class<T> modelClass) {
        HashMap<Object, MonitorTargetData> result = new HashMap<Object, MonitorTargetData>();
        List<ManagedObjectReference> homogeneousObjects = this.filterObjectsByType(objectType, objects);
        if (!homogeneousObjects.isEmpty()) {
            Collection objectModels = this._queryBindingService.prepare(modelClass).fetch(homogeneousObjects);
            for (MonitorTargetData model : objectModels) {
                result.put(model.getProvider(), model);
            }
        }
        return result;
    }

    private <T extends MonitorTargetData> Map<String, T> getObjectProperties(Collection<ManagedObjectReference> objRefs, String objectType, Class<T> modelClass) {
        Map<Object, Object> objPropsByRef;
        List<ManagedObjectReference> homogeneousObjects = this.filterObjectsByType(objectType, objRefs);
        if (!homogeneousObjects.isEmpty()) {
            Collection resultSet = this._queryBindingService.prepare(modelClass).fetch(homogeneousObjects);
            objPropsByRef = this.getTargetMapByResultSet(resultSet);
        } else {
            objPropsByRef = new HashMap();
        }
        return objPropsByRef;
    }

    private List<ManagedObjectReference> filterObjectsByType(String resourceType, Collection<ManagedObjectReference> objects) {
        ArrayList<ManagedObjectReference> filteredObjects = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference object : objects) {
            if (!object.getType().equals(resourceType)) continue;
            filteredObjects.add(object);
        }
        return filteredObjects;
    }

    private <T extends IdentifiableModel> Map<String, T> getTargetMapByResultSet(Collection<T> resultSet) {
        HashMap<String, IdentifiableModel> propertiesByObject = new HashMap<String, IdentifiableModel>();
        for (IdentifiableModel resultItem : resultSet) {
            Object objRef = resultItem.getProvider();
            String objUid = this._objectReferenceService.getUid(objRef);
            propertiesByObject.put(objUid, resultItem);
        }
        return propertiesByObject;
    }

    private DrsFaultListItem[] getFaultListData(DrsFaults[] drsFaultsArray) throws Exception {
        Map<Object, Object> hostNamesByRef;
        if (ArrayUtil.isNullOrEmpty((Object[])drsFaultsArray)) {
            return new DrsFaultListItem[0];
        }
        HashMap<String, ManagedObjectReference> hostsByVmRef = new HashMap<String, ManagedObjectReference>();
        Set<ManagedObjectReference> vmRefs = DrsFaultsUtil.getVmReferences(drsFaultsArray);
        Map<String, FaultVmTargetData> vmData = this.getVmProperties(vmRefs);
        HashSet<ManagedObjectReference> hostRefs = new HashSet<ManagedObjectReference>();
        for (Map.Entry<String, FaultVmTargetData> vmEntry : vmData.entrySet()) {
            hostsByVmRef.put(vmEntry.getKey(), vmEntry.getValue().host);
            hostRefs.add(vmEntry.getValue().host);
        }
        DrsFaultsUtil.collectDrsFaultHosts(drsFaultsArray, hostRefs);
        if (!hostRefs.isEmpty()) {
            Collection resultSet = this._queryBindingService.prepare(HostNameData.class).fetch(hostRefs);
            hostNamesByRef = this.getTargetMapByResultSet(resultSet);
        } else {
            hostNamesByRef = new HashMap();
        }
        List<DrsFaultListItem> drsFaultItems = DrsFaultsUtil.makeGridData(drsFaultsArray, hostsByVmRef, hostNamesByRef, this._objectReferenceService, vmData);
        return drsFaultItems.toArray(new DrsFaultListItem[0]);
    }

    private Map<String, FaultVmTargetData> getVmProperties(Set<ManagedObjectReference> vmRefs) {
        Map<String, FaultVmTargetData> vmProperties;
        if (!vmRefs.isEmpty()) {
            Collection resultSet = this._queryBindingService.prepare(FaultVmTargetData.class).fetch(vmRefs);
            vmProperties = this.getTargetMapByResultSet(resultSet);
        } else {
            vmProperties = new HashMap<String, FaultVmTargetData>();
        }
        return vmProperties;
    }

    private static String getRecommendationText(Action action) {
        if (action instanceof InitialPlacementAction) {
            return Util.getLocalizedString("RecommendationListItemData.initialPlacement", new String[0]);
        }
        if (action instanceof HostPowerAction) {
            HostPowerAction hostPowerAction = (HostPowerAction)action;
            if (hostPowerAction.operationType.equals((Object)HostPowerAction.OperationType.powerOff)) {
                return Util.getLocalizedString("RecommendationListItemData.hostPowerOff", new String[0]);
            }
            return Util.getLocalizedString("RecommendationListItemData.hostPowerOn", new String[0]);
        }
        if (action instanceof MigrationAction) {
            return Util.getLocalizedString("RecommendationListItemData.migration", new String[0]);
        }
        if (action instanceof HostInfraUpdateHaModeAction) {
            String strOp;
            HostInfraUpdateHaModeAction infraUpdateHaAction = (HostInfraUpdateHaModeAction)action;
            String opType = infraUpdateHaAction.operationType;
            switch (HostInfraUpdateHaModeAction.OperationType.valueOf((String)opType)) {
                case enterMaintenance: {
                    strOp = Util.getLocalizedString("RecommendationListItemData.infraHaUpdate.enter.maintenance", new String[0]);
                    break;
                }
                case exitQuarantine: {
                    strOp = Util.getLocalizedString("RecommendationListItemData.infraHaUpdate.exit.quarantine", new String[0]);
                    break;
                }
                case enterQuarantine: {
                    strOp = Util.getLocalizedString("RecommendationListItemData.infraHaUpdate.enter.quarantine", new String[0]);
                    break;
                }
                default: {
                    strOp = "";
                }
            }
            return strOp;
        }
        return "";
    }
}

