/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsClusterUtilizationUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.VmUtilizationData;

@QueryBinding(value="VirtualMachine")
public class DrsMemoryVmUtilizationData
extends VmUtilizationData {
    @Property(value="VirtualMachine/summary/quickStats/hostMemoryUsage")
    public int overallMemoryUsage;
    @Property(value="VirtualMachine/summary/quickStats/guestMemoryUsage")
    public int activeMemoryUsage;
    public double consumedMemoryBarWidth;
    public double activeMemoryBarWidth;
    @Property(value="VirtualMachine/summary/quickStats/distributedMemoryEntitlement")
    private int memoryEntitlement;

    public String getOverallMemoryUsageText() {
        return FormatUtil.getDataSizeFormatted((Number)this.overallMemoryUsage, (int)2, (long)0x100000L, (long)-1L, (boolean)true);
    }

    public String getActiveMemoryUsageText() {
        return FormatUtil.getDataSizeFormatted((Number)this.activeMemoryUsage, (int)2, (long)0x100000L, (long)-1L, (boolean)true);
    }

    public String getMemoryEntitlementText() {
        return FormatUtil.getDataSizeFormatted((Number)this.memoryEntitlement, (int)2, (long)0x100000L, (long)-1L, (boolean)true);
    }

    public int getMemoryDeliveredPercentage() {
        return DrsClusterUtilizationUtil.getDeliveredPercentage(this.memoryEntitlement, this.overallMemoryUsage);
    }

    private double getMemoryDelivered() {
        return Math.min(1.0, this.memoryEntitlement > 0 ? (double)this.overallMemoryUsage / (double)this.memoryEntitlement : 0.0);
    }
}

