/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.DrsClusterUtilizationUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.utilization.HostUtilizationData;

@QueryBinding(value="HostSystem")
public class DrsNetworkHostUtilizationData
extends HostUtilizationData {
    @Property(value="HostSystem/averageNetReceived")
    private long averageRx;
    @Property(value="HostSystem/averageNetTransmitted")
    private long averageTx;
    @Property(value="HostSystem/config/network/pnic")
    private PhysicalNic[] physicalNics;

    public double getAverageRxPercent() {
        return DrsClusterUtilizationUtil.getNetworkUtilizationPercentValue(this.averageRx, this.physicalNics);
    }

    public double getAverageTxPercent() {
        return DrsClusterUtilizationUtil.getNetworkUtilizationPercentValue(this.averageTx, this.physicalNics);
    }

    public String getAverageRx() {
        return FormatUtil.getBitRateFormatted((Number)this.averageRx, (int)2, (long)FormatUtil.KBPS, (long)-1L, (boolean)true);
    }

    public String getAverageTx() {
        return FormatUtil.getBitRateFormatted((Number)this.averageTx, (int)2, (long)FormatUtil.KBPS, (long)-1L, (boolean)true);
    }
}

