/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.cluster.DasVmSettings;
import com.vmware.vim.binding.vim.cluster.InfraUpdateHaConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.clusterui.ha.FailureConditionItemFactory;
import com.vmware.vsphere.client.clusterui.model.services.FailureConditionItem;
import com.vmware.vsphere.client.clusterui.model.services.VmResponseControlModel;
import java.util.ArrayList;

@QueryBinding(value="ClusterComputeResource")
public class FailureConditionData
extends IdentifiableQueryBinding {
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/enabled")
    public transient boolean haEnabled;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    public transient boolean drsEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/hostMonitoring")
    public transient String hostMonitoring;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings")
    public transient DasVmSettings defaultVmSettings;
    @Property(value="ClusterComputeResource/configurationEx/infraUpdateHaConfig")
    public transient InfraUpdateHaConfigInfo proactiveHaConfigInfo;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/vmMonitoring")
    public transient String vmMonitoring;
    @Property(value="ClusterComputeResource/vmcpSupported")
    public transient boolean vmComponentProtectingSupported;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/vmComponentProtecting")
    public transient String vmComponentProtecting;

    public FailureConditionItem[] getItems() {
        return this.buildFailureConditionItems(this.defaultVmSettings, true);
    }

    public FailureConditionItem[] buildFailureConditionItems(DasVmSettings defaultVmSettings, boolean isVmcpSupportedForVm) {
        ArrayList<FailureConditionItem> listFailureItems = new ArrayList<FailureConditionItem>(6);
        VmResponseControlModel vmResponseControlModel = new VmResponseControlModel(defaultVmSettings);
        FailureConditionItem hostItem = FailureConditionItemFactory.createHostFailureItem(this.haEnabled, this.hostMonitoring, vmResponseControlModel.getRestartPriority());
        FailureConditionItem guestNotHeartbeating = FailureConditionItemFactory.createGuestNotHeartbeatingItem(this.haEnabled, this.vmMonitoring);
        boolean vmRestartPriorityDisabled = DasVmSettings.RestartPriority.disabled.equals((Object)vmResponseControlModel.getRestartPriority());
        FailureConditionItem hostIsolationResponse = FailureConditionItemFactory.createHostIsolationResponseItem(this.haEnabled, this.hostMonitoring, vmResponseControlModel.getIsolationResponse(), vmRestartPriorityDisabled);
        listFailureItems.add(hostItem);
        ManagedObjectReference providerMor = (ManagedObjectReference)this.provider;
        if (VcServiceUtil.is65VcOrLaterByServerGuid((String)providerMor.getServerGuid())) {
            FailureConditionItem proactiveHa = FailureConditionItemFactory.createProactiveHaItem(this.proactiveHaConfigInfo, this.drsEnabled);
            listFailureItems.add(proactiveHa);
        }
        listFailureItems.add(hostIsolationResponse);
        if (this.vmComponentProtectingSupported) {
            FailureConditionItem dsWithProtectionDeviceLoss = this.createDsWithPdlOrApdItem(true, vmResponseControlModel, vmRestartPriorityDisabled, isVmcpSupportedForVm);
            listFailureItems.add(dsWithProtectionDeviceLoss);
            FailureConditionItem dsWithAllPathsDown = this.createDsWithPdlOrApdItem(false, vmResponseControlModel, vmRestartPriorityDisabled, isVmcpSupportedForVm);
            listFailureItems.add(dsWithAllPathsDown);
        }
        listFailureItems.add(guestNotHeartbeating);
        return listFailureItems.toArray(new FailureConditionItem[0]);
    }

    private FailureConditionItem createDsWithPdlOrApdItem(boolean isPdlItem, VmResponseControlModel vmResponseControlModel, boolean vmRestartPriorityDisabled, boolean isVmcpSupportedForVm) {
        boolean hostMonitoringEnabled = DasConfigInfo.ServiceState.enabled.name().equals(this.hostMonitoring);
        boolean vmComponentProtectingEnabled = isVmcpSupportedForVm && DasConfigInfo.ServiceState.enabled.name().equals(this.vmComponentProtecting);
        FailureConditionItem item = isPdlItem ? FailureConditionItemFactory.createDsWithPermanentDeviceLossItem(this.haEnabled, hostMonitoringEnabled, vmRestartPriorityDisabled, vmComponentProtectingEnabled, vmResponseControlModel.getVmStorageProtectionForPDL()) : FailureConditionItemFactory.createDsWithAllPathsDownItem(this.haEnabled, hostMonitoringEnabled, vmRestartPriorityDisabled, vmComponentProtectingEnabled, vmResponseControlModel.getVmStorageProtectionForAPD());
        return item;
    }
}

