/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.DatastoreStorageVmData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolCpuReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolMemoryReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VirtualDiskListItemData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmCpuReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmMemoryReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmStorageReservationUsersData;
import com.vmware.vsphere.client.clusterui.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ResourceReservationUtil {
    private static final int RP_NUMBER_OF_CPUS = 4;
    private static final int CPU_FACTOR = 1000;

    public static VirtualDiskListItemData[] getVirtualDiskListItemDatas(DatastoreStorageVmData[] datastores, VmStorageReservationUsersData[] vms) {
        Map<ManagedObjectReference, DatastoreStorageVmData> datastoresByUid = ResourceReservationUtil.getDatastoresByUid(datastores);
        return ResourceReservationUtil.getStorageVmVirtualDisks(vms, datastoresByUid);
    }

    public static VmCpuReservationUsersData[] getVmsCpuSharesValuePercentages(VmCpuReservationUsersData[] vms, ResourcePoolCpuReservationUsersData[] resourcePools) {
        long cpuOverallSharesInfoValues = ResourceReservationUtil.getCpuOverallSharesInfoValues(vms, resourcePools);
        if (vms != null) {
            for (VmCpuReservationUsersData vm : vms) {
                if (vm.sharesInfo == null) continue;
                int currentCpuAllocationSharesValue = vm.sharesInfo.getShares();
                long currentPercentage = ResourceReservationUtil.getSharesValuePercent(currentCpuAllocationSharesValue, cpuOverallSharesInfoValues);
                vm.setSharesInfoValuePercent(currentPercentage);
            }
        }
        return vms;
    }

    public static ResourcePoolCpuReservationUsersData[] getRpsCpuSharesValuePercentages(VmCpuReservationUsersData[] vms, ResourcePoolCpuReservationUsersData[] resourcePools) {
        long cpuOverallSharesInfoValues = ResourceReservationUtil.getCpuOverallSharesInfoValues(vms, resourcePools);
        if (resourcePools != null) {
            for (ResourcePoolCpuReservationUsersData rp : resourcePools) {
                if (rp.sharesInfo == null) continue;
                int currentSharesValue = rp.sharesInfo.getShares();
                long currentPercentage = ResourceReservationUtil.getSharesValuePercent(currentSharesValue, cpuOverallSharesInfoValues);
                rp.setSharesInfoValuePercent(currentPercentage);
            }
        }
        return resourcePools;
    }

    public static VmMemoryReservationUsersData[] getVmsMemorySharesValuePercentages(VmMemoryReservationUsersData[] vms, ResourcePoolMemoryReservationUsersData[] resourcePools) {
        long cpuOverallSharesInfoValues = ResourceReservationUtil.getMemoryOverallSharesInfoValues(vms, resourcePools);
        if (vms != null) {
            for (VmMemoryReservationUsersData vm : vms) {
                if (vm.sharesInfo == null) continue;
                int currentCpuAllocationSharesValue = vm.sharesInfo.getShares();
                long currentPercentage = ResourceReservationUtil.getSharesValuePercent(currentCpuAllocationSharesValue, cpuOverallSharesInfoValues);
                vm.setSharesInfoValuePercent(currentPercentage);
            }
        }
        return vms;
    }

    public static ResourcePoolMemoryReservationUsersData[] getRpsMemorySharesValuePercentages(VmMemoryReservationUsersData[] vms, ResourcePoolMemoryReservationUsersData[] resourcePools) {
        long cpuOverallSharesInfoValues = ResourceReservationUtil.getMemoryOverallSharesInfoValues(vms, resourcePools);
        if (resourcePools != null) {
            for (ResourcePoolMemoryReservationUsersData rp : resourcePools) {
                if (rp.sharesInfo == null) continue;
                int currentSharesValue = rp.sharesInfo.getShares();
                long currentPercentage = ResourceReservationUtil.getSharesValuePercent(currentSharesValue, cpuOverallSharesInfoValues);
                rp.setSharesInfoValuePercent(currentPercentage);
            }
        }
        return resourcePools;
    }

    private static VirtualDiskListItemData[] getStorageVmVirtualDisks(VmStorageReservationUsersData[] vmData, Map<ManagedObjectReference, DatastoreStorageVmData> datastores) {
        if (vmData == null) {
            return new VirtualDiskListItemData[0];
        }
        ArrayList<VirtualDiskListItemData> result = new ArrayList<VirtualDiskListItemData>();
        for (VmStorageReservationUsersData vm : vmData) {
            if (vm == null || vm.virtualDisks == null) continue;
            for (VirtualDisk virtualDisk : vm.virtualDisks) {
                if (virtualDisk == null || datastores == null) continue;
                VirtualDiskListItemData vd = ResourceReservationUtil.getVirtualDiskInfoData(datastores, vm, virtualDisk);
                result.add(vd);
            }
        }
        return result.toArray(new VirtualDiskListItemData[0]);
    }

    private static VirtualDiskListItemData getVirtualDiskInfoData(Map<ManagedObjectReference, DatastoreStorageVmData> datastores, VmStorageReservationUsersData vm, VirtualDisk virtualDisk) {
        VirtualDiskListItemData vd = new VirtualDiskListItemData();
        VirtualDevice.FileBackingInfo backing = null;
        if (virtualDisk.getBacking() instanceof VirtualDevice.FileBackingInfo) {
            backing = (VirtualDevice.FileBackingInfo)virtualDisk.getBacking();
        }
        SharesInfo shares = virtualDisk.shares;
        vd.vm = vm.getPrimaryVmRef();
        vd.vmName = vm.name;
        vd.vmPrimaryIcon = vm.primaryIconId;
        if (virtualDisk.getDeviceInfo() != null) {
            vd.label = virtualDisk.getDeviceInfo().getLabel();
        }
        if (virtualDisk.getStorageIOAllocation() != null) {
            vd.limit = virtualDisk.getStorageIOAllocation().getLimit();
        }
        if (backing != null) {
            vd.datastoreMor = backing.getDatastore();
        }
        if (shares != null) {
            vd.shares = shares.getShares();
            vd.shareLevel = Util.getLocalizedString("resourceReservation.shareLevel.".concat(shares.getLevel().name()), new String[0]);
            if (datastores.get(vd.datastoreMor) != null) {
                vd.datastoreSharesPercentage = Math.round((double)vd.shares / (double)datastores.get(vd.datastoreMor).getTotalShares() * 100.0);
            }
        }
        if (datastores.get(vd.datastoreMor) != null) {
            vd.datastoreName = datastores.get((Object)vd.datastoreMor).name;
        }
        if (vd.datastoreName == null) {
            vd.datastoreName = Util.getLocalizedString("storage.notAvailable", new String[0]);
        }
        return vd;
    }

    private static Map<ManagedObjectReference, DatastoreStorageVmData> getDatastoresByUid(DatastoreStorageVmData[] datastores) {
        if (datastores == null) {
            return null;
        }
        HashMap<ManagedObjectReference, DatastoreStorageVmData> datastoresByUid = new HashMap<ManagedObjectReference, DatastoreStorageVmData>();
        for (DatastoreStorageVmData datastore : datastores) {
            if (datastore == null || datastore.vms == null || !(datastore.getProvider() instanceof ManagedObjectReference)) continue;
            datastoresByUid.put((ManagedObjectReference)datastore.getProvider(), datastore);
        }
        return datastoresByUid;
    }

    private static long getMemoryOverallSharesInfoValues(VmMemoryReservationUsersData[] vms, ResourcePoolMemoryReservationUsersData[] resourcePools) {
        long cpuOverallSharesInfoValues = ResourceReservationUtil.getVmMemoryAllocationSharesInfoValueSum(vms) + ResourceReservationUtil.getResourcePoolMemoryAllocationSharesInfoValueSum(resourcePools);
        return cpuOverallSharesInfoValues;
    }

    private static long getCpuOverallSharesInfoValues(VmCpuReservationUsersData[] vms, ResourcePoolCpuReservationUsersData[] resourcePools) {
        long cpuOverallSharesInfoValues = ResourceReservationUtil.getVmCpuAllocationSharesInfoValueSum(vms) + ResourceReservationUtil.getResourcePoolCpuAllocationSharesInfoValueSum(resourcePools);
        return cpuOverallSharesInfoValues;
    }

    private static long getVmCpuAllocationSharesInfoValueSum(VmCpuReservationUsersData[] vms) {
        long vmCpuOverallSharesInfoValues = 0L;
        if (vms != null) {
            for (VmCpuReservationUsersData vm : vms) {
                if (vm.sharesInfo == null) continue;
                int currentVmCpuAllocationSharesValue = vm.sharesInfo.getShares();
                vmCpuOverallSharesInfoValues += currentVmCpuAllocationSharesValue == 0 ? (long)(vm.numOfCpu * 1000) : (long)currentVmCpuAllocationSharesValue;
            }
        }
        return vmCpuOverallSharesInfoValues;
    }

    private static long getResourcePoolCpuAllocationSharesInfoValueSum(ResourcePoolCpuReservationUsersData[] resourcePools) {
        long rpCpuOverallSharesInfoValues = 0L;
        if (resourcePools != null) {
            for (ResourcePoolCpuReservationUsersData rp : resourcePools) {
                if (rp.sharesInfo == null) continue;
                int currentRpCpuAllocationSharesValue = rp.sharesInfo.getShares();
                rpCpuOverallSharesInfoValues += currentRpCpuAllocationSharesValue == 0 ? 4000L : (long)currentRpCpuAllocationSharesValue;
            }
        }
        return rpCpuOverallSharesInfoValues;
    }

    private static long getVmMemoryAllocationSharesInfoValueSum(VmMemoryReservationUsersData[] vms) {
        long vmMemoryOverallSharesInfoValues = 0L;
        if (vms != null) {
            for (VmMemoryReservationUsersData vm : vms) {
                if (vm.sharesInfo == null || vm.sharesInfo.getShares() == 0) continue;
                vmMemoryOverallSharesInfoValues += (long)vm.sharesInfo.getShares();
            }
        }
        return vmMemoryOverallSharesInfoValues;
    }

    private static long getResourcePoolMemoryAllocationSharesInfoValueSum(ResourcePoolMemoryReservationUsersData[] resourcePools) {
        long rpMemoryOverallSharesInfoValues = 0L;
        if (resourcePools != null) {
            for (ResourcePoolMemoryReservationUsersData rp : resourcePools) {
                if (rp.sharesInfo == null || rp.sharesInfo.getShares() == 0) continue;
                rpMemoryOverallSharesInfoValues += (long)rp.sharesInfo.getShares();
            }
        }
        return rpMemoryOverallSharesInfoValues;
    }

    private static long getSharesValuePercent(int sharesValue, long overallSharesInfoValues) {
        double percentage = Util.getPercentageValue(sharesValue, overallSharesInfoValues);
        long currentPercentage = Math.round(percentage);
        return currentPercentage;
    }
}

