/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vsphere.client.clusterui.util.Util;

public class UtilizationUtil {
    private static final long MAX_SHARES = 1000000L;

    public static String getCpuShares(SharesInfo sharesInfo, int multiplier) {
        long share = 1000L * (long)multiplier;
        return UtilizationUtil.getSharesInfo(sharesInfo, share);
    }

    public static String getMemoryShares(SharesInfo sharesInfo, int multiplier) {
        long share = 10L * (long)multiplier;
        return UtilizationUtil.getSharesInfo(sharesInfo, share);
    }

    private static String getSharesInfo(SharesInfo sharesInfo, long shares) {
        if (sharesInfo == null) {
            return "";
        }
        long sharesValue = shares;
        String l10nKey = "";
        switch (sharesInfo.level) {
            case normal: {
                l10nKey = "share.utilization.normal";
                break;
            }
            case low: {
                l10nKey = "share.utilization.low";
                sharesValue /= 2L;
                break;
            }
            case high: {
                l10nKey = "share.utilization.high";
                sharesValue *= 2L;
                break;
            }
            case custom: {
                l10nKey = "share.utilization.custom";
                sharesValue = sharesInfo.shares;
                break;
            }
        }
        if (sharesValue > 1000000L) {
            sharesValue = 1000000L;
        }
        return Util.getLocalizedString(l10nKey, Long.toString(sharesValue));
    }
}

