/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.selector;

import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.services.messaging.selector.JMSSelectorException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;

public class JMSSelector {
    public static final String LOG_CATEGORY = "Message.Selector";
    private String pattern = null;

    public JMSSelector(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        this.pattern = pattern;
    }

    public boolean match(Message msg) throws JMSSelectorException {
        if (this.pattern.equals("")) {
            return true;
        }
        boolean matched = false;
        try {
            BooleanExpression expr = SelectorParser.parse((String)this.pattern);
            ActiveMQMessage dummyMessage = new ActiveMQMessage();
            dummyMessage.setProperties(msg.getHeaders());
            MessageEvaluationContext context = new MessageEvaluationContext();
            context.setMessageReference((MessageReference)dummyMessage);
            matched = expr.matches(context);
        }
        catch (InvalidSelectorException e) {
            throw new JMSSelectorException(e);
        }
        catch (JMSException e) {
            throw new JMSSelectorException(e);
        }
        Log.getLogger((String)LOG_CATEGORY).debug("Selector: " + this.pattern + (matched ? " matched " : " did not match ") + " message with id: " + msg.getMessageId());
        return matched;
    }
}

