/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cloudvm;

import com.vmware.vise.core.model.data;
import com.vmware.vise.vim.commons.xmlrpc.XmlRpcUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@data(base="Object")
public class IPv4Config {
    public String nic;
    public Ipv4Mode mode;
    public String address;
    public int prefix;
    public String defaultGateway;
    public Boolean updateable;

    Map<?, ?> toParam() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("interface", this.nic);
        hashMap.put("mode", this.mode.toString().toLowerCase());
        hashMap.put("address", StringUtils.defaultString((String)this.address));
        hashMap.put("prefix", this.prefix);
        hashMap.put("defaultGateway", StringUtils.defaultString((String)this.defaultGateway));
        hashMap.put("updateable", this.updateable);
        return hashMap;
    }

    static IPv4Config fromParam(Map<?, ?> map) {
        IPv4Config iPv4Config = new IPv4Config();
        iPv4Config.nic = (String)map.get("interface");
        iPv4Config.mode = Ipv4Mode.valueOf(((String)map.get("mode")).toUpperCase(Locale.ENGLISH));
        iPv4Config.address = (String)map.get("address");
        iPv4Config.prefix = XmlRpcUtil.getInt(map, (String)"prefix");
        iPv4Config.defaultGateway = (String)map.get("defaultGateway");
        iPv4Config.updateable = (Boolean)map.get("updateable");
        return iPv4Config;
    }

    static IPv4Config[] fromArray(Object[] objectArray) {
        IPv4Config[] iPv4ConfigArray = new IPv4Config[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iPv4ConfigArray[i] = IPv4Config.fromParam((Map)objectArray[i]);
        }
        return iPv4ConfigArray;
    }

    static Object[] toParamArray(IPv4Config[] iPv4ConfigArray) {
        Object[] objectArray = new Object[iPv4ConfigArray.length];
        for (int i = 0; i < iPv4ConfigArray.length; ++i) {
            objectArray[i] = iPv4ConfigArray[i].toParam();
        }
        return objectArray;
    }

    public static enum Ipv4Mode {
        UNCONFIGURED,
        DHCP,
        STATIC;

    }
}

