/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm;

import com.vmware.cis.services.common.sso.SsoOverRestVerifierUtil;
import com.vmware.cis.services.common.sso.StsCertManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceBundleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log _log = LogFactory.getLog(ResourceBundleServlet.class);
    private boolean _ssoEnabled = false;
    private final StsCertManager _stsCertManager;
    private final InputStream _resourceStream;
    private final String _contentType;
    private final String _fileName;
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final int CLOCK_TOLERANCE_SEC = 300;
    private static final int MAX_REQUEST_AGE_SEC = 3600;

    public ResourceBundleServlet(String string, InputStream inputStream, String string2, boolean bl, StsCertManager stsCertManager) {
        this._fileName = string;
        this._resourceStream = inputStream;
        this._contentType = string2 == null ? DEFAULT_CONTENT_TYPE : string2;
        this._ssoEnabled = bl;
        this._stsCertManager = stsCertManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            Object object;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("doGet: Entering (%s)", httpServletRequest.getRequestURI()));
            }
            if (this._ssoEnabled) {
                try {
                    object = IOUtils.toByteArray((InputStream)httpServletRequest.getInputStream());
                    SsoOverRestVerifierUtil.verifySecurityHeader((HttpServletRequest)httpServletRequest, (byte[])object, (StsCertManager)this._stsCertManager, (int)300, (int)3600);
                }
                catch (SsoOverRestVerifierUtil.SsoAuthException ssoAuthException) {
                    _log.error((Object)("doGet: SSO verification failed for client " + this.getRemoteClientInfo(httpServletRequest)), (Throwable)ssoAuthException);
                    httpServletResponse.setStatus(401);
                    return;
                }
            }
            object = httpServletResponse.getOutputStream();
            BufferedInputStream bufferedInputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            int n = 0;
            try {
                int n2;
                bufferedInputStream = new BufferedInputStream(this._resourceStream);
                bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                byte[] byArray = new byte[16384];
                while (-1 != (n2 = bufferedInputStream.read(byArray, 0, byArray.length))) {
                    bufferedOutputStream.write(byArray, 0, n2);
                    n += n2;
                }
            }
            finally {
                httpServletResponse.setContentType(this._contentType);
                httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + this._fileName + "\"");
                httpServletResponse.setHeader("Content-Length", String.valueOf(n));
                IOUtils.closeQuietly((InputStream)this._resourceStream);
                IOUtils.closeQuietly((InputStream)bufferedInputStream);
                IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("doGet: Leaving (%s)", httpServletRequest.getRequestURI()));
            }
        }
        catch (Exception exception) {
            _log.error((Object)"doGet: Failed to stream data", (Throwable)exception);
            throw new ServletException((Throwable)exception);
        }
    }

    private String getRemoteClientInfo(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("X-Forwarded-For");
        if (string == null) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string;
    }
}

