/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.cm.impl.AfdCMSource;
import com.vmware.vise.vim.cm.impl.ComponentManagerSource;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentManagerLocator {
    private static final String CM_URL_KEY = "cm.url";
    private static final Log _logger = LogFactory.getLog(ComponentManagerLocator.class);
    private ComponentManagerSource _source;

    public ComponentManagerLocator(ConfigurationService configurationService, KeystoreService keystoreService) {
        this._source = this.initCMSource(configurationService, keystoreService);
    }

    public URI getServiceUri() {
        return this._source.getServiceUri();
    }

    public String getThumbprint() {
        return this._source.getThumbprint();
    }

    public KeyStore getKeyStore() {
        return this._source.getKeyStore();
    }

    private ComponentManagerSource initCMSource(ConfigurationService configurationService, KeystoreService keystoreService) {
        ComponentManagerSource componentManagerSource = null;
        componentManagerSource = AfdCMSource.tryCreate(configurationService, keystoreService);
        if (componentManagerSource != null) {
            return componentManagerSource;
        }
        _logger.info((Object)"Loading component manager url from a back up source.");
        componentManagerSource = ConfigServiceSource.tryCreate(configurationService, keystoreService);
        if (componentManagerSource != null) {
            return componentManagerSource;
        }
        _logger.warn((Object)"Created a default ComponentManagerSource.");
        return new ComponentManagerSource(keystoreService);
    }

    private static class ConfigServiceSource
    extends ComponentManagerSource {
        private final ConfigurationService _configService;

        public ConfigServiceSource(ConfigurationService configurationService, KeystoreService keystoreService) {
            super(keystoreService);
            this._configService = configurationService;
        }

        @Override
        public URI getServiceUri() {
            return ConfigServiceSource.toServiceUri(this._configService.getProperty(ComponentManagerLocator.CM_URL_KEY));
        }

        public static ConfigServiceSource tryCreate(ConfigurationService configurationService, KeystoreService keystoreService) {
            String string = configurationService.getProperty(ComponentManagerLocator.CM_URL_KEY);
            if (StringUtil.isNullOrEmpty((String)string)) {
                return null;
            }
            return new ConfigServiceSource(configurationService, keystoreService);
        }
    }
}

