/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.VimServicesUtil;
import com.vmware.vise.vim.commons.util.VmodlUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryDataUtil {
    private static final Log _logger = LogFactory.getLog(QueryDataUtil.class);

    @Deprecated
    public static <T extends ManagedObject> Class<T> wsdlNameToJavaType(String string) {
        return VmodlUtil.wsdlNameToJavaType((String)string);
    }

    public static Class<?> getClassFromTypeName(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains(".")) {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        return VmodlUtil.wsdlNameToJavaType((String)string);
    }

    public static Map<String, List<ResultItem>> getProperties(DataService dataService, Object[] objectArray, String[] stringArray) throws Exception {
        if (objectArray == null || objectArray.length == 0 || stringArray == null || stringArray.length == 0) {
            throw new Exception(QueryUtil.getLocalizedString((String)"error.invalidQueryInput"));
        }
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Object[])objectArray, (String[])stringArray);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        if (response.resultSet == null || response.resultSet.length == 0) {
            throw new Exception(QueryUtil.getLocalizedString((String)"error.emptyResult"));
        }
        ResultSet resultSet = response.resultSet[0];
        QueryDataUtil.throwIfObjectNotFound(objectArray, resultSet);
        QueryDataUtil.throwIfErrorAndNoResults(resultSet);
        HashMap<String, List<ResultItem>> hashMap = new HashMap<String, List<ResultItem>>();
        for (ResultItem resultItem : resultSet.items) {
            ArrayList<ResultItem> arrayList = (ArrayList<ResultItem>)hashMap.get(resultItem.resourceObject);
            if (arrayList == null) {
                arrayList = new ArrayList<ResultItem>();
                String string = QueryUtil.getReferenceUid((Object)resultItem.resourceObject);
                hashMap.put(string, arrayList);
            }
            arrayList.add(resultItem);
        }
        return hashMap;
    }

    public static QueryUtil.PropertyValueMap getPropertiesValue(DataService dataService, Object[] objectArray, String[] stringArray) throws Exception {
        if (objectArray == null || objectArray.length == 0 || stringArray == null || stringArray.length == 0) {
            throw new Exception(QueryUtil.getLocalizedString((String)"error.invalidQueryInput"));
        }
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Object[])objectArray, (String[])stringArray);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = new Response();
        response = dataService.getData(requestSpec);
        if (response.resultSet == null || response.resultSet.length == 0) {
            throw new Exception(QueryUtil.getLocalizedString((String)"error.emptyResult"));
        }
        ResultSet resultSet = response.resultSet[0];
        QueryDataUtil.throwIfObjectNotFound(objectArray, resultSet);
        QueryDataUtil.throwIfErrorAndNoResults(resultSet);
        QueryUtil.PropertyValueMap propertyValueMap = new QueryUtil.PropertyValueMap();
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem.properties == null) continue;
            for (PropertyValue propertyValue : resultItem.properties) {
                propertyValueMap.putProperty(propertyValue);
            }
        }
        return propertyValueMap;
    }

    public static void throwIfObjectNotFound(QuerySpec[] querySpecArray, ResultSet[] resultSetArray) throws ManagedObjectNotFound {
        if (querySpecArray == null || querySpecArray.length == 0) {
            return;
        }
        for (int i = 0; i < querySpecArray.length; ++i) {
            QuerySpec querySpec = querySpecArray[i];
            ResultSet resultSet = resultSetArray[i];
            Object[] objectArray = QueryDataUtil.extractTargetObjects(querySpec);
            QueryDataUtil.throwIfObjectNotFound(objectArray, resultSet);
        }
    }

    public static void throwIfObjectNotFound(QuerySpec querySpec, ResultSet resultSet) throws ManagedObjectNotFound {
        Object[] objectArray = QueryDataUtil.extractTargetObjects(querySpec);
        QueryDataUtil.throwIfObjectNotFound(objectArray, resultSet);
    }

    public static void throwIfObjectNotFound(Object[] objectArray, ResultSet resultSet) throws ManagedObjectNotFound {
        Object[] objectArray2 = QueryDataUtil.detectDeletedObjects(objectArray, resultSet);
        if (objectArray2.length == 0) {
            return;
        }
        throw QueryDataUtil.newObjectNotFoundFault(objectArray2);
    }

    public static Object[] detectDeletedObjects(QuerySpec[] querySpecArray, ResultSet[] resultSetArray) {
        if (querySpecArray == null || resultSetArray == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < querySpecArray.length; ++i) {
            Object[] objectArray;
            QuerySpec querySpec = querySpecArray[i];
            ResultSet resultSet = resultSetArray[i];
            Object[] objectArray2 = QueryDataUtil.extractTargetObjects(querySpec);
            for (Object object : objectArray = QueryDataUtil.detectDeletedObjects(objectArray2, resultSet)) {
                hashMap.put(QueryUtil.getReferenceUid((Object)object), object);
            }
        }
        Collection collection = hashMap.values();
        return collection.toArray();
    }

    public static Object[] detectDeletedObjects(Object[] objectArray, ResultSet resultSet) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        if (resultSet == null || resultSet.error != null) {
            return (Object[])Array.newInstance(objectArray[0].getClass(), 0);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object : objectArray) {
            hashMap.put(QueryUtil.getReferenceUid((Object)object), object);
        }
        if (resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                Object object = resultItem.resourceObject;
                if (object == null) continue;
                hashMap.remove(QueryUtil.getReferenceUid((Object)object));
            }
        }
        Collection collection = hashMap.values();
        return collection.toArray();
    }

    public static Object[] extractTargetObjects(QuerySpec querySpec) {
        if (querySpec == null || querySpec.resourceSpec == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        arrayList.add(querySpec.resourceSpec.constraint);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            Constraint constraint = (Constraint)arrayList.get(i);
            if (constraint instanceof ObjectIdentityConstraint) {
                object = ((ObjectIdentityConstraint)constraint).target;
                hashMap.put(QueryUtil.getReferenceUid((Object)object), object);
                continue;
            }
            if (!(constraint instanceof CompositeConstraint)) continue;
            object = (CompositeConstraint)constraint;
            if (!((CompositeConstraint)object).conjoiner.equals((Object)Conjoiner.OR) || ((CompositeConstraint)object).nestedConstraints == null) continue;
            for (Constraint constraint2 : ((CompositeConstraint)object).nestedConstraints) {
                arrayList.add(constraint2);
            }
        }
        Collection collection = hashMap.values();
        return collection.toArray();
    }

    private static void throwIfErrorAndNoResults(ResultSet resultSet) throws Exception {
        if (resultSet.error == null) {
            return;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            throw resultSet.error;
        }
        boolean bl = true;
        for (ResultItem resultItem : resultSet.items) {
            if (ArrayUtil.isNullOrEmpty((Object[])resultItem.properties)) continue;
            bl = false;
            break;
        }
        if (bl) {
            throw resultSet.error;
        }
    }

    private static ManagedObjectNotFound newObjectNotFoundFault(Object[] objectArray) {
        for (Object object : objectArray) {
            _logger.error((Object)String.format("The following object cannot be found: %s", object.toString()));
        }
        Object object = objectArray[0];
        ManagedObjectNotFound managedObjectNotFound = null;
        managedObjectNotFound = object instanceof ManagedObjectReference ? new ManagedObjectNotFound((ManagedObjectReference)object) : new ManagedObjectNotFound();
        managedObjectNotFound.setMessage(VimServicesUtil.getLocalizedString("error.objectNotFound", object.toString()));
        return managedObjectNotFound;
    }
}

