/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.login;

import com.vmware.vise.extensionfw.ExtensionFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.session.SessionUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class LoginExtensionFilter
implements ExtensionFilter {
    private static final String SESSION_PACKAGES_REFS = "PluginPackagesRefs";
    private final ExtensionService _extensionService;

    public LoginExtensionFilter(ExtensionService extensionService) {
        this._extensionService = extensionService;
    }

    public void filterPackages(Set<IdVersionPair> set) {
        Set<IdVersionPair> set2 = this.getDeployedPackagesFromSession();
        if (set2 == null) {
            return;
        }
        Iterator<IdVersionPair> iterator = set.iterator();
        while (iterator.hasNext()) {
            IdVersionPair idVersionPair = iterator.next();
            if (set2.contains(idVersionPair)) continue;
            iterator.remove();
        }
    }

    public void storeDeployedPackagesInSession(HttpSession httpSession) throws Exception {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (PluginPackageInfo pluginPackageInfo : this._extensionService.getAllPluginPackageInfos()) {
            hashSet.add(new IdVersionPair(pluginPackageInfo.getId(), pluginPackageInfo.getVersion()));
        }
        this.storeDeployedPackagesInSession(hashSet, httpSession);
    }

    protected void storeDeployedPackagesInSession(Set<IdVersionPair> set, HttpSession httpSession) {
        SessionUtil.setData((String)SESSION_PACKAGES_REFS, set, (HttpSession)httpSession);
    }

    protected Set<IdVersionPair> getDeployedPackagesFromSession() {
        return (Set)SessionUtil.getData((String)SESSION_PACKAGES_REFS);
    }
}

