/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.login;

import com.vmware.vise.extensionfw.ApplicationStartupMonitor;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.extension.login.LoginExtensionFilter;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginPluginDeploymentInitiator
implements UserSessionListener {
    protected static final String ASYNC_DEPLOYMENT_ENABLED_PROP = "newPlugins.deployAsync.enabled";
    private static final Log _logger = LogFactory.getLog(LoginPluginDeploymentInitiator.class);
    private final ApplicationStartupMonitor _applicationStartupMonitor;
    private final ExtensionService _extensionService;
    private final Executor _executor;
    private final LoginExtensionFilter _extensionFilter;
    private final BlockingQueue<SessionUtil.ThreadContext> _deployQueue;
    private final boolean _asyncDeploymentEnabled;

    public LoginPluginDeploymentInitiator(ApplicationStartupMonitor applicationStartupMonitor, ExtensionService extensionService, ConfigurationService configurationService, Executor executor, LoginExtensionFilter loginExtensionFilter) {
        this._applicationStartupMonitor = applicationStartupMonitor;
        this._extensionService = extensionService;
        this._executor = executor;
        this._extensionFilter = loginExtensionFilter;
        this._deployQueue = new ArrayBlockingQueue<SessionUtil.ThreadContext>(1);
        this._asyncDeploymentEnabled = Boolean.parseBoolean(configurationService.getProperty(ASYNC_DEPLOYMENT_ENABLED_PROP));
        if (this._asyncDeploymentEnabled) {
            _logger.info((Object)"Asynchronous plugin deployment is enabled.");
            this.startQueueProcessing();
        }
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        this._applicationStartupMonitor.waitForPostServerStartupPluginPackagesDeployment();
        if (this._asyncDeploymentEnabled) {
            this.deployNewPluginsAsync(httpSessionEvent.getSession());
        } else {
            this.deployNewPlugins();
        }
        this._extensionFilter.storeDeployedPackagesInSession(httpSessionEvent.getSession());
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
    }

    protected void beforeQueueWait(BlockingQueue<SessionUtil.ThreadContext> blockingQueue) {
    }

    protected void afterQueueWait(BlockingQueue<SessionUtil.ThreadContext> blockingQueue) {
    }

    private void deployNewPlugins() {
        SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
        this.deployNewPlugins(threadContext);
    }

    private void deployNewPluginsAsync(HttpSession httpSession) {
        SessionUtil.setHttpSession((HttpSession)httpSession);
        boolean bl = this._deployQueue.offer(SessionUtil.getThreadContext((boolean)true));
        if (_logger.isDebugEnabled()) {
            if (bl) {
                _logger.debug((Object)"Enqueue new plugin deployment.");
            } else {
                _logger.debug((Object)"New plugin deployment is already enqueued.");
            }
        }
    }

    private void startQueueProcessing() {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(ExtensionService.class.getClassLoader());
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        LoginPluginDeploymentInitiator.this.beforeQueueWait(LoginPluginDeploymentInitiator.this._deployQueue);
                        SessionUtil.ThreadContext threadContext = (SessionUtil.ThreadContext)LoginPluginDeploymentInitiator.this._deployQueue.take();
                        LoginPluginDeploymentInitiator.this.afterQueueWait(LoginPluginDeploymentInitiator.this._deployQueue);
                        LoginPluginDeploymentInitiator.this.deployNewPlugins(threadContext);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    private void deployNewPlugins(SessionUtil.ThreadContext threadContext) {
        try {
            _logger.info((Object)"Checking for new plugins...");
            long l = System.currentTimeMillis();
            SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
            Set set = this._extensionService.deployNewPackages();
            long l2 = System.currentTimeMillis() - l;
            if (set != null && set.size() != 0) {
                _logger.info((Object)(set.size() + " new plugins have been deployed.Deployment duration [ms]: " + l2));
            } else {
                _logger.info((Object)("No new plugins were found. Check duration [ms]: " + l2));
            }
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)"Failed to deploy new plugins", (Throwable)runtimeException);
        }
    }
}

