/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.util;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcExtensionUtil {
    private static final Log _logger = LogFactory.getLog(VcExtensionUtil.class);
    private static final String HTTP_ENABLED = "allowHttp";
    private static final String EXTENSION_ID_DELIMETER = "$$$";
    private static final VcExtensionUtil _instance = new VcExtensionUtil();

    public static Boolean isHttpDownloadAllowed(ConfigurationService configurationService) {
        String string = "false";
        if (configurationService != null && configurationService.getProperty(HTTP_ENABLED) != null) {
            string = configurationService.getProperty(HTTP_ENABLED);
        }
        return string.toLowerCase().equals("true");
    }

    public static String filterExtensionSpecificContent(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(EXTENSION_ID_DELIMETER);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        _logger.info((Object)("Returning filtered id: " + string2 + "from " + string));
        return string2;
    }

    public static Proxy getHttpProxy(ConfigurationService configurationService) {
        if (configurationService == null) {
            return null;
        }
        Proxy proxy = null;
        try {
            String string = configurationService.getProperty("proxyHost");
            String string2 = configurationService.getProperty("proxyPort");
            if (!StringUtil.isNullOrEmpty((String)string) && !StringUtil.isNullOrEmpty((String)string2)) {
                int n = Integer.valueOf(string2);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
                proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                String string3 = configurationService.getProperty("proxyUser");
                String string4 = configurationService.getProperty("proxyPassword");
                if (string3 != null && string4 != null) {
                    VcExtensionUtil vcExtensionUtil = _instance;
                    vcExtensionUtil.getClass();
                    Authenticator.setDefault(vcExtensionUtil.new ProxyAuthenticator(string3, string4));
                }
            } else if (!StringUtil.isNullOrEmpty((String)string) || !StringUtil.isNullOrEmpty((String)string2)) {
                _logger.error((Object)"Missing proxyHost or proxyPort in webclient.properties");
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Invalid proxyHost or proxyPort values in webclient.properties  ", (Throwable)exception);
        }
        return proxy;
    }

    class ProxyAuthenticator
    extends Authenticator {
        private String user;
        private String password;

        public ProxyAuthenticator(String string, String string2) {
            this.user = string;
            this.password = string2;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

