/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup;

import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CatalogServiceProviderInfo {
    private final String _productId;
    private final String _typeId;
    private final List<ResourceURL> _resourceURLs;
    private final List<String> _resourceBundleBaseNames;

    public CatalogServiceProviderInfo(Spec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{spec});
        this._productId = spec.productId;
        this._typeId = spec.typeId;
        this._resourceURLs = spec.resourceURLs;
        this._resourceBundleBaseNames = Collections.unmodifiableList(new ArrayList<String>(spec.resourceBundleBaseNames));
    }

    public String getProductId() {
        return this._productId;
    }

    public String getTypeId() {
        return this._typeId;
    }

    public List<ResourceURL> getResourceURLs() {
        return this._resourceURLs;
    }

    public List<String> getResourceBundleBaseName() {
        return this._resourceBundleBaseNames;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._productId == null ? 0 : this._productId.hashCode());
        n = 31 * n + (this._resourceURLs == null || this._resourceURLs.isEmpty() ? 0 : this._resourceURLs.get((int)0).resourceURI.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CatalogServiceProviderInfo)) {
            return false;
        }
        CatalogServiceProviderInfo catalogServiceProviderInfo = (CatalogServiceProviderInfo)object;
        if (this._productId == null ? catalogServiceProviderInfo._productId != null : !this._productId.equals(catalogServiceProviderInfo._productId)) {
            return false;
        }
        if (this._resourceURLs == null) {
            return catalogServiceProviderInfo._resourceURLs == null;
        }
        if (this._resourceURLs.isEmpty()) {
            if (catalogServiceProviderInfo._resourceURLs == null) {
                return false;
            }
            return catalogServiceProviderInfo._resourceURLs.isEmpty();
        }
        if (catalogServiceProviderInfo._resourceURLs == null) {
            return false;
        }
        if (catalogServiceProviderInfo._resourceURLs.isEmpty()) {
            return false;
        }
        return this._resourceURLs.get((int)0).resourceURI.equals(catalogServiceProviderInfo._resourceURLs.get((int)0).resourceURI);
    }

    public static class Spec {
        public String productId;
        public String typeId;
        public List<ResourceURL> resourceURLs = new ArrayList<ResourceURL>();
        public final List<String> resourceBundleBaseNames = new ArrayList<String>();
        private int _nextIndex = -1;

        ResourceURL getNextResourceUrl() {
            ++this._nextIndex;
            if (this._nextIndex >= this.resourceURLs.size()) {
                this._nextIndex = 0;
            }
            return this.resourceURLs.get(this._nextIndex);
        }
    }

    protected static class ResourceURL {
        public final URI resourceURI;
        public final String[] sslTrust;

        public ResourceURL(URI uRI, String[] stringArray) {
            this.resourceURI = uRI;
            this.sslTrust = stringArray;
        }
    }
}

